/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HttpResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsyncHttpStack
extends BaseHttpStack {
    private ExecutorService mBlockingExecutor;
    private ExecutorService mNonBlockingExecutor;

    public abstract void executeRequest(Request<?> var1, Map<String, String> var2, OnRequestComplete var3);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setNonBlockingExecutor(ExecutorService executor) {
        this.mNonBlockingExecutor = executor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setBlockingExecutor(ExecutorService executor) {
        this.mBlockingExecutor = executor;
    }

    protected ExecutorService getBlockingExecutor() {
        return this.mBlockingExecutor;
    }

    protected ExecutorService getNonBlockingExecutor() {
        return this.mNonBlockingExecutor;
    }

    @Override
    public final HttpResponse executeRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference entry = new AtomicReference();
        this.executeRequest(request, additionalHeaders, new OnRequestComplete(){

            @Override
            public void onSuccess(HttpResponse httpResponse) {
                Response response = new Response(httpResponse, null, null);
                entry.set(response);
                latch.countDown();
            }

            @Override
            public void onAuthError(AuthFailureError authFailureError) {
                Response response = new Response(null, null, authFailureError);
                entry.set(response);
                latch.countDown();
            }

            @Override
            public void onError(IOException ioException) {
                Response response = new Response(null, ioException, null);
                entry.set(response);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            VolleyLog.e(e, "while waiting for CountDownLatch", new Object[0]);
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(e.toString());
        }
        Response response = (Response)entry.get();
        if (response.httpResponse != null) {
            return response.httpResponse;
        }
        if (response.ioException != null) {
            throw response.ioException;
        }
        throw response.authFailureError;
    }

    private static class Response {
        HttpResponse httpResponse;
        IOException ioException;
        AuthFailureError authFailureError;

        private Response(@Nullable HttpResponse httpResponse, @Nullable IOException ioException, @Nullable AuthFailureError authFailureError) {
            this.httpResponse = httpResponse;
            this.ioException = ioException;
            this.authFailureError = authFailureError;
        }
    }

    public static interface OnRequestComplete {
        public void onSuccess(HttpResponse var1);

        public void onAuthError(AuthFailureError var1);

        public void onError(IOException var1);
    }
}

