/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wehttp2;

import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.wehttp2.EventReport;
import com.tencent.cloud.huiyansdkface.wehttp2.LogTag;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.Principal;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.List;

public class WeEventReport
implements EventReport {
    private final SimpleDateFormat a = new SimpleDateFormat("mm:ss.SSS");
    private final StringBuilder b = new StringBuilder();
    private final TimePointInfo c = new TimePointInfo();
    private final ReportCallback d;
    private Request e;

    public WeEventReport(Request request, ReportCallback reportCallback) {
        this.e = request;
        this.d = reportCallback;
    }

    @Override
    public void callStart() {
        this.c.a = System.currentTimeMillis();
        this.b.append("WeHttp Log: \n[[[").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(System.currentTimeMillis())).append("\t").append(this.e.url().toString()).append("]]]\n");
        LogTag logTag = this.e.tag(LogTag.class);
        if (logTag != null && logTag.getTag() != null) {
            this.b.append(logTag.getTag()).append("\n");
        }
        this.b.append(this.a(this.c.a)).append(":callStart\n");
    }

    @Override
    public void dnsStart(String string) {
        this.c.m++;
        this.c.b = System.currentTimeMillis();
        this.b.append(this.a(this.c.b)).append(":dnsStart:" + string).append("\n");
    }

    @Override
    public void dnsEnd(List<InetAddress> list) {
        long l2 = System.currentTimeMillis();
        this.c.g = l2 - this.c.b;
        this.b.append(this.a(l2)).append(":dnsEnd(").append(this.c.g).append("):");
        StringBuilder stringBuilder = this.b;
        if (list != null && list.size() > 0) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                InetAddress inetAddress = list.get(i2);
                stringBuilder.append(inetAddress.toString()).append(",");
            }
            stringBuilder.append(list.get(list.size() - 1));
        } else {
            stringBuilder.append("NONE");
        }
        this.b.append("\n");
    }

    @Override
    public void connectStart(InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.c.n++;
        this.c.c = System.currentTimeMillis();
        this.b.append(this.a(this.c.c)).append(":connectStart:").append(inetSocketAddress.toString()).append(",").append(proxy.toString()).append("\n");
    }

    @Override
    public void secureConnectStart() {
        this.c.d = System.currentTimeMillis();
        this.c.h = this.c.d - this.c.c;
        this.b.append(this.a(System.currentTimeMillis())).append(":secureConnectStart\n");
    }

    @Override
    public void secureConnectEnd(String string, String string2, Principal principal, Principal principal2, List<Certificate> list, List<Certificate> list2) {
        long l2 = System.currentTimeMillis();
        this.c.i = l2 - this.c.d;
        this.b.append(this.a(l2)).append(":secureConnectEnd(").append(this.c.i).append("):").append(string).append(",").append(string2).append(",").append(principal != null ? principal.getName() : "none localPrincipal").append(",").append(principal2 != null ? principal2.getName() : "none peerPrincipal").append(",").append(list != null ? list.size() : 0).append(",").append(list2 != null ? list2.size() : 0).append("\n");
    }

    @Override
    public void connectEnd(String string) {
        if (!this.e.isHttps()) {
            this.c.h = System.currentTimeMillis() - this.c.c;
        }
        this.b.append(this.a(System.currentTimeMillis())).append(":connectEnd(").append(this.c.h).append("):").append(string).append("\n");
    }

    @Override
    public void connectFailed(String string, IOException iOException) {
        long l2 = System.currentTimeMillis();
        if (!this.e.isHttps() || this.c.h <= 0L) {
            this.c.h = l2 - this.c.c;
        }
        if (this.e.isHttps() && this.c.d > 0L && this.c.i <= 0L) {
            this.c.i = l2 - this.c.d;
        }
        this.b.append(this.a(l2)).append(":connectFailed(").append(this.c.h).append("):").append(string).append(":").append(iOException).append("\n");
    }

    @Override
    public void connectionAcquired() {
        this.b.append(this.a(System.currentTimeMillis())).append(":connectionAcquired\n");
    }

    @Override
    public void connectionReleased() {
        this.b.append(this.a(System.currentTimeMillis())).append(":connectionReleased\n");
    }

    @Override
    public void requestHeadersStart() {
        this.c.e = System.currentTimeMillis();
        this.b.append(this.a(this.c.e)).append(":requestHeadersStart\n");
    }

    @Override
    public void requestHeadersEnd() {
        this.b.append(this.a(System.currentTimeMillis())).append(":requestHeadersEnd\n");
    }

    @Override
    public void requestBodyStart() {
        this.b.append(this.a(System.currentTimeMillis())).append(":requestBodyStart\n");
    }

    @Override
    public void requestBodyEnd(long l2) {
        long l3 = System.currentTimeMillis();
        this.c.j = l3 - this.c.e;
        this.b.append(this.a(l3)).append(":requestBodyEnd(").append(this.c.j).append("):").append(l2).append("\n");
    }

    @Override
    public void responseHeadersStart() {
        this.c.f = System.currentTimeMillis();
        this.b.append(this.a(this.c.f)).append(":responseHeadersStart\n");
    }

    @Override
    public void responseHeadersEnd(int n2, String string, long l2, long l3) {
        this.b.append(this.a(System.currentTimeMillis())).append(":responseHeadersEnd:").append(n2).append(",").append(string).append(",").append(this.b(l2)).append(",").append(this.b(l3)).append("\n");
    }

    @Override
    public void responseBodyStart() {
        this.b.append(this.a(System.currentTimeMillis())).append(":responseBodyStart\n");
    }

    @Override
    public void responseBodyEnd(long l2) {
        long l3 = System.currentTimeMillis();
        this.c.k = l3 - this.c.f;
        this.b.append(this.a(l3)).append(":responseBodyEnd(").append(this.c.k).append("):").append(l2).append("\n");
    }

    @Override
    public void callEnd() {
        this.b.append(this.a(System.currentTimeMillis())).append(":callEnd\n");
        this.a();
        this.b.append("Statistical data\uff1a\n");
        this.b.append("\tdnsUseTime:").append(this.c.g).append("\n");
        this.b.append("\tsecureConnectUseTime:").append(this.c.i).append("\n");
        this.b.append("\tconnectUseTime:").append(this.c.h).append("\n");
        this.b.append("\treqUseTime:").append(this.c.j).append("\n");
        this.b.append("\trespUseTime:").append(this.c.k).append("\n");
        this.b.append("\ttotalUseTime:").append(this.c.l).append("\n");
        if (this.d != null) {
            this.d.reportFinish(this.c, this.b);
        }
    }

    private void a() {
        this.c.l = System.currentTimeMillis() - this.c.a;
        this.b.insert(this.b.indexOf("]]]"), "(" + this.c.l + ")");
    }

    @Override
    public void callFailed(IOException iOException) {
        this.b.append(this.a(System.currentTimeMillis())).append(":callFailed:").append(iOException).append("\n");
        this.a();
        if (this.d != null) {
            this.d.reportFinish(this.c, this.b);
        }
    }

    private String a(long l2) {
        return this.a.format(l2);
    }

    private String b(long l2) {
        return this.a.format(l2);
    }

    public static class TimePointInfo {
        private long a;
        private long b;
        private long c;
        private long d;
        private long e;
        private long f;
        private long g;
        private long h;
        private long i;
        private long j;
        private long k;
        private long l;
        private int m;
        private int n;

        public long getStartTime() {
            return this.a;
        }

        public long getDnsStart() {
            return this.b;
        }

        public long getConnectStart() {
            return this.c;
        }

        public long getSecureConnectStart() {
            return this.d;
        }

        public long getReqStart() {
            return this.e;
        }

        public long getRespStart() {
            return this.f;
        }

        public long getDnsUseTime() {
            return this.g;
        }

        public long getConnectUseTime() {
            return this.h;
        }

        public long getSecureConnectUseTime() {
            return this.i;
        }

        public long getReqUseTime() {
            return this.j;
        }

        public long getRespUseTime() {
            return this.k;
        }

        public long getCallUseTime() {
            return this.l;
        }

        public int getDnsStartCount() {
            return this.m;
        }

        public int getConnectStartCount() {
            return this.n;
        }
    }

    public static interface ReportCallback {
        public void reportFinish(TimePointInfo var1, StringBuilder var2);
    }
}

