/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wehttp2;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.cloud.huiyansdkface.okhttp3.CertificatePinner;
import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionSpec;
import com.tencent.cloud.huiyansdkface.okhttp3.Credentials;
import com.tencent.cloud.huiyansdkface.okhttp3.Dispatcher;
import com.tencent.cloud.huiyansdkface.okhttp3.Dns;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.TlsVersion;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.wehttp2.ContextHelper;
import com.tencent.cloud.huiyansdkface.wehttp2.MemoryCookieJar;
import com.tencent.cloud.huiyansdkface.wehttp2.MockInterceptor;
import com.tencent.cloud.huiyansdkface.wehttp2.Pin;
import com.tencent.cloud.huiyansdkface.wehttp2.PinProvider;
import com.tencent.cloud.huiyansdkface.wehttp2.RetryInterceptor;
import com.tencent.cloud.huiyansdkface.wehttp2.TimeoutInterceptor;
import com.tencent.cloud.huiyansdkface.wehttp2.Tls12SocketFactory;
import com.tencent.cloud.huiyansdkface.wehttp2.TypeAdapter;
import com.tencent.cloud.huiyansdkface.wehttp2.WeConfigLoader;
import com.tencent.cloud.huiyansdkface.wehttp2.WeCookie;
import com.tencent.cloud.huiyansdkface.wehttp2.WeCookieLog;
import com.tencent.cloud.huiyansdkface.wehttp2.WeDns;
import com.tencent.cloud.huiyansdkface.wehttp2.WeLog;
import com.tencent.cloud.huiyansdkface.wehttp2.WeTypeAdapter;
import com.tencent.cloud.huiyansdkface.wehttp2.WeWebViewCookie;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class WeConfig {
    private static int a = -1;
    private volatile OkHttpClient b;
    private OkHttpClient.Builder c;
    private boolean d = false;
    private WeConfigLoader e;
    private volatile String f;
    private Map<String, String> g = new HashMap<String, String>();
    private Map<String, String> h = new HashMap<String, String>();
    private Object i = new Object();
    private volatile boolean j = false;
    private volatile String k;
    private List<Pin> l = new ArrayList<Pin>();
    private volatile PinProvider m;
    private volatile TypeAdapter n;
    private volatile WeCookie o;
    private volatile WeLog p;
    private volatile WeCookieLog q;
    private volatile MockInterceptor r;
    private volatile RetryInterceptor s;
    private boolean t = false;
    private volatile IpStrategy u = IpStrategy.a;
    private volatile WeDns v;
    private Context w;
    private String x;
    private String y;
    private String z;
    private KeyManagerFactory A;
    private WeLog.ILogTag B = new WeLog.ILogTag(this){

        @Override
        public String tag(HttpUrl object, Object object2) {
            if (object2 != null) {
                return object2.toString();
            }
            object = ((HttpUrl)object).pathSegments();
            return "[" + (object != null && object.size() > 0 ? (String)object.get(object.size() - 1) : "req" + WeConfig.b()) + "] ";
        }
    };
    private Dispatcher C;

    private static synchronized int b() {
        return ++a;
    }

    public WeConfig() {
    }

    public WeConfig(String string) {
        this(null, string);
    }

    public WeConfig(Context context, String string) {
        context = context == null ? ContextHelper.getContext() : context.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("savedConfigName is empty");
        }
        if (context != null) {
            this.w = context;
            this.e = new WeConfigLoader(context, this, string);
            this.e.loadOnce();
        }
    }

    public WeConfig(WeConfigLoader weConfigLoader) {
        if (weConfigLoader == null) {
            throw new IllegalArgumentException("configLoader must not be null");
        }
        weConfigLoader.loadOnce();
        this.e = weConfigLoader;
    }

    public WeConfigLoader getConfigLoader() {
        return this.e;
    }

    public WeConfig saveConfig() {
        if (this.e == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.e.save();
        return this;
    }

    public WeConfig supportTls12Before5(boolean bl) {
        this.t = bl;
        return this;
    }

    public WeConfig adapter(TypeAdapter typeAdapter) {
        this.n = typeAdapter;
        return this;
    }

    public WeConfig addMock(MockInterceptor.Mock ... mockArray) {
        this.mockConfig();
        for (int i2 = mockArray.length - 1; i2 >= 0; --i2) {
            this.r.addMock(mockArray[i2]);
        }
        return this;
    }

    public WeConfig dns(WeDns weDns) {
        this.v = weDns;
        return this;
    }

    public WeConfig ipStrategy(IpStrategy ipStrategy) {
        if (ipStrategy != null) {
            this.u = ipStrategy;
        }
        return this;
    }

    public MockInterceptor mockConfig() {
        if (this.r == null) {
            this.r = new MockInterceptor();
        }
        return this.r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeAdapter adapter() {
        if (this.n == null) {
            WeConfig weConfig = this;
            synchronized (weConfig) {
                if (this.n == null) {
                    this.n = new WeTypeAdapter();
                }
            }
        }
        return this.n;
    }

    public WeConfig proxy(String string, int n2, String string2, String string3) {
        this.clientConfig().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n2)));
        this.header("Proxy-Authorization", Credentials.basic(string2, string3));
        return this;
    }

    public WeConfig timeout(long l2, long l3, long l4) {
        this.clientConfig().connectTimeout(l2, TimeUnit.SECONDS).readTimeout(l3, TimeUnit.SECONDS).writeTimeout(l4, TimeUnit.SECONDS);
        return this;
    }

    public WeConfig timeoutInMillis(long l2, long l3, long l4) {
        this.clientConfig().connectTimeout(l2, TimeUnit.MILLISECONDS).readTimeout(l3, TimeUnit.MILLISECONDS).writeTimeout(l4, TimeUnit.MILLISECONDS);
        return this;
    }

    public WeConfig callTimeoutInMillis(long l2) {
        this.clientConfig().callTimeout(l2, TimeUnit.MILLISECONDS);
        return this;
    }

    public WeConfig pinProvider(PinProvider pinProvider) {
        this.m = pinProvider;
        return this;
    }

    @Deprecated
    public WeConfig setPin4Host(String string, String ... stringArray) {
        return this.addPin4Host(string, stringArray);
    }

    @Deprecated
    public WeConfig setPin4DefHost(String ... stringArray) {
        return this.addPin4DefHost(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeConfig clearPin4Host(String string) {
        Object object = this.i;
        synchronized (object) {
            Iterator<Pin> iterator = this.l.iterator();
            while (iterator.hasNext()) {
                Pin pin = iterator.next();
                if (!pin.getPattern().equals(string)) continue;
                iterator.remove();
            }
        }
        return this;
    }

    public WeConfig setCertVerify(boolean bl) {
        this.j = bl;
        return this;
    }

    public boolean isCertVerify() {
        return this.j;
    }

    public WeConfig pinCheckHost(String string) {
        if (string == null) {
            return this;
        }
        this.k = string;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPins(String string) {
        Set<String> set;
        if (!this.j) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.m != null && (set = this.m.getPinSet(string)) != null && set.size() > 0) {
            hashSet.addAll(set);
        }
        set = this.i;
        synchronized (set) {
            for (Pin pin : this.l) {
                if (!pin.match(string)) continue;
                hashSet.add(pin.getPin());
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeConfig addPin(Pin ... pinArray) {
        if (pinArray != null && pinArray.length > 0) {
            Object object = this.i;
            synchronized (object) {
                for (Pin pin : pinArray) {
                    if (pin == null || pin.getPattern() == null || pin.getPin() == null) continue;
                    this.l.add(pin);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeConfig addPin4Host(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (string == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        Object object = this.i;
        synchronized (object) {
            if (stringArray != null && stringArray.length == 1) {
                this.l.add(new Pin(string, stringArray[0]));
                return this;
            }
            this.l.addAll(Pin.create(string, stringArray));
        }
        return this;
    }

    public WeConfig addPin4DefHost(String ... stringArray) {
        return this.addPin4Host(this.k, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pin> getPinList() {
        Object object = this.i;
        synchronized (object) {
            return Collections.unmodifiableList(this.l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPin4HostPattern(String string) {
        Object object = this.i;
        synchronized (object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Pin pin : this.l) {
                if (!pin.getPattern().equals(string)) continue;
                arrayList.add(pin.getPin());
            }
            return arrayList;
        }
    }

    public String pinListToString() {
        return this.pinListToString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pinListToString(String object) {
        Object object2 = this.i;
        synchronized (object2) {
            List<String> list;
            HashMap<String, ArrayList<String>> object32 = new HashMap<String, ArrayList<String>>();
            for (Pin pin : this.l) {
                String string = pin.getPattern();
                if (object != null && !((String)((Object)object)).equals(string)) continue;
                list = (ArrayList<String>)object32.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    object32.put(string, (ArrayList<String>)list);
                }
                list.add(pin.getPin());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : object32.entrySet()) {
                stringBuilder.append((String)entry.getKey() + ":\n");
                list = (List)entry.getValue();
                for (String string : list) {
                    stringBuilder.append("\t" + string);
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString().trim();
        }
    }

    public Map<String, String> getHeaders() {
        return this.g;
    }

    public Map<String, String> getParams() {
        return this.h;
    }

    public WeConfig header(String string, String string2) {
        this.g.put(string, string2);
        return this;
    }

    public WeConfig header(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return this;
        }
        this.g.putAll(map);
        return this;
    }

    public WeConfig log(WeLog.Level level, WeLog.Logger logger) {
        return this.log(level, false, false, null, logger);
    }

    public WeLog.ILogTag iLogTag() {
        return this.B;
    }

    public WeConfig log(WeLog.Builder builder) {
        if (this.p != null) {
            this.p.setLevel(builder.e).prettyLog(builder.a).logTag(builder.b).setLogger(builder.g);
            this.p.cutLongStr(builder.c);
            this.p.longStrLength(builder.d);
        }
        this.p = builder.build();
        this.q = new WeCookieLog(this.p);
        if (builder.f != null) {
            this.B = builder.f;
        }
        return this;
    }

    public WeConfig log(WeLog.Level level, boolean bl, boolean bl2, WeLog.ILogTag iLogTag, WeLog.Logger logger) {
        if (this.p != null) {
            this.p.setLevel(level).prettyLog(bl).logTag(bl2).setLogger(logger);
            return this;
        }
        this.p = new WeLog.Builder().setLevel(level).setPrettyLog(bl).setLogWithTag(bl2).setLogger(logger).build();
        if (iLogTag != null) {
            this.B = iLogTag;
        }
        return this;
    }

    public WeConfig retryCount(int n2) {
        return this.retryConfig(n2, null);
    }

    public WeConfig retryConfig(int n2, RetryInterceptor.RetryStrategy retryStrategy) {
        if (this.s == null) {
            this.s = new RetryInterceptor(n2, retryStrategy);
        }
        this.s.setRetryStrategy(retryStrategy);
        this.s.setMaxRetryCount(n2);
        return this;
    }

    public WeConfig log(WeLog.Level level) {
        return this.log(level, WeLog.a);
    }

    public WeConfig cookie(WeCookie weCookie) {
        this.o = weCookie;
        if (weCookie != null) {
            this.clientConfig().cookieJar(weCookie);
        }
        return this;
    }

    public WeConfig cookieMemory() {
        this.o = new MemoryCookieJar();
        this.clientConfig().cookieJar(this.o);
        return this;
    }

    public WeConfig cookieWebView(Context context) {
        this.o = new WeWebViewCookie(context);
        this.clientConfig().cookieJar(this.o);
        return this;
    }

    public WeCookie cookie() {
        return this.o;
    }

    public WeConfig clientKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.A = keyManagerFactory;
        return this;
    }

    public WeConfig clientCertPath(Context context, String string, String string2, String string3) {
        this.x = string;
        this.w = context.getApplicationContext();
        this.y = string2;
        this.z = string3;
        return this;
    }

    public WeConfig params(String string, String string2) {
        this.h.put(string, string2);
        return this;
    }

    public WeConfig params(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        this.h.putAll(map);
        return this;
    }

    public WeConfig baseUrl(String string) {
        if (string != null && !string.endsWith("/")) {
            string = string + "/";
        }
        this.f = string;
        return this;
    }

    public String getBaseUrl() {
        return this.f;
    }

    public String getUrl(String string) {
        if (string == null) {
            return this.f;
        }
        if ((string = string.trim()).startsWith("https://") || string.startsWith("http://")) {
            return string;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return this.f + string;
    }

    public WeConfig dispatcherConfig(int n2, int n3, Runnable runnable) {
        if (this.C == null) {
            this.C = new Dispatcher();
            this.clientConfig().dispatcher(this.C);
        }
        this.C.setIdleCallback(runnable);
        this.C.setMaxRequests(n2);
        this.C.setMaxRequestsPerHost(n3);
        return this;
    }

    public OkHttpClient.Builder clientConfig() {
        if (this.c == null) {
            this.c = new OkHttpClient.Builder();
        }
        if (this.d) {
            Log.w((String)"WeConfig", (String)"config after request");
        }
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClient client() {
        if (this.b == null) {
            WeConfig weConfig = this;
            synchronized (weConfig) {
                if (this.b == null) {
                    this.clientConfig().dns(new Dns(this){
                        private /* synthetic */ WeConfig b;
                        {
                            this.b = weConfig;
                        }

                        @Override
                        public List<InetAddress> lookup(String string) throws UnknownHostException {
                            return WeConfig.a(this.b, string);
                        }
                    });
                    Object object = new CertificatePinner.Builder();
                    this.clientConfig().certificatePinner(((CertificatePinner.Builder)object).pinProvider(new CertificatePinner.CertificatePinProvider(this){
                        private /* synthetic */ WeConfig a;
                        {
                            this.a = weConfig;
                        }

                        @Override
                        public Set<String> getPins(String string) {
                            return this.a.getPins(string);
                        }

                        @Override
                        public void onPinVerifyFailed(String string, List<String> list) {
                            if (this.a.m != null) {
                                this.a.m.onPinVerifyFailed(string, list);
                            }
                        }
                    }).build());
                    object = this;
                    ((WeConfig)object).clientConfig().addInterceptor(new TimeoutInterceptor());
                    object = this;
                    ((WeConfig)object).clientConfig().addInterceptor(new Interceptor((WeConfig)object){
                        private /* synthetic */ WeConfig a;
                        {
                            this.a = weConfig;
                        }

                        @Override
                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            if (this.a.s != null) {
                                return this.a.s.intercept(chain);
                            }
                            return chain.proceed(chain.request());
                        }
                    });
                    object = this;
                    ((WeConfig)object).clientConfig().addInterceptor(new Interceptor((WeConfig)object){
                        private /* synthetic */ WeConfig a;
                        {
                            this.a = weConfig;
                        }

                        @Override
                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            WeLog weLog = this.a.p;
                            if (weLog == null) {
                                return chain.proceed(chain.request());
                            }
                            return weLog.intercept(chain);
                        }
                    });
                    ((WeConfig)object).clientConfig().addNetworkInterceptor(new Interceptor((WeConfig)object){
                        private /* synthetic */ WeConfig a;
                        {
                            this.a = weConfig;
                        }

                        @Override
                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            if (this.a.q != null) {
                                return this.a.q.intercept(chain);
                            }
                            return chain.proceed(chain.request());
                        }
                    });
                    object = this;
                    ((WeConfig)object).clientConfig().addInterceptor(new Interceptor((WeConfig)object){
                        private /* synthetic */ WeConfig a;
                        {
                            this.a = weConfig;
                        }

                        @Override
                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            if (this.a.r != null) {
                                return this.a.r.intercept(chain);
                            }
                            return chain.proceed(chain.request());
                        }
                    });
                    if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 21 && this.t) {
                        if (this.x != null) {
                            this.a(this.clientConfig(), this.d());
                        } else {
                            this.a(this.clientConfig(), null);
                        }
                    } else if (this.x != null) {
                        this.clientConfig().sslSocketFactory(this.d(), WeConfig.c());
                    }
                    this.b = this.clientConfig().build();
                    if (this.e != null) {
                        this.e.save();
                    }
                    this.d = true;
                }
            }
        }
        return this.b;
    }

    private static X509TrustManager c() {
        try {
            Object[] objectArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            objectArray.init((KeyStore)null);
            objectArray = objectArray.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            KeyStoreException keyStoreException2 = keyStoreException;
            keyStoreException.printStackTrace();
        }
        return null;
    }

    private SSLSocketFactory d() {
        try {
            SSLContext sSLContext = Platform.get().getSSLContext();
            Object object = this.A;
            if (object == null && this.x != null) {
                object = this.w.getAssets().open(this.x);
                KeyStore keyStore = KeyStore.getInstance(this.y == null ? "PKCS12" : this.y);
                keyStore.load((InputStream)object, this.z.toCharArray());
                object = KeyManagerFactory.getInstance("X509");
                ((KeyManagerFactory)object).init(keyStore, this.z.toCharArray());
            }
            sSLContext.init(object == null ? null : ((KeyManagerFactory)object).getKeyManagers(), null, null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    private void a(OkHttpClient.Builder builder, SSLSocketFactory object) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 21) {
            try {
                if (object == null) {
                    object = SSLContext.getInstance("TLS");
                    ((SSLContext)object).init(null, null, null);
                    object = ((SSLContext)object).getSocketFactory();
                }
                builder.sslSocketFactory(new Tls12SocketFactory((SSLSocketFactory)object), WeConfig.c());
                object = new ConnectionSpec.Builder(ConnectionSpec.a).tlsVersions(TlsVersion.b).build();
                ArrayList<ConnectionSpec> arrayList = new ArrayList<ConnectionSpec>();
                arrayList.add((ConnectionSpec)object);
                arrayList.add(ConnectionSpec.b);
                arrayList.add(ConnectionSpec.c);
                builder.connectionSpecs(arrayList);
                return;
            }
            catch (Exception exception) {
                Log.e((String)"OkHttpTLSCompat", (String)"Error while setting TLS 1.2", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ List a(WeConfig weConfig, String list) throws UnknownHostException {
        list = weConfig.v != null ? weConfig.v.lookup((String)((Object)list)) : Dns.a.lookup((String)((Object)list));
        if (weConfig.u == null || weConfig.u == IpStrategy.a || list == null || list.size() == 0) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
        ArrayList<InetAddress> arrayList3 = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : list) {
            if (inetAddress instanceof Inet4Address) {
                arrayList2.add(inetAddress);
                continue;
            }
            arrayList3.add(inetAddress);
        }
        if (weConfig.u == IpStrategy.b) {
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
        } else if (weConfig.u == IpStrategy.c) {
            arrayList.addAll(arrayList3);
            arrayList.addAll(arrayList2);
        } else {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static enum IpStrategy {
        a,
        b,
        c;

    }
}

