/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okio;

import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Options;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import com.tencent.cloud.huiyansdkface.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer = new Buffer();
    public final Source source;
    boolean closed;

    RealBufferedSource(Source source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
    }

    @Override
    public final Buffer buffer() {
        return this.buffer;
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        long l3;
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (l3 = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1L;
        }
        l3 = Math.min(l2, this.buffer.size);
        return this.buffer.read(buffer, l3);
    }

    @Override
    public final boolean exhausted() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
    }

    @Override
    public final void require(long l2) throws IOException {
        if (!this.request(l2)) {
            throw new EOFException();
        }
    }

    @Override
    public final boolean request(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (this.buffer.size < l2) {
            if (this.source.read(this.buffer, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public final ByteString readByteString() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public final ByteString readByteString(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteString(l2);
    }

    @Override
    public final int select(Options options) throws IOException {
        int n2;
        block3: {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            do {
                if ((n2 = this.buffer.selectPrefix(options, true)) == -1) {
                    return -1;
                }
                if (n2 != -2) break block3;
            } while (this.source.read(this.buffer, 8192L) != -1L);
            return -1;
        }
        int n3 = options.byteStrings[n2].size();
        this.buffer.skip(n3);
        return n2;
    }

    @Override
    public final byte[] readByteArray() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public final byte[] readByteArray(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteArray(l2);
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        try {
            this.require(byArray.length);
        }
        catch (EOFException eOFException) {
            int n2 = 0;
            while (this.buffer.size > 0L) {
                int n3 = this.buffer.read(byArray, n2, (int)this.buffer.size);
                if (n3 == -1) {
                    throw new AssertionError();
                }
                n2 += n3;
            }
            throw eOFException;
        }
        this.buffer.readFully(byArray);
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        long l2;
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        if (this.buffer.size == 0L && (l2 = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1;
        }
        int n4 = (int)Math.min((long)n3, this.buffer.size);
        return this.buffer.read(byArray, n2, n4);
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        long l2;
        if (this.buffer.size == 0L && (l2 = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public final void readFully(Buffer buffer, long l2) throws IOException {
        try {
            this.require(l2);
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(buffer, l2);
    }

    @Override
    public final long readAll(Sink sink) throws IOException {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        long l2 = 0L;
        while (this.source.read(this.buffer, 8192L) != -1L) {
            long l3 = this.buffer.completeSegmentByteCount();
            if (l3 <= 0L) continue;
            l2 += l3;
            sink.write(this.buffer, l3);
        }
        if (this.buffer.size() > 0L) {
            l2 += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l2;
    }

    @Override
    public final String readUtf8() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public final String readUtf8(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readUtf8(l2);
    }

    @Override
    public final String readString(Charset charset) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    public final String readString(long l2, Charset charset) throws IOException {
        this.require(l2);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return this.buffer.readString(l2, charset);
    }

    @Override
    public final String readUtf8Line() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            if (this.buffer.size != 0L) {
                return this.readUtf8(this.buffer.size);
            }
            return null;
        }
        return this.buffer.readUtf8Line(l2);
    }

    @Override
    public final String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public final String readUtf8LineStrict(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("limit < 0: " + l2);
        }
        long l3 = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : l2 + 1L;
        long l4 = this.indexOf((byte)10, 0L, l3);
        if (l4 != -1L) {
            return this.buffer.readUtf8Line(l4);
        }
        if (l3 < Long.MAX_VALUE && this.request(l3) && this.buffer.getByte(l3 - 1L) == 13 && this.request(l3 + 1L) && this.buffer.getByte(l3) == 10) {
            return this.buffer.readUtf8Line(l3);
        }
        Buffer buffer = new Buffer();
        this.buffer.copyTo(buffer, 0L, Math.min(32L, this.buffer.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.buffer.size(), l2) + " content=" + buffer.readByteString().hex() + '\u2026');
    }

    @Override
    public final int readUtf8CodePoint() throws IOException {
        this.require(1L);
        byte by = this.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public final short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public final short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public final int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public final int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public final long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public final long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public final long readDecimalLong() throws IOException {
        this.require(1L);
        int n2 = 0;
        while (this.request(n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (!(by >= 48 && by <= 57 || n2 == 0 && by == 45)) {
                if (n2 != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9] or '-' character but was %#x", by));
            }
            ++n2;
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public final long readHexadecimalUnsignedLong() throws IOException {
        this.require(1L);
        int n2 = 0;
        while (this.request(n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (!(by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70)) {
                if (n2 != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9a-fA-F] character but was %#x", by));
            }
            ++n2;
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public final void skip(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (l2 > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                throw new EOFException();
            }
            long l3 = Math.min(l2, this.buffer.size());
            this.buffer.skip(l3);
            l2 -= l3;
        }
    }

    @Override
    public final long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public final long indexOf(byte by, long l2) throws IOException {
        return this.indexOf(by, l2, Long.MAX_VALUE);
    }

    @Override
    public final long indexOf(byte by, long l2, long l3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (l2 < 0L || l3 < l2) {
            throw new IllegalArgumentException(String.format("fromIndex=%s toIndex=%s", l2, l3));
        }
        while (l2 < l3) {
            long l4 = this.buffer.indexOf(by, l2, l3);
            if (l4 != -1L) {
                return l4;
            }
            long l5 = this.buffer.size;
            if (l5 >= l3 || this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l5);
        }
        return -1L;
    }

    @Override
    public final long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public final long indexOf(ByteString byteString, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l3;
        while ((l3 = this.buffer.indexOf(byteString, l2)) == -1L) {
            long l4 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l4 - (long)byteString.size() + 1L);
        }
        return l3;
    }

    @Override
    public final long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public final long indexOfElement(ByteString byteString, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l3;
        while ((l3 = this.buffer.indexOfElement(byteString, l2)) == -1L) {
            long l4 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l4);
        }
        return l3;
    }

    @Override
    public final boolean rangeEquals(long l2, ByteString byteString) throws IOException {
        return this.rangeEquals(l2, byteString, 0, byteString.size());
    }

    @Override
    public final boolean rangeEquals(long l2, ByteString byteString, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (l2 < 0L || n2 < 0 || n3 < 0 || byteString.size() - n2 < n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            long l3 = l2 + (long)i2;
            if (!this.request(l3 + 1L)) {
                return false;
            }
            if (this.buffer.getByte(l3) == byteString.getByte(n2 + i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                long l2;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                if (RealBufferedSource.this.buffer.size == 0L && (l2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                long l2;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                Util.checkOffsetAndCount(byArray.length, n2, n3);
                if (RealBufferedSource.this.buffer.size == 0L && (l2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(byArray, n2, n3);
            }

            @Override
            public int available() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    public final String toString() {
        return "buffer(" + this.source + ")";
    }
}

