/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okio;

import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.DeflaterSink;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Segment;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import com.tencent.cloud.huiyansdkface.okio.Util;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class GzipSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private final DeflaterSink deflaterSink;
    private boolean closed;
    private final CRC32 crc = new CRC32();

    public GzipSink(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        this.deflater = new Deflater(-1, true);
        this.sink = Okio.buffer(sink);
        this.deflaterSink = new DeflaterSink(this.sink, this.deflater);
        this.writeHeader();
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (l2 == 0L) {
            return;
        }
        this.updateCrc(buffer, l2);
        this.deflaterSink.write(buffer, l2);
    }

    @Override
    public final void flush() throws IOException {
        this.deflaterSink.flush();
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public final void close() throws IOException {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.deflaterSink.finishDeflate();
                    this.writeFooter();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable4) {
                    if (throwable != null) break block8;
                    throwable = throwable4;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable5) {
                if (throwable != null) break block9;
                throwable = throwable5;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    public final Deflater deflater() {
        return this.deflater;
    }

    private void writeHeader() {
        Buffer buffer = this.sink.buffer();
        buffer.writeShort(8075);
        buffer.writeByte(8);
        buffer.writeByte(0);
        buffer.writeInt(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
    }

    private void writeFooter() throws IOException {
        this.sink.writeIntLe((int)this.crc.getValue());
        this.sink.writeIntLe((int)this.deflater.getBytesRead());
    }

    private void updateCrc(Buffer object, long l2) {
        object = ((Buffer)object).head;
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)(((Segment)object).limit - ((Segment)object).pos));
            this.crc.update(((Segment)object).data, ((Segment)object).pos, n2);
            l2 -= (long)n2;
            object = ((Segment)object).next;
        }
    }
}

