/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okio;

import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.Segment;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import com.tencent.cloud.huiyansdkface.okio.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    static AsyncTimeout head;
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long l2 = this.timeoutNanos();
        boolean bl = this.hasDeadline();
        if (l2 == 0L && !bl) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l2, bl);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l2, boolean bl) {
        if (head == null) {
            head = new AsyncTimeout();
            new Watchdog().start();
        }
        long l3 = System.nanoTime();
        if (l2 != 0L && bl) {
            asyncTimeout.timeoutAt = l3 + Math.min(l2, asyncTimeout.deadlineNanoTime() - l3);
        } else if (l2 != 0L) {
            asyncTimeout.timeoutAt = l3 + l2;
        } else if (bl) {
            asyncTimeout.timeoutAt = asyncTimeout.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long l4 = asyncTimeout.remainingNanos(l3);
        AsyncTimeout asyncTimeout2 = head;
        while (true) {
            if (asyncTimeout2.next == null || l4 < asyncTimeout2.next.remainingNanos(l3)) {
                asyncTimeout.next = asyncTimeout2.next;
                asyncTimeout2.next = asyncTimeout;
                if (asyncTimeout2 != head) break;
                AsyncTimeout.class.notify();
                return;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            if (asyncTimeout2.next == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
        return true;
    }

    private long remainingNanos(long l2) {
        return this.timeoutAt - l2;
    }

    protected void timedOut() {
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){

            @Override
            public void write(Buffer buffer, long l2) throws IOException {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    long l3 = 0L;
                    Segment segment = buffer.head;
                    while (l3 < 65536L) {
                        int n2 = segment.limit - segment.pos;
                        if ((l3 += (long)n2) >= l2) {
                            l3 = l2;
                            break;
                        }
                        segment = segment.next;
                    }
                    AsyncTimeout.this.enter();
                    try {
                        sink.write(buffer, l3);
                        l2 -= l3;
                    }
                    catch (IOException iOException) {
                        try {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                        catch (Throwable throwable) {
                            AsyncTimeout.this.exit(false);
                            throw throwable;
                        }
                    }
                    AsyncTimeout.this.exit(true);
                }
            }

            @Override
            public void flush() throws IOException {
                AsyncTimeout.this.enter();
                try {
                    sink.flush();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public void close() throws IOException {
                AsyncTimeout.this.enter();
                try {
                    sink.close();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.sink(" + sink + ")";
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){

            @Override
            public long read(Buffer buffer, long l2) throws IOException {
                long l3;
                boolean bl = false;
                AsyncTimeout.this.enter();
                try {
                    l3 = source.read(buffer, l2);
                    bl = true;
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(bl);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return l3;
            }

            @Override
            public void close() throws IOException {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.source(" + source + ")";
            }
        };
    }

    final void exit(boolean bl) throws IOException {
        boolean bl2 = this.exit();
        if (bl2 && bl) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException iOException) throws IOException {
        if (!this.exit()) {
            return iOException;
        }
        return this.newTimeoutException(iOException);
    }

    protected IOException newTimeoutException(IOException iOException) {
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            long l2 = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            if (AsyncTimeout.head.next == null && System.nanoTime() - l2 >= IDLE_TIMEOUT_NANOS) {
                return head;
            }
            return null;
        }
        long l3 = asyncTimeout.remainingNanos(System.nanoTime());
        if (l3 > 0L) {
            long l4 = l3 / 1000000L;
            AsyncTimeout.class.wait(l4, (int)(l3 -= l4 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    static final class Watchdog
    extends Thread {
        Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final void run() {
            while (true) {
                try {
                    while (true) {
                        Class<AsyncTimeout> clazz = AsyncTimeout.class;
                        // MONITORENTER : com.tencent.cloud.huiyansdkface.okio.AsyncTimeout.class
                        AsyncTimeout asyncTimeout = AsyncTimeout.awaitTimeout();
                        if (asyncTimeout == null) {
                            // MONITOREXIT : clazz
                            continue;
                        }
                        if (asyncTimeout == head) {
                            head = null;
                            // MONITOREXIT : clazz
                            return;
                        }
                        // MONITOREXIT : clazz
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

