/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.tls;

import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.TrustRootIndex;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> a = new LinkedHashMap<X500Principal, Set<X509Certificate>>();

    public BasicTrustRootIndex(X509Certificate ... x509CertificateArray) {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            Set<X509Certificate> set = this.a.get(x500Principal);
            if (set == null) {
                set = new LinkedHashSet<X509Certificate>(1);
                this.a.put(x500Principal, set);
            }
            set.add(x509Certificate);
        }
    }

    @Override
    public final X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        Iterator iterator = x509Certificate.getIssuerX500Principal();
        if ((iterator = this.a.get(iterator)) == null) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
                return x509Certificate2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof BasicTrustRootIndex && ((BasicTrustRootIndex)object).a.equals(this.a);
    }

    public final int hashCode() {
        return this.a.hashCode();
    }
}

