/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http2;

import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Hpack;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Settings;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Reader
implements Closeable {
    static final Logger a = Logger.getLogger(Http2.class.getName());
    private final BufferedSource b;
    private final ContinuationSource c;
    private final boolean d;
    private Hpack.Reader e;

    Http2Reader(BufferedSource bufferedSource, boolean bl) {
        this.b = bufferedSource;
        this.d = bl;
        this.c = new ContinuationSource(this.b);
        this.e = new Hpack.Reader(4096, this.c);
    }

    public final void readConnectionPreface(Handler object) throws IOException {
        if (this.d) {
            if (!this.nextFrame(true, (Handler)object)) {
                throw Http2.b("Required SETTINGS preface not received", new Object[0]);
            }
        } else {
            object = this.b.readByteString(Http2.a.size());
            if (a.isLoggable(Level.FINE)) {
                a.fine(Util.format("<< CONNECTION %s", ((ByteString)object).hex()));
            }
            if (!Http2.a.equals(object)) {
                throw Http2.b("Expected a connection header but was %s", ((ByteString)object).utf8());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean nextFrame(boolean bl, Handler handler) throws IOException {
        try {
            this.b.require(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int byteString = Http2Reader.a(this.b);
        if (byteString < 0 || byteString > 16384) {
            throw Http2.b("FRAME_SIZE_ERROR: %s", byteString);
        }
        int errorCode = this.b.readByte();
        if (bl && errorCode != 4) {
            throw Http2.b("Expected a SETTINGS frame but was %s", (byte)errorCode);
        }
        byte http2Reader = this.b.readByte();
        int n2 = this.b.readInt() & Integer.MAX_VALUE;
        if (a.isLoggable(Level.FINE)) {
            a.fine(Http2.a(true, n2, byteString, (byte)errorCode, http2Reader));
        }
        switch (errorCode) {
            case 0: {
                void var2_12;
                errorCode = http2Reader;
                Http2Reader http2Reader2 = this;
                if (n2 == 0) {
                    throw Http2.b("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
                }
                boolean bl4 = (errorCode & 1) != 0;
                boolean s3 = (errorCode & 0x20) != 0;
                if (s3) {
                    throw Http2.b("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
                }
                short list = (errorCode & 8) != 0 ? (short)(http2Reader2.b.readByte() & 0xFF) : (short)0;
                byteString = Http2Reader.a(byteString, (byte)errorCode, list);
                var2_12.data(bl4, n2, http2Reader2.b, byteString);
                http2Reader2.b.skip(list);
                break;
            }
            case 1: {
                void var2_12;
                errorCode = http2Reader;
                Http2Reader http2Reader2 = this;
                if (n2 == 0) {
                    throw Http2.b("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
                }
                boolean n5 = (errorCode & 1) != 0;
                short s2 = errorCode = (errorCode & 8) != 0 ? (short)(http2Reader2.b.readByte() & 0xFF) : (short)0;
                if ((errorCode & 0x20) != 0) {
                    http2Reader2.a((Handler)var2_12, n2);
                    byteString -= 5;
                }
                byteString = Http2Reader.a(byteString, (byte)errorCode, errorCode);
                List<Header> n6 = http2Reader2.a(byteString, errorCode, (byte)errorCode, n2);
                var2_12.headers(n5, n2, -1, n6);
                break;
            }
            case 2: {
                void var2_12;
                errorCode = n2;
                Http2Reader http2Reader3 = this;
                if (byteString != 5) {
                    throw Http2.b("TYPE_PRIORITY length: %d != 5", byteString);
                }
                if (errorCode == 0) {
                    throw Http2.b("TYPE_PRIORITY streamId == 0", new Object[0]);
                }
                http2Reader3.a((Handler)var2_12, errorCode);
                break;
            }
            case 3: {
                void var2_12;
                errorCode = n2;
                Http2Reader http2Reader4 = this;
                if (byteString != 4) {
                    throw Http2.b("TYPE_RST_STREAM length: %d != 4", byteString);
                }
                if (errorCode == 0) {
                    throw Http2.b("TYPE_RST_STREAM streamId == 0", new Object[0]);
                }
                int settings = http2Reader4.b.readInt();
                ErrorCode i2 = ErrorCode.fromHttp2(settings);
                if (i2 == null) {
                    throw Http2.b("TYPE_RST_STREAM unexpected error code: %d", settings);
                }
                var2_12.rstStream(errorCode, i2);
                break;
            }
            case 4: {
                void var2_12;
                errorCode = http2Reader;
                Http2Reader http2Reader5 = this;
                if (n2 != 0) {
                    throw Http2.b("TYPE_SETTINGS streamId != 0", new Object[0]);
                }
                if ((errorCode & 1) != 0) {
                    if (byteString != 0) {
                        throw Http2.b("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                    }
                    var2_12.ackSettings();
                    break;
                }
                if (byteString % 6 != 0) {
                    throw Http2.b("TYPE_SETTINGS length %% 6 != 0: %s", byteString);
                }
                Settings s5 = new Settings();
                for (int n7 = 0; n7 < byteString; n7 += 6) {
                    int list = http2Reader5.b.readShort() & 0xFFFF;
                    errorCode = http2Reader5.b.readInt();
                    switch (list) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (errorCode == 0 || errorCode == 1) break;
                            throw Http2.b("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                        }
                        case 3: {
                            list = 4;
                            break;
                        }
                        case 4: {
                            list = 7;
                            if (errorCode >= 0) break;
                            throw Http2.b("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                        }
                        case 5: {
                            if (errorCode >= 16384 && errorCode <= 0xFFFFFF) break;
                            throw Http2.b("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", errorCode);
                        }
                    }
                    s5.a(list, errorCode);
                }
                var2_12.settings(false, s5);
                break;
            }
            case 5: {
                void var2_12;
                errorCode = http2Reader;
                Http2Reader http2Reader6 = this;
                if (n2 == 0) {
                    throw Http2.b("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
                }
                short n8 = (errorCode & 8) != 0 ? (short)(http2Reader6.b.readByte() & 0xFF) : (short)0;
                int n9 = http2Reader6.b.readInt() & Integer.MAX_VALUE;
                byteString -= 4;
                byteString = Http2Reader.a(byteString, (byte)errorCode, n8);
                List<Header> bl5 = http2Reader6.a(byteString, n8, (byte)errorCode, n2);
                var2_12.pushPromise(n2, n9, bl5);
                break;
            }
            case 6: {
                void var2_12;
                errorCode = http2Reader;
                Http2Reader http2Reader7 = this;
                if (byteString != 8) {
                    throw Http2.b("TYPE_PING length != 8: %s", byteString);
                }
                if (n2 != 0) {
                    throw Http2.b("TYPE_PING streamId != 0", new Object[0]);
                }
                int n10 = http2Reader7.b.readInt();
                int n11 = http2Reader7.b.readInt();
                boolean n12 = (errorCode & 1) != 0;
                var2_12.ping(n12, n10, n11);
                break;
            }
            case 7: {
                void var2_12;
                errorCode = n2;
                Http2Reader http2Reader8 = this;
                if (byteString < 8) {
                    throw Http2.b("TYPE_GOAWAY length < 8: %s", byteString);
                }
                if (errorCode != 0) {
                    throw Http2.b("TYPE_GOAWAY streamId != 0", new Object[0]);
                }
                int l2 = http2Reader8.b.readInt();
                int n3 = http2Reader8.b.readInt();
                int n4 = byteString - 8;
                ErrorCode errorCode2 = ErrorCode.fromHttp2(n3);
                if (errorCode2 == null) {
                    throw Http2.b("TYPE_GOAWAY unexpected error code: %d", n3);
                }
                ByteString byteString2 = ByteString.EMPTY;
                if (n4 > 0) {
                    byteString2 = http2Reader8.b.readByteString(n4);
                }
                var2_12.goAway(l2, errorCode2, byteString2);
                break;
            }
            case 8: {
                void var2_12;
                errorCode = n2;
                Http2Reader http2Reader3 = this;
                if (byteString != 4) {
                    throw Http2.b("TYPE_WINDOW_UPDATE length !=4: %s", byteString);
                }
                long l2 = (long)http2Reader3.b.readInt() & Integer.MAX_VALUE;
                if (l2 == 0L) {
                    throw Http2.b("windowSizeIncrement was 0", l2);
                }
                var2_12.windowUpdate(errorCode, l2);
                break;
            }
            default: {
                this.b.skip(byteString);
            }
        }
        return true;
    }

    private List<Header> a(int n2, short s2, byte by, int n3) throws IOException {
        this.c.a = this.c.d = n2;
        this.c.e = s2;
        this.c.b = by;
        this.c.c = n3;
        this.e.a();
        return this.e.getAndResetHeaderList();
    }

    private void a(Handler handler, int n2) throws IOException {
        int n3 = this.b.readInt();
        boolean bl = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = (this.b.readByte() & 0xFF) + 1;
        handler.priority(n2, n3 &= Integer.MAX_VALUE, n4, bl);
    }

    @Override
    public final void close() throws IOException {
        this.b.close();
    }

    static int a(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    private static int a(int n2, byte by, short s2) throws IOException {
        if ((by & 8) != 0) {
            --n2;
        }
        if (s2 > n2) {
            throw Http2.b("PROTOCOL_ERROR padding %s > remaining length %s", s2, n2);
        }
        return (short)(n2 - s2);
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource f;
        int a;
        byte b;
        int c;
        int d;
        short e;

        ContinuationSource(BufferedSource bufferedSource) {
            this.f = bufferedSource;
        }

        @Override
        public final long read(Buffer buffer, long l2) throws IOException {
            while (this.d == 0) {
                this.f.skip(this.e);
                this.e = 0;
                if ((this.b & 4) != 0) {
                    return -1L;
                }
                ContinuationSource continuationSource = this;
                int n2 = continuationSource.c;
                continuationSource.a = continuationSource.d = Http2Reader.a(continuationSource.f);
                byte by = continuationSource.f.readByte();
                continuationSource.b = continuationSource.f.readByte();
                if (a.isLoggable(Level.FINE)) {
                    a.fine(Http2.a(true, continuationSource.c, continuationSource.a, by, continuationSource.b));
                }
                continuationSource.c = continuationSource.f.readInt() & Integer.MAX_VALUE;
                if (by != 9) {
                    throw Http2.b("%s != TYPE_CONTINUATION", by);
                }
                if (continuationSource.c == n2) continue;
                throw Http2.b("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
            long l3 = this.f.read(buffer, Math.min(l2, (long)this.d));
            if (l3 == -1L) {
                return -1L;
            }
            this.d = (int)((long)this.d - l3);
            return l3;
        }

        @Override
        public final Timeout timeout() {
            return this.f.timeout();
        }

        @Override
        public final void close() throws IOException {
        }
    }
}

