/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http2;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.ResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpCodec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RealResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RequestLine;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.StatusLine;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Connection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Stream;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.ForwardingSource;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final List<String> b = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> c = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    private final Interceptor.Chain d;
    final StreamAllocation a;
    private final Http2Connection e;
    private Http2Stream f;
    private final Protocol g;

    public Http2Codec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection http2Connection) {
        this.d = chain;
        this.a = streamAllocation;
        this.e = http2Connection;
        this.g = okHttpClient.protocols().contains((Object)Protocol.e) ? Protocol.e : Protocol.d;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) {
        return this.f.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) throws IOException {
        if (this.f != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        object = Http2Codec.http2HeadersList((Request)object);
        this.f = this.e.newStream((List<Header>)object, bl);
        this.f.readTimeout().timeout(this.d.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.f.writeTimeout().timeout(this.d.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void flushRequest() throws IOException {
        this.e.flush();
    }

    @Override
    public final void finishRequest() throws IOException {
        this.f.getSink().close();
    }

    @Override
    public final Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Object object = this.f.takeHeaders();
        object = Http2Codec.readHttp2HeadersList((Headers)object, this.g);
        if (bl && Internal.a.code((Response.Builder)object) == 100) {
            return null;
        }
        return object;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.c, request.method()));
        arrayList.add(new Header(Header.d, RequestLine.requestPath(request.url())));
        String string = request.header("Host");
        if (string != null) {
            arrayList.add(new Header(Header.f, string));
        }
        arrayList.add(new Header(Header.e, request.url().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (b.contains(byteString.utf8())) continue;
            arrayList.add(new Header(byteString, headers.value(i2)));
        }
        return arrayList;
    }

    public static Response.Builder readHttp2HeadersList(Headers headers, Protocol protocol) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            String string2 = headers.value(i2);
            if (string.equals(":status")) {
                statusLine = StatusLine.parse("HTTP/1.1 " + string2);
                continue;
            }
            if (c.contains(string)) continue;
            Internal.a.addLenient(builder, string, string2);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(protocol).code(statusLine.b).message(statusLine.c).headers(builder.build());
    }

    @Override
    public final ResponseBody openResponseBody(Response closeable) throws IOException {
        this.a.b.responseBodyStart(this.a.a);
        String string = closeable.header("Content-Type");
        long l2 = HttpHeaders.contentLength(closeable);
        closeable = new StreamFinishingSource(this, this.f.getSource());
        return new RealResponseBody(string, l2, Okio.buffer((Source)closeable));
    }

    @Override
    public final void cancel() {
        if (this.f != null) {
            this.f.closeLater(ErrorCode.f);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        private boolean a;
        private long b;
        private /* synthetic */ Http2Codec c;

        StreamFinishingSource(Http2Codec http2Codec, Source source) {
            this.c = http2Codec;
            super(source);
            this.a = false;
            this.b = 0L;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            try {
                long l3 = this.delegate().read(buffer, l2);
                if (l3 > 0L) {
                    this.b += l3;
                }
                return l3;
            }
            catch (IOException iOException) {
                this.a(iOException);
                throw iOException;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.a(null);
        }

        private void a(IOException iOException) {
            if (this.a) {
                return;
            }
            this.a = true;
            this.c.a.streamFinished(false, this.c, this.b, iOException);
        }
    }
}

