/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http;

import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import java.io.IOException;
import java.net.ProtocolException;

public final class StatusLine {
    public final Protocol a;
    public final int b;
    public final String c;

    public StatusLine(Protocol protocol, int n2, String string) {
        this.a = protocol;
        this.b = n2;
        this.c = string;
    }

    public static StatusLine get(Response response) {
        return new StatusLine(response.protocol(), response.code(), response.message());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusLine parse(String string) throws IOException {
        Protocol protocol;
        int n2;
        int n3;
        if (string.startsWith("HTTP/1.")) {
            if (string.length() < 9 || string.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + string);
            }
            n3 = string.charAt(7) - 48;
            n2 = 9;
            if (n3 == 0) {
                protocol = Protocol.a;
            } else {
                if (n3 != 1) throw new ProtocolException("Unexpected status line: " + string);
                protocol = Protocol.b;
            }
        } else {
            if (!string.startsWith("ICY ")) throw new ProtocolException("Unexpected status line: " + string);
            protocol = Protocol.a;
            n2 = 4;
        }
        if (string.length() < n2 + 3) {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        try {
            n3 = Integer.parseInt(string.substring(n2, n2 + 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        String string2 = "";
        if (string.length() <= n2 + 3) return new StatusLine(protocol, n3, string2);
        if (string.charAt(n2 + 3) != ' ') {
            throw new ProtocolException("Unexpected status line: " + string);
        }
        string2 = string.substring(n2 + 4);
        return new StatusLine(protocol, n3, string2);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.a == Protocol.a ? "HTTP/1.0" : "HTTP/1.1");
        stringBuilder.append(' ').append(this.b);
        if (this.c != null) {
            stringBuilder.append(' ').append(this.c);
        }
        return stringBuilder.toString();
    }
}

