/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.connection;

import com.tencent.cloud.huiyansdkface.okhttp3.Address;
import com.tencent.cloud.huiyansdkface.okhttp3.Call;
import com.tencent.cloud.huiyansdkface.okhttp3.CertificatePinner;
import com.tencent.cloud.huiyansdkface.okhttp3.Connection;
import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionPool;
import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionSpec;
import com.tencent.cloud.huiyansdkface.okhttp3.EventListener;
import com.tencent.cloud.huiyansdkface.okhttp3.Handshake;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.Route;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Version;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.ConnectionSpecSelector;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RouteException;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpCodec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http1.Http1Codec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Codec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Connection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Stream;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.OkHostnameVerifier;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.ws.RealWebSocket;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private final ConnectionPool f;
    private final Route g;
    private Socket h;
    private Socket i;
    private Handshake j;
    private Protocol k;
    private Http2Connection l;
    private BufferedSource m;
    private BufferedSink n;
    public boolean a;
    public int b;
    private int o = 1;
    public final List<Reference<StreamAllocation>> c = new ArrayList<Reference<StreamAllocation>>();
    public long d = Long.MAX_VALUE;

    public RealConnection(ConnectionPool connectionPool, Route route) {
        this.f = connectionPool;
        this.g = route;
    }

    public static RealConnection testConnection(ConnectionPool object, Route route, Socket socket, long l2) {
        object = new RealConnection((ConnectionPool)object, route);
        v0.i = socket;
        ((RealConnection)object).d = l2;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(int n2, int n3, int n4, int n5, boolean bl, Call call, EventListener eventListener) {
        if (this.k != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        Object object = this.g.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector((List<ConnectionSpec>)object);
        if (this.g.address().sslSocketFactory() == null) {
            if (!object.contains(ConnectionSpec.c)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            object = this.g.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)object + " not permitted by network security policy"));
            }
        } else if (this.g.address().protocols().contains((Object)Protocol.e)) {
            throw new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        while (true) {
            try {
                if (this.g.requiresTunnel()) {
                    this.a(n2, n3, n4, call, eventListener);
                    if (this.h == null) {
                        break;
                    }
                } else {
                    this.a(n2, n3, call, eventListener);
                }
                EventListener eventListener2 = eventListener;
                Call call2 = call;
                int n6 = n5;
                ConnectionSpecSelector connectionSpecSelector2 = connectionSpecSelector;
                object = this;
                if (((RealConnection)object).g.address().sslSocketFactory() == null) {
                    if (((RealConnection)object).g.address().protocols().contains((Object)Protocol.e)) {
                        ((RealConnection)object).i = ((RealConnection)object).h;
                        ((RealConnection)object).k = Protocol.e;
                        super.a(n6);
                    } else {
                        ((RealConnection)object).i = ((RealConnection)object).h;
                        ((RealConnection)object).k = Protocol.b;
                    }
                } else {
                    eventListener2.secureConnectStart(call2);
                    super.a(connectionSpecSelector2);
                    eventListener2.secureConnectEnd(call2, ((RealConnection)object).j);
                    if (((RealConnection)object).k == Protocol.d) {
                        super.a(n6);
                    }
                }
                eventListener.connectEnd(call, this.g.socketAddress(), this.g.proxy(), this.k);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.i);
                Util.closeQuietly(this.h);
                this.i = null;
                this.h = null;
                this.m = null;
                this.n = null;
                this.j = null;
                this.k = null;
                this.l = null;
                eventListener.connectFailed(call, this.g.socketAddress(), this.g.proxy(), null, iOException);
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                    continue;
                }
                routeException.addConnectException(iOException);
                if (bl && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
            break;
        }
        if (this.g.requiresTunnel() && this.h == null) {
            object = new ProtocolException("Too many tunnel connections attempted: 21");
            throw new RouteException((IOException)object);
        }
        if (this.l != null) {
            object = this.f;
            synchronized (object) {
                this.o = this.l.maxConcurrentStreams();
                return;
            }
        }
    }

    private void a(int n2, int n3, int n4, Call call, EventListener eventListener) throws IOException {
        Object object = this;
        Request request = new Request.Builder().url(((RealConnection)object).g.address().url()).method("CONNECT", null).header("Host", Util.hostHeader(((RealConnection)object).g.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
        Response response = new Response.Builder().request(request).protocol(Protocol.b).code(407).message("Preemptive Authenticate").body(Util.b).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Object object2 = ((RealConnection)object).g.address().proxyAuthenticator().authenticate(((RealConnection)object).g, response);
        object = object2 != null ? object2 : request;
        HttpUrl httpUrl = ((Request)object).url();
        for (int i2 = 0; i2 < 21; ++i2) {
            Object object3;
            this.a(n2, n3, call, eventListener);
            Object object4 = httpUrl;
            object2 = object;
            int n5 = n4;
            int n6 = n3;
            object = this;
            object4 = "CONNECT " + Util.hostHeader((HttpUrl)object4, true) + " HTTP/1.1";
            block5: while (true) {
                Http1Codec http1Codec = new Http1Codec(null, null, ((RealConnection)object).m, ((RealConnection)object).n);
                ((RealConnection)object).m.timeout().timeout(n6, TimeUnit.MILLISECONDS);
                ((RealConnection)object).n.timeout().timeout(n5, TimeUnit.MILLISECONDS);
                http1Codec.writeRequest(((Request)object2).headers(), (String)object4);
                http1Codec.finishRequest();
                Response response2 = http1Codec.readResponseHeaders(false).request((Request)object2).build();
                long l2 = HttpHeaders.contentLength(response2);
                if (l2 == -1L) {
                    l2 = 0L;
                }
                object2 = http1Codec.newFixedLengthSource(l2);
                Util.skipAll((Source)object2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
                object2.close();
                switch (response2.code()) {
                    case 200: {
                        if (!((RealConnection)object).m.buffer().exhausted() || !((RealConnection)object).n.buffer().exhausted()) {
                            throw new IOException("TLS tunnel buffered too many bytes!");
                        }
                        object3 = null;
                        break block5;
                    }
                    case 407: {
                        object2 = ((RealConnection)object).g.address().proxyAuthenticator().authenticate(((RealConnection)object).g, response2);
                        if (object2 != null) continue block5;
                        throw new IOException("Failed to authenticate with proxy");
                        if (!"close".equalsIgnoreCase(response2.header("Connection"))) continue block5;
                        object3 = object2;
                        break block5;
                    }
                    default: {
                        throw new IOException("Unexpected response code for CONNECT: " + response2.code());
                    }
                }
                break;
            }
            object = object3;
            if (object3 == null) break;
            Util.closeQuietly(this.h);
            this.h = null;
            this.n = null;
            this.m = null;
            eventListener.connectEnd(call, this.g.socketAddress(), this.g.proxy(), null);
        }
    }

    private void a(int n2, int n3, Call call, EventListener eventListener) throws IOException {
        Proxy proxy = this.g.proxy();
        Address address = this.g.address();
        this.h = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.socketFactory().createSocket() : new Socket(proxy);
        eventListener.connectStart(call, this.g.socketAddress(), proxy);
        this.h.setSoTimeout(n3);
        try {
            Platform.get().connectSocket(this.h, this.g.socketAddress(), n2);
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException("Failed to connect to " + this.g.socketAddress());
            connectException2.initCause(connectException);
            throw connectException2;
        }
        try {
            this.m = Okio.buffer(Okio.source(this.h));
            this.n = Okio.buffer(Okio.sink(this.h));
            return;
        }
        catch (NullPointerException nullPointerException) {
            if ("throw with null exception".equals(nullPointerException.getMessage())) {
                throw new IOException(nullPointerException);
            }
            return;
        }
    }

    private void a(int n2) throws IOException {
        this.i.setSoTimeout(0);
        this.l = new Http2Connection.Builder(true).socket(this.i, this.g.address().url().host(), this.m, this.n).listener(this).pingIntervalMillis(n2).build();
        this.l.start();
    }

    private void a(ConnectionSpecSelector object) throws IOException {
        Address address = this.g.address();
        Object object2 = address.sslSocketFactory();
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)((SSLSocketFactory)object2).createSocket(this.h, address.url().host(), address.url().port(), true);
            object = ((ConnectionSpecSelector)object).configureSecureSocket(sSLSocket);
            if (((ConnectionSpec)object).supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.url().host(), address.protocols());
            }
            sSLSocket.startHandshake();
            object2 = sSLSocket.getSession();
            Handshake handshake = Handshake.get((SSLSession)object2);
            if (!address.hostnameVerifier().verify(address.url().host(), (SSLSession)object2)) {
                object = (X509Certificate)handshake.peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified:\n    certificate: " + CertificatePinner.pin((Certificate)object) + "\n    DN: " + ((X509Certificate)object).getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames((X509Certificate)object));
            }
            address.certificatePinner().check(address.url().host(), handshake.peerCertificates());
            object = ((ConnectionSpec)object).supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.i = sSLSocket;
            this.m = Okio.buffer(Okio.source(this.i));
            this.n = Okio.buffer(Okio.sink(this.i));
            this.j = handshake;
            Protocol protocol = this.k = object != null ? Protocol.get((String)object) : Protocol.b;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            return;
        }
        catch (AssertionError assertionError) {
            try {
                object = assertionError;
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)object);
                }
                throw object;
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
    }

    public final boolean isEligible(Address address, Route route) {
        if (this.c.size() >= this.o || this.a) {
            return false;
        }
        if (!Internal.a.equalsNonHost(this.g.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (this.l == null) {
            return false;
        }
        if (route == null) {
            return false;
        }
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (this.g.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (!this.g.socketAddress().equals(route.socketAddress())) {
            return false;
        }
        if (route.address().hostnameVerifier() != OkHostnameVerifier.a) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        return true;
    }

    public final boolean supportsUrl(HttpUrl httpUrl) {
        if (httpUrl.port() != this.g.address().url().port()) {
            return false;
        }
        if (!httpUrl.host().equals(this.g.address().url().host())) {
            return this.j != null && OkHostnameVerifier.a.verify(httpUrl.host(), (X509Certificate)this.j.peerCertificates().get(0));
        }
        return true;
    }

    public final HttpCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation) throws SocketException {
        if (this.l != null) {
            return new Http2Codec(okHttpClient, chain, streamAllocation, this.l);
        }
        this.i.setSoTimeout(chain.readTimeoutMillis());
        this.m.timeout().timeout(chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.n.timeout().timeout(chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1Codec(okHttpClient, streamAllocation, this.m, this.n);
    }

    public final RealWebSocket.Streams newWebSocketStreams(StreamAllocation streamAllocation) {
        return new RealWebSocket.Streams(this, true, this.m, this.n, streamAllocation){
            private /* synthetic */ StreamAllocation d;
            {
                this.d = streamAllocation;
                super(true, bufferedSource, bufferedSink);
            }

            @Override
            public void close() throws IOException {
                this.d.streamFinished(true, this.d.codec(), -1L, null);
            }
        };
    }

    @Override
    public final Route route() {
        return this.g;
    }

    public final void cancel() {
        Util.closeQuietly(this.h);
    }

    @Override
    public final Socket socket() {
        return this.i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isHealthy(boolean bl) {
        if (this.i.isClosed()) return false;
        if (this.i.isInputShutdown()) return false;
        if (this.i.isOutputShutdown()) {
            return false;
        }
        if (this.l != null) {
            if (this.l.isShutdown()) return false;
            return true;
        }
        if (!bl) return true;
        try {
            int n2 = this.i.getSoTimeout();
            try {
                this.i.setSoTimeout(1);
                if (!this.m.exhausted()) return true;
                return false;
            }
            finally {
                this.i.setSoTimeout(n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSettings(Http2Connection http2Connection) {
        ConnectionPool connectionPool = this.f;
        synchronized (connectionPool) {
            this.o = http2Connection.maxConcurrentStreams();
            return;
        }
    }

    @Override
    public final Handshake handshake() {
        return this.j;
    }

    public final boolean isMultiplexed() {
        return this.l != null;
    }

    @Override
    public final Protocol protocol() {
        return this.k;
    }

    public final String toString() {
        return "Connection{" + this.g.address().url().host() + ":" + this.g.address().url().port() + ", proxy=" + this.g.proxy() + " hostAddress=" + this.g.socketAddress() + " cipherSuite=" + (this.j != null ? this.j.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.k) + '}';
    }
}

