/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.connection;

import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionSpec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> a;
    private int b = 0;
    private boolean c;
    private boolean d;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.a = list;
    }

    public final ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec = null;
        int n2 = this.a.size();
        for (int i2 = this.b; i2 < n2; ++i2) {
            ConnectionSpec connectionSpec2 = this.a.get(i2);
            if (!connectionSpec2.isCompatible(sSLSocket)) continue;
            connectionSpec = connectionSpec2;
            this.b = i2 + 1;
            break;
        }
        if (connectionSpec == null) {
            throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.d + ", modes=" + this.a + ", supported protocols=" + Arrays.toString(sSLSocket.getEnabledProtocols()));
        }
        this.c = this.a(sSLSocket);
        Internal.a.apply(connectionSpec, sSLSocket, this.d);
        return connectionSpec;
    }

    public final boolean connectionFailed(IOException iOException) {
        this.d = true;
        if (!this.c) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return iOException instanceof SSLHandshakeException || iOException instanceof SSLProtocolException || iOException instanceof SSLException;
    }

    private boolean a(SSLSocket sSLSocket) {
        for (int i2 = this.b; i2 < this.a.size(); ++i2) {
            if (!this.a.get(i2).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }
}

