/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.cache;

import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.FaultHidingSink;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.io.FileSystem;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable,
Flushable {
    private static Pattern l = Pattern.compile("[a-z0-9_-]{1,120}");
    final FileSystem a;
    final File b;
    private final File m;
    private final File n;
    private final File o;
    private final int p;
    private long q;
    final int c;
    private long r = 0L;
    BufferedSink d;
    final LinkedHashMap<String, Entry> e = new LinkedHashMap(0, 0.75f, true);
    int f;
    boolean g;
    boolean h;
    boolean i;
    boolean j;
    boolean k;
    private long s = 0L;
    private final Executor t;
    private final Runnable u = new Runnable(this){
        private /* synthetic */ DiskLruCache a;
        {
            this.a = diskLruCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiskLruCache diskLruCache = this.a;
            synchronized (diskLruCache) {
                if (!this.a.h | this.a.i) {
                    return;
                }
                try {
                    this.a.c();
                }
                catch (IOException iOException) {
                    this.a.j = true;
                }
                try {
                    if (this.a.b()) {
                        this.a.a();
                        this.a.f = 0;
                    }
                }
                catch (IOException iOException) {
                    this.a.k = true;
                    this.a.d = Okio.buffer(Okio.blackhole());
                }
                return;
            }
        }
    };

    private DiskLruCache(FileSystem fileSystem, File file, int n2, int n3, long l2, Executor executor) {
        this.a = fileSystem;
        this.b = file;
        this.p = n2;
        this.m = new File(file, "journal");
        this.n = new File(file, "journal.tmp");
        this.o = new File(file, "journal.bkp");
        this.c = n3;
        this.q = l2;
        this.t = executor;
    }

    public final synchronized void initialize() throws IOException {
        assert (Thread.holdsLock(this));
        if (this.h) {
            return;
        }
        if (this.a.exists(this.o)) {
            if (this.a.exists(this.m)) {
                this.a.delete(this.o);
            } else {
                this.a.rename(this.o, this.m);
            }
        }
        if (this.a.exists(this.m)) {
            try {
                this.d();
                this.f();
                this.h = true;
                return;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "DiskLruCache " + this.b + " is corrupt: " + iOException.getMessage() + ", removing", iOException);
                try {
                    this.delete();
                }
                finally {
                    this.i = false;
                }
            }
        }
        this.a();
        this.h = true;
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n2, int n3, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp DiskLruCache", true));
        return new DiskLruCache(fileSystem, file, n2, n3, l2, threadPoolExecutor);
    }

    private void d() throws IOException {
        BufferedSource bufferedSource = Okio.buffer(this.a.source(this.m));
        try {
            String string = bufferedSource.readUtf8LineStrict();
            String[] stringArray = bufferedSource.readUtf8LineStrict();
            String string2 = bufferedSource.readUtf8LineStrict();
            String string3 = bufferedSource.readUtf8LineStrict();
            String string4 = bufferedSource.readUtf8LineStrict();
            if (!("libcore.io.DiskLruCache".equals(string) && "1".equals(stringArray) && Integer.toString(this.p).equals(string2) && Integer.toString(this.c).equals(string3) && "".equals(string4))) {
                throw new IOException("unexpected journal header: [" + string + ", " + (String)stringArray + ", " + string3 + ", " + string4 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    block18: {
                        Entry entry;
                        int n3;
                        int n4;
                        block17: {
                            int n5;
                            block16: {
                                string2 = bufferedSource.readUtf8LineStrict();
                                stringArray = this;
                                n4 = string2.indexOf(32);
                                if (n4 == -1) {
                                    throw new IOException("unexpected journal line: " + string2);
                                }
                                n5 = n4 + 1;
                                n3 = string2.indexOf(32, n5);
                                if (n3 != -1) break block16;
                                string4 = string2.substring(n5);
                                if (n4 != 6 || !string2.startsWith("REMOVE")) break block17;
                                stringArray.e.remove(string4);
                                break block18;
                            }
                            string4 = string2.substring(n5, n3);
                        }
                        if ((entry = stringArray.e.get(string4)) == null) {
                            entry = new Entry((DiskLruCache)stringArray, string4);
                            stringArray.e.put(string4, entry);
                        }
                        if (n3 != -1 && n4 == 5 && string2.startsWith("CLEAN")) {
                            stringArray = string2.substring(n3 + 1).split(" ");
                            entry.e = true;
                            entry.f = null;
                            entry.a(stringArray);
                        } else if (n3 == -1 && n4 == 5 && string2.startsWith("DIRTY")) {
                            entry.f = (DiskLruCache)stringArray.new Editor(entry);
                        } else if (n3 != -1 || n4 != 4 || !string2.startsWith("READ")) {
                            throw new IOException("unexpected journal line: " + string2);
                        }
                    }
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.f = n2 - this.e.size();
                if (!bufferedSource.exhausted()) {
                    this.a();
                } else {
                    this.d = this.e();
                }
                return;
            }
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private BufferedSink e() throws FileNotFoundException {
        Sink sink = this.a.appendingSink(this.m);
        sink = new FaultHidingSink(this, sink){
            private /* synthetic */ DiskLruCache b;
            {
                this.b = diskLruCache;
                super(sink);
            }

            @Override
            protected final void a() {
                assert (Thread.holdsLock(this.b));
                this.b.g = true;
            }
        };
        return Okio.buffer(sink);
    }

    private void f() throws IOException {
        this.a.delete(this.n);
        Iterator<Entry> iterator = this.e.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.f == null) {
                for (n2 = 0; n2 < this.c; ++n2) {
                    this.r += entry.b[n2];
                }
                continue;
            }
            entry.f = null;
            for (n2 = 0; n2 < this.c; ++n2) {
                this.a.delete(entry.c[n2]);
                this.a.delete(entry.d[n2]);
            }
            iterator.remove();
        }
    }

    final synchronized void a() throws IOException {
        if (this.d != null) {
            this.d.close();
        }
        try (BufferedSink bufferedSink = Okio.buffer(this.a.sink(this.n));){
            bufferedSink.writeUtf8("libcore.io.DiskLruCache").writeByte(10);
            bufferedSink.writeUtf8("1").writeByte(10);
            bufferedSink.writeDecimalLong(this.p).writeByte(10);
            bufferedSink.writeDecimalLong(this.c).writeByte(10);
            bufferedSink.writeByte(10);
            for (Entry entry : this.e.values()) {
                if (entry.f != null) {
                    bufferedSink.writeUtf8("DIRTY").writeByte(32);
                    bufferedSink.writeUtf8(entry.a);
                    bufferedSink.writeByte(10);
                    continue;
                }
                bufferedSink.writeUtf8("CLEAN").writeByte(32);
                bufferedSink.writeUtf8(entry.a);
                entry.a(bufferedSink);
                bufferedSink.writeByte(10);
            }
        }
        if (this.a.exists(this.m)) {
            this.a.rename(this.m, this.o);
        }
        this.a.rename(this.n, this.m);
        this.a.delete(this.o);
        this.d = this.e();
        this.g = false;
        this.k = false;
    }

    public final synchronized Snapshot get(String string) throws IOException {
        this.initialize();
        this.g();
        DiskLruCache.a(string);
        Object object = this.e.get(string);
        if (object == null || !((Entry)object).e) {
            return null;
        }
        if ((object = ((Entry)object).a()) == null) {
            return null;
        }
        ++this.f;
        this.d.writeUtf8("READ").writeByte(32).writeUtf8(string).writeByte(10);
        if (this.b()) {
            this.t.execute(this.u);
        }
        return object;
    }

    public final Editor edit(String string) throws IOException {
        return this.a(string, -1L);
    }

    final synchronized Editor a(String object, long l2) throws IOException {
        this.initialize();
        this.g();
        DiskLruCache.a((String)object);
        Entry entry = this.e.get(object);
        if (l2 != -1L && (entry == null || entry.g != l2)) {
            return null;
        }
        if (entry != null && entry.f != null) {
            return null;
        }
        if (this.j || this.k) {
            this.t.execute(this.u);
            return null;
        }
        this.d.writeUtf8("DIRTY").writeByte(32).writeUtf8((String)object).writeByte(10);
        this.d.flush();
        if (this.g) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(this, (String)object);
            this.e.put((String)object, entry);
        }
        entry.f = object = new Editor(entry);
        return object;
    }

    public final File getDirectory() {
        return this.b;
    }

    public final synchronized long getMaxSize() {
        return this.q;
    }

    public final synchronized void setMaxSize(long l2) {
        this.q = l2;
        if (this.h) {
            this.t.execute(this.u);
        }
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.r;
    }

    final synchronized void a(Editor object, boolean bl) throws IOException {
        int n2;
        Entry entry = ((Editor)object).a;
        if (entry.f != object) {
            throw new IllegalStateException();
        }
        if (bl && !entry.e) {
            for (n2 = 0; n2 < this.c; ++n2) {
                if (!((Editor)object).b[n2]) {
                    ((Editor)object).abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n2);
                }
                if (this.a.exists(entry.d[n2])) continue;
                ((Editor)object).abort();
                return;
            }
        }
        for (n2 = 0; n2 < this.c; ++n2) {
            object = entry.d[n2];
            if (bl) {
                long l2;
                if (!this.a.exists((File)object)) continue;
                File file = entry.c[n2];
                this.a.rename((File)object, file);
                long l3 = entry.b[n2];
                entry.b[n2] = l2 = this.a.size(file);
                this.r = this.r - l3 + l2;
                continue;
            }
            this.a.delete((File)object);
        }
        ++this.f;
        entry.f = null;
        if (entry.e | bl) {
            entry.e = true;
            this.d.writeUtf8("CLEAN").writeByte(32);
            this.d.writeUtf8(entry.a);
            entry.a(this.d);
            this.d.writeByte(10);
            if (bl) {
                entry.g = this.s++;
            }
        } else {
            this.e.remove(entry.a);
            this.d.writeUtf8("REMOVE").writeByte(32);
            this.d.writeUtf8(entry.a);
            this.d.writeByte(10);
        }
        this.d.flush();
        if (this.r > this.q || this.b()) {
            this.t.execute(this.u);
        }
    }

    final boolean b() {
        return this.f >= 2000 && this.f >= this.e.size();
    }

    public final synchronized boolean remove(String object) throws IOException {
        this.initialize();
        this.g();
        DiskLruCache.a((String)object);
        object = this.e.get(object);
        if (object == null) {
            return false;
        }
        this.a((Entry)object);
        if (this.r <= this.q) {
            this.j = false;
        }
        return true;
    }

    final boolean a(Entry entry) throws IOException {
        if (entry.f != null) {
            entry.f.a();
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.a.delete(entry.c[i2]);
            this.r -= entry.b[i2];
            entry.b[i2] = 0L;
        }
        ++this.f;
        this.d.writeUtf8("REMOVE").writeByte(32).writeUtf8(entry.a).writeByte(10);
        this.e.remove(entry.a);
        if (this.b()) {
            this.t.execute(this.u);
        }
        return true;
    }

    public final synchronized boolean isClosed() {
        return this.i;
    }

    private synchronized void g() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache is closed");
        }
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (!this.h) {
            return;
        }
        this.g();
        this.c();
        this.d.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.h || this.i) {
            this.i = true;
            return;
        }
        for (Entry entry : this.e.values().toArray(new Entry[this.e.size()])) {
            if (entry.f == null) continue;
            entry.f.abort();
        }
        this.c();
        this.d.close();
        this.d = null;
        this.i = true;
    }

    final void c() throws IOException {
        while (this.r > this.q) {
            Entry entry = this.e.values().iterator().next();
            this.a(entry);
        }
        this.j = false;
    }

    public final void delete() throws IOException {
        this.close();
        this.a.deleteContents(this.b);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        for (Entry entry : this.e.values().toArray(new Entry[this.e.size()])) {
            this.a(entry);
        }
        this.j = false;
    }

    private static void a(String string) {
        Matcher matcher = l.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,120}: \"" + string + "\"");
        }
    }

    public final synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(this){
            private Iterator<Entry> a;
            private Snapshot b;
            private Snapshot c;
            private /* synthetic */ DiskLruCache d;
            {
                this.d = diskLruCache;
                this.a = new ArrayList<Entry>(this.d.e.values()).iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.b != null) {
                    return true;
                }
                DiskLruCache diskLruCache = this.d;
                synchronized (diskLruCache) {
                    if (this.d.i) {
                        return false;
                    }
                    while (this.a.hasNext()) {
                        Object object = this.a.next();
                        if ((object = ((Entry)object).a()) == null) continue;
                        this.b = object;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Snapshot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.c = this.b;
                this.b = null;
                return this.c;
            }

            @Override
            public void remove() {
                if (this.c == null) {
                    throw new IllegalStateException("remove() before next()");
                }
                try {
                    this.d.remove(this.c.a);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                finally {
                    this.c = null;
                }
            }
        };
    }

    final class Entry {
        final String a;
        final long[] b;
        final File[] c;
        final File[] d;
        boolean e;
        Editor f;
        long g;
        private /* synthetic */ DiskLruCache h;

        Entry(DiskLruCache diskLruCache, String charSequence) {
            this.h = diskLruCache;
            this.a = charSequence;
            this.b = new long[diskLruCache.c];
            this.c = new File[diskLruCache.c];
            this.d = new File[diskLruCache.c];
            charSequence = new StringBuilder((String)charSequence).append('.');
            int n2 = ((StringBuilder)charSequence).length();
            for (int i2 = 0; i2 < diskLruCache.c; ++i2) {
                ((StringBuilder)charSequence).append(i2);
                this.c[i2] = new File(diskLruCache.b, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(".tmp");
                this.d[i2] = new File(diskLruCache.b, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n2);
            }
        }

        final void a(String[] stringArray) throws IOException {
            if (stringArray.length != this.h.c) {
                throw Entry.b(stringArray);
            }
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.b[i2] = Long.parseLong(stringArray[i2]);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw Entry.b(stringArray);
            }
        }

        final void a(BufferedSink bufferedSink) throws IOException {
            long[] lArray = this.b;
            int n2 = this.b.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = lArray[i2];
                bufferedSink.writeByte(32).writeDecimalLong(l2);
            }
        }

        private static IOException b(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        final Snapshot a() {
            if (!Thread.holdsLock(this.h)) {
                throw new AssertionError();
            }
            Source[] sourceArray = new Source[this.h.c];
            long[] lArray = (long[])this.b.clone();
            try {
                for (int i2 = 0; i2 < this.h.c; ++i2) {
                    sourceArray[i2] = this.h.a.source(this.c[i2]);
                }
                return new Snapshot(this.h, this.a, this.g, sourceArray, lArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (int i3 = 0; i3 < this.h.c && sourceArray[i3] != null; ++i3) {
                    Util.closeQuietly(sourceArray[i3]);
                }
                try {
                    this.h.a(this);
                }
                catch (IOException iOException) {}
                return null;
            }
        }
    }

    public final class Editor {
        final Entry a;
        final boolean[] b;
        private boolean d;

        Editor(Entry entry) {
            this.a = entry;
            this.b = entry.e ? null : new boolean[DiskLruCache.this.c];
        }

        final void a() {
            if (this.a.f == this) {
                for (int i2 = 0; i2 < DiskLruCache.this.c; ++i2) {
                    try {
                        DiskLruCache.this.a.delete(this.a.d[i2]);
                        continue;
                    }
                    catch (IOException iOException) {}
                }
                this.a.f = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Source newSource(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.d) {
                    throw new IllegalStateException();
                }
                if (!this.a.e || this.a.f != this) {
                    return null;
                }
                try {
                    return DiskLruCache.this.a.source(this.a.c[n2]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Sink newSink(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.d) {
                    throw new IllegalStateException();
                }
                if (this.a.f != this) {
                    return Okio.blackhole();
                }
                if (!this.a.e) {
                    this.b[n2] = true;
                }
                Object object = this.a.d[n2];
                try {
                    object = DiskLruCache.this.a.sink((File)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return Okio.blackhole();
                }
                return new FaultHidingSink(this, (Sink)object){
                    private /* synthetic */ Editor a;
                    {
                        this.a = editor;
                        super(sink);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected final void a() {
                        DiskLruCache diskLruCache = this.a.DiskLruCache.this;
                        synchronized (diskLruCache) {
                            this.a.a();
                            return;
                        }
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.d) {
                    throw new IllegalStateException();
                }
                if (this.a.f == this) {
                    DiskLruCache.this.a(this, true);
                }
                this.d = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.d) {
                    throw new IllegalStateException();
                }
                if (this.a.f == this) {
                    DiskLruCache.this.a(this, false);
                }
                this.d = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abortUnlessCommitted() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!this.d && this.a.f == this) {
                    try {
                        DiskLruCache.this.a(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String a;
        private final long b;
        private final Source[] c;
        private final long[] d;
        private /* synthetic */ DiskLruCache e;

        Snapshot(DiskLruCache diskLruCache, String string, long l2, Source[] sourceArray, long[] lArray) {
            this.e = diskLruCache;
            this.a = string;
            this.b = l2;
            this.c = sourceArray;
            this.d = lArray;
        }

        public final String key() {
            return this.a;
        }

        public final Editor edit() throws IOException {
            return this.e.a(this.a, this.b);
        }

        public final Source getSource(int n2) {
            return this.c[n2];
        }

        public final long getLength(int n2) {
            return this.d[n2];
        }

        @Override
        public final void close() {
            Source[] sourceArray = this.c;
            int n2 = this.c.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Source source = sourceArray[i2];
                Util.closeQuietly(source);
            }
        }
    }
}

