/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.cache;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpDate;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    public final Request a;
    public final Response b;

    CacheStrategy(Request request, Response response) {
        this.a = request;
        this.b = response;
    }

    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                break;
            }
            case 302: 
            case 307: {
                if (response.header("Expires") != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
            }
            default: {
                return false;
            }
        }
        return !response.cacheControl().noStore() && !request.cacheControl().noStore();
    }

    public static class Factory {
        private long a;
        private Request b;
        private Response c;
        private Date d;
        private String e;
        private Date f;
        private String g;
        private Date h;
        private long i;
        private long j;
        private String k;
        private int l = -1;

        public Factory(long l2, Request request, Response object) {
            this.a = l2;
            this.b = request;
            this.c = object;
            if (object != null) {
                this.i = ((Response)object).sentRequestAtMillis();
                this.j = ((Response)object).receivedResponseAtMillis();
                Headers headers = ((Response)object).headers();
                int n2 = headers.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = headers.name(i2);
                    String string = headers.value(i2);
                    if ("Date".equalsIgnoreCase((String)object)) {
                        this.d = HttpDate.parse(string);
                        this.e = string;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object)) {
                        this.h = HttpDate.parse(string);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object)) {
                        this.f = HttpDate.parse(string);
                        this.g = string;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object)) {
                        this.k = string;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase((String)object)) continue;
                    this.l = HttpHeaders.parseSeconds(string, -1);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public CacheStrategy get() {
            block14: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            var1_1 = this;
                                            if (var1_1.c != null) break block13;
                                            v0 = new CacheStrategy(var1_1.b, null);
                                            break block14;
                                        }
                                        if (!var1_1.b.isHttps() || var1_1.c.handshake() != null) break block15;
                                        v0 = new CacheStrategy(var1_1.b, null);
                                        break block14;
                                    }
                                    if (CacheStrategy.isCacheable(var1_1.c, var1_1.b)) break block16;
                                    v0 = new CacheStrategy(var1_1.b, null);
                                    break block14;
                                }
                                var2_2 = var1_1.b.cacheControl();
                                if (!var2_2.noCache() && !((var4_3 = var1_1.b).header("If-Modified-Since") != null || var4_3.header("If-None-Match") != null)) break block17;
                                v0 = new CacheStrategy(var1_1.b, null);
                                break block14;
                            }
                            var3_4 = var1_1.c.cacheControl();
                            var4_3 = var1_1;
                            var18_5 = var4_3.d != null ? Math.max(0L, var4_3.j - var4_3.d.getTime()) : 0L;
                            var20_7 = var4_3.l != -1 ? Math.max(var18_5, TimeUnit.SECONDS.toMillis(var4_3.l)) : var18_5;
                            var22_8 = var4_3.j - var4_3.i;
                            var24_9 = var4_3.a - var4_3.j;
                            var5_10 = var20_7 + var22_8 + var24_9;
                            var4_3 = var1_1;
                            var18_6 = var4_3.c.cacheControl();
                            if (var18_6.maxAgeSeconds() != -1) {
                                v1 = TimeUnit.SECONDS.toMillis(var18_6.maxAgeSeconds());
                            } else if (var4_3.h != null) {
                                var19_11 = var4_3.d != null ? var4_3.d.getTime() : var4_3.j;
                                var21_12 = var4_3.h.getTime() - var19_11;
                                v1 = var21_12 > 0L ? var21_12 : 0L;
                            } else {
                                v1 = var4_3.f != null && var4_3.c.request().url().query() == null ? ((var21_12 = (var19_11 = var4_3.d != null ? var4_3.d.getTime() : var4_3.i) - var4_3.f.getTime()) > 0L ? var21_12 / 10L : 0L) : (var7_13 = 0L);
                            }
                            if (var2_2.maxAgeSeconds() != -1) {
                                var7_13 = Math.min(var7_13, TimeUnit.SECONDS.toMillis(var2_2.maxAgeSeconds()));
                            }
                            var9_14 = 0L;
                            if (var2_2.minFreshSeconds() != -1) {
                                var9_14 = TimeUnit.SECONDS.toMillis(var2_2.minFreshSeconds());
                            }
                            var11_15 = 0L;
                            if (!var3_4.mustRevalidate() && var2_2.maxStaleSeconds() != -1) {
                                var11_15 = TimeUnit.SECONDS.toMillis(var2_2.maxStaleSeconds());
                            }
                            if (var3_4.noCache() || var5_10 + var9_14 >= var7_13 + var11_15) break block18;
                            var2_2 = var1_1.c.newBuilder();
                            if (var5_10 + var9_14 >= var7_13) {
                                var2_2.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                            }
                            if (var5_10 > 86400000L) {
                                var4_3 = var1_1;
                                if (var4_3.c.cacheControl().maxAgeSeconds() == -1 && var4_3.h == null) {
                                    var2_2.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                }
                            }
                            v0 = new CacheStrategy(null, var2_2.build());
                            break block14;
                        }
                        if (var1_1.k == null) break block19;
                        var2_2 = "If-None-Match";
                        var3_4 = var1_1.k;
                        ** GOTO lbl73
                    }
                    if (var1_1.f == null) break block20;
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.g;
                    ** GOTO lbl73
                }
                if (var1_1.d == null) {
                    v0 = new CacheStrategy(var1_1.b, null);
                } else {
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.e;
lbl73:
                    // 3 sources

                    var4_3 = var1_1.b.headers().newBuilder();
                    Internal.a.addLenient((Headers.Builder)var4_3, (String)var2_2, (String)var3_4);
                    var2_2 = var1_1.b.newBuilder().headers(var4_3.build()).build();
                    v0 = var1_1 = new CacheStrategy((Request)var2_2, var1_1.c);
                }
            }
            if (v0.a != null && this.b.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return var1_1;
        }
    }
}

