/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum TlsVersion {
    a("TLSv1.3"),
    b("TLSv1.2"),
    c("TLSv1.1"),
    d("TLSv1"),
    e("SSLv3");

    final String f;

    private TlsVersion(String string2) {
        this.f = string2;
    }

    public static TlsVersion forJavaName(String string) {
        switch (string) {
            case "TLSv1.3": {
                return a;
            }
            case "TLSv1.2": {
                return b;
            }
            case "TLSv1.1": {
                return c;
            }
            case "TLSv1": {
                return d;
            }
            case "SSLv3": {
                return e;
            }
        }
        throw new IllegalArgumentException("Unexpected TLS version: " + string);
    }

    static List<TlsVersion> a(String ... stringArray) {
        ArrayList<TlsVersion> arrayList = new ArrayList<TlsVersion>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(TlsVersion.forJavaName(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final String javaName() {
        return this.f;
    }
}

