/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.CacheControl;
import com.tencent.cloud.huiyansdkface.okhttp3.Challenge;
import com.tencent.cloud.huiyansdkface.okhttp3.Handshake;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.ResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class Response
implements Closeable {
    final Request a;
    final Protocol b;
    final int c;
    final String d;
    final Handshake e;
    final Headers f;
    final ResponseBody g;
    final Response h;
    final Response i;
    final Response j;
    final long k;
    final long l;
    private volatile CacheControl m;

    Response(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.f.build();
        this.g = builder.g;
        this.h = builder.h;
        this.i = builder.i;
        this.j = builder.j;
        this.k = builder.k;
        this.l = builder.l;
    }

    public final Request request() {
        return this.a;
    }

    public final Protocol protocol() {
        return this.b;
    }

    public final int code() {
        return this.c;
    }

    public final boolean isSuccessful() {
        return this.c >= 200 && this.c < 300;
    }

    public final String message() {
        return this.d;
    }

    public final Handshake handshake() {
        return this.e;
    }

    public final List<String> headers(String string) {
        return this.f.values(string);
    }

    public final String header(String string) {
        return this.header(string, null);
    }

    public final String header(String string, String string2) {
        if ((string = this.f.get(string)) != null) {
            return string;
        }
        return string2;
    }

    public final Headers headers() {
        return this.f;
    }

    public final ResponseBody peekBody(long l2) throws IOException {
        BufferedSource bufferedSource;
        BufferedSource bufferedSource2 = this.g.source();
        bufferedSource2.request(l2);
        bufferedSource2 = bufferedSource2.buffer().clone();
        if (((Buffer)bufferedSource2).size() > l2) {
            bufferedSource = new Buffer();
            ((Buffer)bufferedSource).write((Buffer)bufferedSource2, l2);
            ((Buffer)bufferedSource2).clear();
        } else {
            bufferedSource = bufferedSource2;
        }
        return ResponseBody.create(this.g.contentType(), ((Buffer)bufferedSource).size(), bufferedSource);
    }

    public final ResponseBody body() {
        return this.g;
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final boolean isRedirect() {
        switch (this.c) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public final Response networkResponse() {
        return this.h;
    }

    public final Response cacheResponse() {
        return this.i;
    }

    public final Response priorResponse() {
        return this.j;
    }

    public final List<Challenge> challenges() {
        String string;
        if (this.c == 401) {
            string = "WWW-Authenticate";
        } else if (this.c == 407) {
            string = "Proxy-Authenticate";
        } else {
            return Collections.emptyList();
        }
        return HttpHeaders.parseChallenges(this.headers(), string);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.m;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.m = CacheControl.parse(this.f);
        return this.m;
    }

    public final long sentRequestAtMillis() {
        return this.k;
    }

    public final long receivedResponseAtMillis() {
        return this.l;
    }

    @Override
    public final void close() {
        if (this.g == null) {
            throw new IllegalStateException("response is not eligible for a body and must not be closed");
        }
        this.g.close();
    }

    public final String toString() {
        return "Response{protocol=" + (Object)((Object)this.b) + ", code=" + this.c + ", message=" + this.d + ", url=" + this.a.url() + '}';
    }

    public static class Builder {
        Request a;
        Protocol b;
        int c = -1;
        String d;
        Handshake e;
        Headers.Builder f;
        ResponseBody g;
        Response h;
        Response i;
        Response j;
        long k;
        long l;

        public Builder() {
            this.f = new Headers.Builder();
        }

        Builder(Response response) {
            this.a = response.a;
            this.b = response.b;
            this.c = response.c;
            this.d = response.d;
            this.e = response.e;
            this.f = response.f.newBuilder();
            this.g = response.g;
            this.h = response.h;
            this.i = response.i;
            this.j = response.j;
            this.k = response.k;
            this.l = response.l;
        }

        public Builder request(Request request) {
            this.a = request;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.b = protocol;
            return this;
        }

        public Builder code(int n2) {
            this.c = n2;
            return this;
        }

        public Builder message(String string) {
            this.d = string;
            return this;
        }

        public Builder handshake(Handshake handshake) {
            this.e = handshake;
            return this;
        }

        public Builder header(String string, String string2) {
            this.f.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.f.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.f.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.f = headers.newBuilder();
            return this;
        }

        public Builder body(ResponseBody responseBody) {
            this.g = responseBody;
            return this;
        }

        public Builder networkResponse(Response response) {
            if (response != null) {
                Builder.a("networkResponse", response);
            }
            this.h = response;
            return this;
        }

        public Builder cacheResponse(Response response) {
            if (response != null) {
                Builder.a("cacheResponse", response);
            }
            this.i = response;
            return this;
        }

        private static void a(String string, Response response) {
            if (response.g != null) {
                throw new IllegalArgumentException(string + ".body != null");
            }
            if (response.h != null) {
                throw new IllegalArgumentException(string + ".networkResponse != null");
            }
            if (response.i != null) {
                throw new IllegalArgumentException(string + ".cacheResponse != null");
            }
            if (response.j != null) {
                throw new IllegalArgumentException(string + ".priorResponse != null");
            }
        }

        public Builder priorResponse(Response response) {
            if (response != null) {
                Response response2 = response;
                if (response2.g != null) {
                    throw new IllegalArgumentException("priorResponse.body != null");
                }
            }
            this.j = response;
            return this;
        }

        public Builder sentRequestAtMillis(long l2) {
            this.k = l2;
            return this;
        }

        public Builder receivedResponseAtMillis(long l2) {
            this.l = l2;
            return this;
        }

        public Response build() {
            if (this.a == null) {
                throw new IllegalStateException("request == null");
            }
            if (this.b == null) {
                throw new IllegalStateException("protocol == null");
            }
            if (this.c < 0) {
                throw new IllegalStateException("code < 0: " + this.c);
            }
            if (this.d == null) {
                throw new IllegalStateException("message == null");
            }
            return new Response(this);
        }
    }
}

