/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.CacheControl;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.RequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpMethod;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Request {
    final HttpUrl a;
    final String b;
    final Headers c;
    final RequestBody d;
    final Map<Class<?>, Object> e;
    private volatile CacheControl f;

    Request(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c.build();
        this.d = builder.d;
        this.e = Util.immutableMap(builder.e);
    }

    public final HttpUrl url() {
        return this.a;
    }

    public final String method() {
        return this.b;
    }

    public final Headers headers() {
        return this.c;
    }

    public final String header(String string) {
        return this.c.get(string);
    }

    public final List<String> headers(String string) {
        return this.c.values(string);
    }

    public final RequestBody body() {
        return this.d;
    }

    public final Object tag() {
        return this.tag(Object.class);
    }

    public final <T> T tag(Class<? extends T> clazz) {
        return clazz.cast(this.e.get(clazz));
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.f;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.f = CacheControl.parse(this.c);
        return this.f;
    }

    public final boolean isHttps() {
        return this.a.isHttps();
    }

    public final String toString() {
        return "Request{method=" + this.b + ", url=" + this.a + ", tags=" + this.e + '}';
    }

    public static class Builder {
        HttpUrl a;
        String b;
        Headers.Builder c;
        RequestBody d;
        Map<Class<?>, Object> e = Collections.emptyMap();

        public Builder() {
            this.b = "GET";
            this.c = new Headers.Builder();
        }

        Builder(Request request) {
            this.a = request.a;
            this.b = request.b;
            this.d = request.d;
            this.e = request.e.isEmpty() ? Collections.emptyMap() : new LinkedHashMap(request.e);
            this.c = request.c.newBuilder();
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl == null) {
                throw new NullPointerException("url == null");
            }
            this.a = httpUrl;
            return this;
        }

        public Builder url(String string) {
            if (string == null) {
                throw new NullPointerException("url == null");
            }
            if (string.regionMatches(true, 0, "ws:", 0, 3)) {
                string = "http:" + string.substring(3);
            } else if (string.regionMatches(true, 0, "wss:", 0, 4)) {
                string = "https:" + string.substring(4);
            }
            return this.url(HttpUrl.get(string));
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("url == null");
            }
            return this.url(HttpUrl.get(uRL.toString()));
        }

        public Builder header(String string, String string2) {
            this.c.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.c.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.c.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.c = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl object) {
            if (((String)(object = ((CacheControl)object).toString())).isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", (String)object);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder delete(RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder delete() {
            return this.delete(Util.c);
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder method(String string, RequestBody requestBody) {
            if (string == null) {
                throw new NullPointerException("method == null");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("method.length() == 0");
            }
            if (requestBody != null && !HttpMethod.permitsRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must not have a request body.");
            }
            if (requestBody == null && HttpMethod.requiresRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must have a request body.");
            }
            this.b = string;
            this.d = requestBody;
            return this;
        }

        public Builder tag(Object object) {
            return this.tag(Object.class, object);
        }

        public Object tag() {
            return this.e.get(Object.class);
        }

        public <T> Builder tag(Class<? super T> clazz, T t2) {
            if (clazz == null) {
                throw new NullPointerException("type == null");
            }
            if (t2 == null) {
                this.e.remove(clazz);
            } else {
                if (this.e.isEmpty()) {
                    this.e = new LinkedHashMap();
                }
                this.e.put(clazz, clazz.cast(t2));
            }
            return this;
        }

        public Request build() {
            if (this.a == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }
}

