/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.CipherSuite;
import com.tencent.cloud.huiyansdkface.okhttp3.TlsVersion;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] h = new CipherSuite[]{CipherSuite.o, CipherSuite.p, CipherSuite.q, CipherSuite.r, CipherSuite.s, CipherSuite.i, CipherSuite.k, CipherSuite.j, CipherSuite.l, CipherSuite.n, CipherSuite.m};
    private static final CipherSuite[] i = new CipherSuite[]{CipherSuite.o, CipherSuite.p, CipherSuite.q, CipherSuite.r, CipherSuite.s, CipherSuite.i, CipherSuite.k, CipherSuite.j, CipherSuite.l, CipherSuite.n, CipherSuite.m, CipherSuite.g, CipherSuite.h, CipherSuite.e, CipherSuite.f, CipherSuite.c, CipherSuite.d, CipherSuite.b};
    public static final ConnectionSpec a;
    public static final ConnectionSpec b;
    public static final ConnectionSpec c;
    final boolean d;
    final boolean e;
    final String[] f;
    final String[] g;

    ConnectionSpec(Builder builder) {
        this.d = builder.a;
        this.f = builder.b;
        this.g = builder.c;
        this.e = builder.d;
    }

    public final boolean isTls() {
        return this.d;
    }

    public final List<CipherSuite> cipherSuites() {
        if (this.f != null) {
            return CipherSuite.a(this.f);
        }
        return null;
    }

    public final List<TlsVersion> tlsVersions() {
        if (this.g != null) {
            return TlsVersion.a(this.g);
        }
        return null;
    }

    public final boolean supportsTlsExtensions() {
        return this.e;
    }

    final void a(SSLSocket stringArray, boolean bl) {
        boolean bl2 = bl;
        String[] stringArray2 = stringArray;
        ConnectionSpec connectionSpec = this;
        String[] stringArray3 = connectionSpec.f != null ? Util.intersect(CipherSuite.a, stringArray2.getEnabledCipherSuites(), connectionSpec.f) : stringArray2.getEnabledCipherSuites();
        String[] stringArray4 = connectionSpec.g != null ? Util.intersect(Util.g, stringArray2.getEnabledProtocols(), connectionSpec.g) : stringArray2.getEnabledProtocols();
        stringArray2 = stringArray2.getSupportedCipherSuites();
        int n2 = Util.indexOf(CipherSuite.a, stringArray2, "TLS_FALLBACK_SCSV");
        if (bl2 && n2 != -1) {
            stringArray3 = Util.concat(stringArray3, stringArray2[n2]);
        }
        connectionSpec = new Builder(connectionSpec).cipherSuites(stringArray3).tlsVersions(stringArray4).build();
        if (connectionSpec.g != null) {
            stringArray.setEnabledProtocols(connectionSpec.g);
        }
        if (connectionSpec.f != null) {
            stringArray.setEnabledCipherSuites(connectionSpec.f);
        }
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.d) {
            return false;
        }
        if (this.g != null && !Util.nonEmptyIntersection(Util.g, this.g, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.f == null || Util.nonEmptyIntersection(CipherSuite.a, this.f, sSLSocket.getEnabledCipherSuites());
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        if (this.d != ((ConnectionSpec)object).d) {
            return false;
        }
        if (this.d) {
            if (!Arrays.equals(this.f, ((ConnectionSpec)object).f)) {
                return false;
            }
            if (!Arrays.equals(this.g, ((ConnectionSpec)object).g)) {
                return false;
            }
            if (this.e != ((ConnectionSpec)object).e) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n2 = 17;
        if (this.d) {
            n2 = 527 + Arrays.hashCode(this.f);
            n2 = n2 * 31 + Arrays.hashCode(this.g);
            n2 = n2 * 31 + (this.e ? 0 : 1);
        }
        return n2;
    }

    public final String toString() {
        if (!this.d) {
            return "ConnectionSpec()";
        }
        String string = this.f != null ? this.cipherSuites().toString() : "[all enabled]";
        String string2 = this.g != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string + ", tlsVersions=" + string2 + ", supportsTlsExtensions=" + this.e + ")";
    }

    static {
        new Builder(true).cipherSuites(h).tlsVersions(TlsVersion.a, TlsVersion.b).supportsTlsExtensions(true).build();
        a = new Builder(true).cipherSuites(i).tlsVersions(TlsVersion.a, TlsVersion.b, TlsVersion.c, TlsVersion.d).supportsTlsExtensions(true).build();
        b = new Builder(true).cipherSuites(i).tlsVersions(TlsVersion.d).supportsTlsExtensions(true).build();
        c = new Builder(false).build();
    }

    public static final class Builder {
        boolean a;
        String[] b;
        String[] c;
        boolean d;

        Builder(boolean bl) {
            this.a = bl;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.a = connectionSpec.d;
            this.b = connectionSpec.f;
            this.c = connectionSpec.g;
            this.d = connectionSpec.e;
        }

        public final Builder allEnabledCipherSuites() {
            if (!this.a) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            this.b = null;
            return this;
        }

        public final Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (!this.a) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            String[] stringArray = new String[cipherSuiteArray.length];
            for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
                stringArray[i2] = cipherSuiteArray[i2].t;
            }
            return this.cipherSuites(stringArray);
        }

        public final Builder cipherSuites(String ... stringArray) {
            if (!this.a) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            this.b = (String[])stringArray.clone();
            return this;
        }

        public final Builder allEnabledTlsVersions() {
            if (!this.a) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            this.c = null;
            return this;
        }

        public final Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (!this.a) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            String[] stringArray = new String[tlsVersionArray.length];
            for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
                stringArray[i2] = tlsVersionArray[i2].f;
            }
            return this.tlsVersions(stringArray);
        }

        public final Builder tlsVersions(String ... stringArray) {
            if (!this.a) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            this.c = (String[])stringArray.clone();
            return this;
        }

        public final Builder supportsTlsExtensions(boolean bl) {
            if (!this.a) {
                throw new IllegalStateException("no TLS extensions for cleartext connections");
            }
            this.d = bl;
            return this;
        }

        public final ConnectionSpec build() {
            return new ConnectionSpec(this);
        }
    }
}

