/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.CertificateChainCleaner;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner a = new Builder().build();
    private final CertificatePinProvider b;
    private final Set<Pin> c;
    private final CertificateChainCleaner d;

    CertificatePinner(Set<Pin> set, CertificateChainCleaner certificateChainCleaner) {
        this.c = set;
        this.b = null;
        this.d = certificateChainCleaner;
    }

    CertificatePinner(CertificatePinProvider certificatePinProvider, CertificateChainCleaner certificateChainCleaner) {
        this.b = certificatePinProvider;
        this.c = new LinkedHashSet<Pin>();
        this.d = certificateChainCleaner;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CertificatePinner && Util.equal(this.d, ((CertificatePinner)object).d) && this.c.equals(((CertificatePinner)object).c);
    }

    public final int hashCode() {
        int n2 = this.d != null ? this.d.hashCode() : 0;
        n2 = n2 * 31 + this.c.hashCode();
        return n2;
    }

    public final void checkPin(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray), false);
    }

    public final void check(String string, List<Certificate> list) throws SSLPeerUnverifiedException {
        this.check(string, list, true);
    }

    public final void check(String string, List<Certificate> list, boolean n2) throws SSLPeerUnverifiedException {
        int n3;
        Object object;
        Object object2;
        Object object3 = string;
        Serializable serializable = this;
        Object object4 = new HashSet<Pin>();
        Object object5 = ((CertificatePinner)((Object)serializable)).b;
        if (object5 != null) {
            object5 = object5.getPins((String)object3);
            object2 = new LinkedHashSet();
            object = object5.iterator();
            while (object.hasNext()) {
                object5 = (String)object.next();
                object2.add(new Pin((String)object3, (String)object5));
            }
            object4.addAll(object2);
        }
        object4.addAll(((CertificatePinner)((Object)serializable)).c);
        object5 = Collections.emptyList();
        object2 = object4.iterator();
        while (object2.hasNext()) {
            boolean bl;
            object = (Pin)object2.next();
            serializable = object3;
            object4 = object;
            if (((Pin)object).a.startsWith("**.")) {
                bl = ((String)((Object)serializable)).endsWith("." + ((Pin)object4).b);
            } else if (((Pin)object4).a.startsWith("*.")) {
                n3 = ((String)((Object)serializable)).indexOf(46);
                bl = ((String)((Object)serializable)).length() - n3 - 1 == ((Pin)object4).b.length() && ((String)((Object)serializable)).regionMatches(false, n3 + 1, ((Pin)object4).b, 0, ((Pin)object4).b.length());
            } else {
                bl = ((String)((Object)serializable)).equals(((Pin)object4).b);
            }
            if (!bl) continue;
            if (object5.isEmpty()) {
                object5 = new ArrayList<Object>();
            }
            object5.add(object);
        }
        object3 = object5;
        if (object3.isEmpty()) {
            return;
        }
        if (this.d != null && n2 != 0) {
            list = this.d.clean(list, string);
        }
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object5 = (X509Certificate)list.get(n2);
            serializable = null;
            object2 = null;
            n3 = object3.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Pin pin = (Pin)object3.get(i2);
                if (pin.c.equals("sha256/")) {
                    if (object2 == null) {
                        object2 = CertificatePinner.a(object5);
                    }
                    if (!pin.d.equals(object2)) continue;
                    return;
                }
                if (pin.c.equals("sha1/")) {
                    if (serializable == null) {
                        serializable = object5;
                        serializable = ByteString.of(((Certificate)serializable).getPublicKey().getEncoded()).sha1();
                    }
                    if (!pin.d.equals(serializable)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.c));
            }
        }
        StringBuilder stringBuilder = new StringBuilder("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n5 = list.size();
        for (n4 = 0; n4 < n5; ++n4) {
            serializable = (X509Certificate)list.get(n4);
            stringBuilder.append("\n    ").append(CertificatePinner.pin((Certificate)serializable)).append(": ").append(((X509Certificate)serializable).getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string).append(":");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n6 = object3.size();
        for (n5 = 0; n5 < n6; ++n5) {
            object2 = (Pin)object3.get(n5);
            stringBuilder.append("\n    ").append(object2);
            arrayList.add(((Pin)object2).toString());
        }
        if (this.b != null) {
            this.b.onPinVerifyFailed(string, arrayList);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public final void check(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray));
    }

    final CertificatePinner a(CertificateChainCleaner certificateChainCleaner) {
        if (Util.equal(this.d, certificateChainCleaner)) {
            return this;
        }
        if (this.b != null) {
            return new CertificatePinner(this.b, certificateChainCleaner);
        }
        return new CertificatePinner(this.c, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + CertificatePinner.a((X509Certificate)certificate).base64();
    }

    private static ByteString a(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public static interface CertificatePinProvider {
        public Set<String> getPins(String var1);

        public void onPinVerifyFailed(String var1, List<String> var2);
    }

    public static final class Builder {
        private final List<Pin> a = new ArrayList<Pin>();
        private CertificatePinProvider b;

        public final Builder add(String string, String ... stringArray) {
            if (string == null) {
                throw new NullPointerException("pattern == null");
            }
            for (String string2 : stringArray) {
                this.a.add(new Pin(string, string2));
            }
            return this;
        }

        public final Builder pinProvider(CertificatePinProvider certificatePinProvider) {
            if (certificatePinProvider == null) {
                throw new NullPointerException("pin provider == null");
            }
            this.b = certificatePinProvider;
            return this;
        }

        public final CertificatePinner build() {
            if (this.b != null) {
                return new CertificatePinner(this.b, null);
            }
            return new CertificatePinner(new LinkedHashSet<Pin>(this.a), null);
        }
    }

    static final class Pin {
        final String a;
        final String b;
        final String c;
        final ByteString d;

        Pin(String string, String string2) {
            this.a = string;
            String string3 = string.startsWith("*.") ? HttpUrl.get("http://" + string.substring(2)).host() : (this.b = string.startsWith("**.") ? HttpUrl.get("http://" + string.substring(3)).host() : HttpUrl.get("http://" + string).host());
            if (string2.startsWith("sha1/")) {
                this.c = "sha1/";
                this.d = ByteString.decodeBase64(string2.substring(5));
            } else if (string2.startsWith("sha256/")) {
                this.c = "sha256/";
                this.d = ByteString.decodeBase64(string2.substring(7));
            } else {
                throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string2);
            }
            if (this.d == null) {
                throw new IllegalArgumentException("pins must be base64: " + string2);
            }
        }

        public final boolean equals(Object object) {
            return object instanceof Pin && this.a.equals(((Pin)object).a) && this.c.equals(((Pin)object).c) && this.d.equals(((Pin)object).d);
        }

        public final int hashCode() {
            int n2 = 527 + this.a.hashCode();
            n2 = n2 * 31 + this.c.hashCode();
            n2 = n2 * 31 + this.d.hashCode();
            return n2;
        }

        public final String toString() {
            return this.c + this.d.base64();
        }
    }
}

