/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import java.util.concurrent.TimeUnit;

public final class CacheControl {
    private final boolean a;
    private final boolean b;
    private final int c;
    private final int d;
    private final boolean e;
    private final boolean f;
    private final boolean g;
    private final int h;
    private final int i;
    private final boolean j;
    private final boolean k;
    private final boolean l;
    private String m;

    private CacheControl(boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, boolean bl6, boolean bl7, boolean bl8, String string) {
        this.a = bl;
        this.b = bl2;
        this.c = n2;
        this.d = n3;
        this.e = bl3;
        this.f = bl4;
        this.g = bl5;
        this.h = n4;
        this.i = n5;
        this.j = bl6;
        this.k = bl7;
        this.l = bl8;
        this.m = string;
    }

    CacheControl(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = -1;
        this.e = false;
        this.f = false;
        this.g = false;
        this.h = builder.d;
        this.i = builder.e;
        this.j = builder.f;
        this.k = builder.g;
        this.l = builder.h;
    }

    public final boolean noCache() {
        return this.a;
    }

    public final boolean noStore() {
        return this.b;
    }

    public final int maxAgeSeconds() {
        return this.c;
    }

    public final int sMaxAgeSeconds() {
        return this.d;
    }

    public final boolean isPrivate() {
        return this.e;
    }

    public final boolean isPublic() {
        return this.f;
    }

    public final boolean mustRevalidate() {
        return this.g;
    }

    public final int maxStaleSeconds() {
        return this.h;
    }

    public final int minFreshSeconds() {
        return this.i;
    }

    public final boolean onlyIfCached() {
        return this.j;
    }

    public final boolean noTransform() {
        return this.k;
    }

    public final boolean immutable() {
        return this.l;
    }

    public static CacheControl parse(Headers headers) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = -1;
        int n5 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        String string = null;
        int n6 = headers.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            String string2 = headers.name(i2);
            String string3 = headers.value(i2);
            if (string2.equalsIgnoreCase("Cache-Control")) {
                if (string != null) {
                    bl9 = false;
                } else {
                    string = string3;
                }
            } else {
                if (!string2.equalsIgnoreCase("Pragma")) continue;
                bl9 = false;
            }
            int n7 = 0;
            while (n7 < string3.length()) {
                String string4;
                int n8 = n7;
                n7 = HttpHeaders.skipUntil(string3, n7, "=,;");
                String string5 = string3.substring(n8, n7).trim();
                if (n7 == string3.length() || string3.charAt(n7) == ',' || string3.charAt(n7) == ';') {
                    ++n7;
                    string4 = null;
                } else {
                    ++n7;
                    if ((n7 = HttpHeaders.skipWhitespace(string3, n7)) < string3.length() && string3.charAt(n7) == '\"') {
                        int n9 = ++n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, "\"");
                        string4 = string3.substring(n9, n7);
                        ++n7;
                    } else {
                        int n10 = n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, ",;");
                        string4 = string3.substring(n10, n7).trim();
                    }
                }
                if ("no-cache".equalsIgnoreCase(string5)) {
                    bl = true;
                    continue;
                }
                if ("no-store".equalsIgnoreCase(string5)) {
                    bl2 = true;
                    continue;
                }
                if ("max-age".equalsIgnoreCase(string5)) {
                    n2 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("s-maxage".equalsIgnoreCase(string5)) {
                    n3 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("private".equalsIgnoreCase(string5)) {
                    bl3 = true;
                    continue;
                }
                if ("public".equalsIgnoreCase(string5)) {
                    bl4 = true;
                    continue;
                }
                if ("must-revalidate".equalsIgnoreCase(string5)) {
                    bl5 = true;
                    continue;
                }
                if ("max-stale".equalsIgnoreCase(string5)) {
                    n4 = HttpHeaders.parseSeconds(string4, Integer.MAX_VALUE);
                    continue;
                }
                if ("min-fresh".equalsIgnoreCase(string5)) {
                    n5 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("only-if-cached".equalsIgnoreCase(string5)) {
                    bl6 = true;
                    continue;
                }
                if ("no-transform".equalsIgnoreCase(string5)) {
                    bl7 = true;
                    continue;
                }
                if (!"immutable".equalsIgnoreCase(string5)) continue;
                bl8 = true;
            }
        }
        if (!bl9) {
            string = null;
        }
        return new CacheControl(bl, bl2, n2, n3, bl3, bl4, bl5, n4, n5, bl6, bl7, bl8, string);
    }

    public final String toString() {
        String string;
        Object object = this.m;
        if (object != null) {
            return object;
        }
        object = this;
        StringBuilder stringBuilder = new StringBuilder();
        if (((CacheControl)object).a) {
            stringBuilder.append("no-cache, ");
        }
        if (((CacheControl)object).b) {
            stringBuilder.append("no-store, ");
        }
        if (((CacheControl)object).c != -1) {
            stringBuilder.append("max-age=").append(((CacheControl)object).c).append(", ");
        }
        if (((CacheControl)object).d != -1) {
            stringBuilder.append("s-maxage=").append(((CacheControl)object).d).append(", ");
        }
        if (((CacheControl)object).e) {
            stringBuilder.append("private, ");
        }
        if (((CacheControl)object).f) {
            stringBuilder.append("public, ");
        }
        if (((CacheControl)object).g) {
            stringBuilder.append("must-revalidate, ");
        }
        if (((CacheControl)object).h != -1) {
            stringBuilder.append("max-stale=").append(((CacheControl)object).h).append(", ");
        }
        if (((CacheControl)object).i != -1) {
            stringBuilder.append("min-fresh=").append(((CacheControl)object).i).append(", ");
        }
        if (((CacheControl)object).j) {
            stringBuilder.append("only-if-cached, ");
        }
        if (((CacheControl)object).k) {
            stringBuilder.append("no-transform, ");
        }
        if (((CacheControl)object).l) {
            stringBuilder.append("immutable, ");
        }
        if (stringBuilder.length() == 0) {
            string = "";
        } else {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            string = stringBuilder.toString();
        }
        this.m = string;
        return string;
    }

    static {
        new Builder().noCache().build();
        new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    }

    public static final class Builder {
        boolean a;
        boolean b;
        int c = -1;
        int d = -1;
        int e = -1;
        boolean f;
        boolean g;
        boolean h;

        public final Builder noCache() {
            this.a = true;
            return this;
        }

        public final Builder noStore() {
            this.b = true;
            return this;
        }

        public final Builder maxAge(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxAge < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.c = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public final Builder maxStale(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxStale < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.d = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public final Builder minFresh(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("minFresh < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.e = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public final Builder onlyIfCached() {
            this.f = true;
            return this;
        }

        public final Builder noTransform() {
            this.g = true;
            return this;
        }

        public final Builder immutable() {
            this.h = true;
            return this;
        }

        public final CacheControl build() {
            return new CacheControl(this);
        }
    }
}

