/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.normal.tools.secure;

import android.util.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAEncrypt {
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void genKeyPair() {
        Serializable serializable;
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            serializable = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace();
        }
        keyPairGenerator.initialize(2048, new SecureRandom());
        serializable = keyPairGenerator.generateKeyPair();
        this.privateKey = (RSAPrivateKey)((KeyPair)serializable).getPrivate();
        this.publicKey = (RSAPublicKey)((KeyPair)serializable).getPublic();
    }

    public void loadPublicKey(InputStream closeable) throws Exception {
        try {
            String string;
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = ((BufferedReader)closeable).readLine()) != null) {
                if (string.charAt(0) == '-') continue;
                stringBuilder.append(string);
                stringBuilder.append('\r');
            }
            this.loadPublicKey(stringBuilder.toString());
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException(nullPointerException);
        }
    }

    public void loadPublicKey(String object) throws Exception {
        try {
            object = Base64.decode((String)object, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            object = new X509EncodedKeySpec((byte[])object);
            this.publicKey = (RSAPublicKey)keyFactory.generatePublic((KeySpec)object);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException(invalidKeySpecException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException(nullPointerException);
        }
    }

    public void loadPublicKey(byte[] object) throws Exception {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            object = new X509EncodedKeySpec((byte[])object);
            this.publicKey = (RSAPublicKey)keyFactory.generatePublic((KeySpec)object);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException(invalidKeySpecException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException(nullPointerException);
        }
    }

    public void loadPrivateKey(InputStream closeable) throws Exception {
        try {
            String string;
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = ((BufferedReader)closeable).readLine()) != null) {
                if (string.charAt(0) == '-') continue;
                stringBuilder.append(string);
            }
            this.loadPrivateKey(stringBuilder.toString());
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException(nullPointerException);
        }
    }

    public void loadPrivateKey(String object) throws Exception {
        try {
            object = Base64.decode((String)object, (int)0);
            object = new PKCS8EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.privateKey = (RSAPrivateKey)keyFactory.generatePrivate((KeySpec)object);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException(invalidKeySpecException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException(nullPointerException);
        }
    }

    public byte[] encrypt(byte[] byArray) throws Exception {
        if (this.publicKey == null) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.publicKey);
            byArray = cipher.doFinal(byArray);
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException(badPaddingException);
        }
    }

    public static String byteArray2HexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder.append(HEX_CHAR[(byArray[i2] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_CHAR[byArray[i2] & 0xF]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public byte[] decrypt(byte[] byArray) throws Exception {
        if (this.privateKey == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, this.privateKey);
            byArray = cipher.doFinal(byArray);
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException(badPaddingException);
        }
    }
}

