/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.facelight.net.tools;

import android.support.annotation.Nullable;
import com.tencent.cloud.huiyansdkface.facelight.b.d;
import com.tencent.cloud.huiyansdkface.normal.tools.WLogger;
import com.tencent.cloud.huiyansdkface.okhttp3.Call;
import com.tencent.cloud.huiyansdkface.okhttp3.Connection;
import com.tencent.cloud.huiyansdkface.okhttp3.EventListener;
import com.tencent.cloud.huiyansdkface.okhttp3.Handshake;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class HttpEventListener
extends EventListener {
    private static final String TAG = HttpEventListener.class.getSimpleName();
    public static final EventListener.Factory FACTORY = new EventListener.Factory(){
        final AtomicLong a = new AtomicLong(1L);

        public EventListener create(Call call) {
            long l2 = this.a.getAndIncrement();
            String string = call.request().url().encodedPath();
            if (string.contains("ssoLoginEn") || string.contains("getflashresourceEn") || string.contains("facecompareEn") || string.contains("appuploadEn") || string.contains("WbGradeInfo.json")) {
                return new HttpEventListener(true, l2, call.request().url(), System.nanoTime());
            }
            return new HttpEventListener(false, l2, call.request().url(), System.nanoTime());
        }
    };
    private final long callId;
    private final long callStartNanos;
    private StringBuilder sbLog;
    private boolean isNeedRecord;

    public HttpEventListener(boolean bl, long l2, HttpUrl httpUrl, long l3) {
        this.isNeedRecord = bl;
        this.callId = l2;
        this.callStartNanos = l3;
        this.sbLog = new StringBuilder(httpUrl.encodedPath()).append(" ").append(l2).append(":");
    }

    private void recordEventLog(String string) {
        if (!this.isNeedRecord) {
            return;
        }
        long l2 = System.nanoTime() - this.callStartNanos;
        this.sbLog.append(String.format(Locale.CHINA, "%.3f-%s", (double)l2 / 1.0E9, string)).append(";");
        if ("callEnd".equalsIgnoreCase(string) || "callFailed".equalsIgnoreCase(string)) {
            WLogger.i((String)TAG, (String)this.sbLog.toString());
            d.a().a(null, "face_service_http_event", this.sbLog.toString(), null);
        }
    }

    public void callStart(Call call) {
        super.callStart(call);
        this.recordEventLog("callStart");
    }

    public void dnsStart(Call call, String string) {
        super.dnsStart(call, string);
        this.recordEventLog("dnsStart:" + string);
    }

    public void dnsEnd(Call call, String string, List<InetAddress> list) {
        super.dnsEnd(call, string, list);
        this.recordEventLog("dnsEnd");
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        String string = "";
        if (inetSocketAddress != null && inetSocketAddress.getAddress() != null) {
            string = inetSocketAddress.getAddress().getHostAddress();
        }
        this.recordEventLog("connectStart:" + string);
        WLogger.d((String)TAG, (String)("connectStart:" + string));
    }

    public void secureConnectStart(Call call) {
        super.secureConnectStart(call);
        this.recordEventLog("secureConnectStart");
    }

    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.recordEventLog("secureConnectEnd:" + handshake.tlsVersion());
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.recordEventLog("connectEnd");
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException iOException) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, iOException);
        String string = "";
        if (inetSocketAddress != null && inetSocketAddress.getAddress() != null) {
            string = inetSocketAddress.getAddress().getHostAddress();
        }
        this.recordEventLog("connectFailed:" + string);
        if (this.isNeedRecord) {
            String string2 = "";
            if (iOException != null) {
                iOException.printStackTrace();
                string2 = iOException.toString();
            }
            String string3 = call.request().url().encodedPath();
            Properties properties = new Properties();
            properties.setProperty("path", string3);
            properties.setProperty("ipInfo", string);
            properties.setProperty("errorMsg", string2);
            d.a().b(null, "faceservice_http_connect_failed", null, properties);
        }
    }

    public void connectionAcquired(Call call, Connection connection) {
        super.connectionAcquired(call, connection);
        this.recordEventLog("connectionAcquired");
    }

    public void connectionReleased(Call call, Connection connection) {
        super.connectionReleased(call, connection);
        this.recordEventLog("connectionReleased");
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.recordEventLog("requestHeadersStart");
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
        this.recordEventLog("requestHeadersEnd");
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
        this.recordEventLog("requestBodyStart");
    }

    public void requestBodyEnd(Call call, long l2) {
        super.requestBodyEnd(call, l2);
        this.recordEventLog("requestBodyEnd:" + l2);
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.recordEventLog("responseHeadersStart");
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
        this.recordEventLog("responseHeadersEnd");
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
        this.recordEventLog("responseBodyStart");
    }

    public void responseBodyEnd(Call call, long l2) {
        super.responseBodyEnd(call, l2);
        this.recordEventLog("responseBodyEnd");
    }

    public void callEnd(Call call) {
        super.callEnd(call);
        this.recordEventLog("callEnd");
    }

    public void callFailed(Call call, IOException iOException) {
        super.callFailed(call, iOException);
        this.recordEventLog("callFailed");
    }
}

