/*
 * Decompiled with CFR 0.152.
 */
package cn.m4399.operate.support.websocket.framing;

import android.support.annotation.NonNull;
import cn.m4399.operate.support.websocket.enums.Opcode;
import cn.m4399.operate.support.websocket.exceptions.InvalidDataException;
import cn.m4399.operate.support.websocket.exceptions.InvalidFrameException;
import cn.m4399.operate.support.websocket.framing.ControlFrame;
import cn.m4399.operate.support.websocket.util.ByteBufferUtils;
import cn.m4399.operate.support.websocket.util.Charsetfunctions;
import java.nio.ByteBuffer;
import java.util.Objects;

public class CloseFrame
extends ControlFrame {
    public static final int NORMAL = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1002;
    public static final int REFUSE = 1003;
    public static final int NOCODE = 1005;
    public static final int ABNORMAL_CLOSE = 1006;
    public static final int NO_UTF8 = 1007;
    public static final int POLICY_VALIDATION = 1008;
    public static final int TOOBIG = 1009;
    public static final int EXTENSION = 1010;
    public static final int UNEXPECTED_CONDITION = 1011;
    public static final int SERVICE_RESTART = 1012;
    public static final int TRY_AGAIN_LATER = 1013;
    public static final int BAD_GATEWAY = 1014;
    public static final int TLS_ERROR = 1015;
    public static final int NEVER_CONNECTED = -1;
    public static final int BUGGYCLOSE = -2;
    public static final int FLASHPOLICY = -3;
    private int h;
    private String i;

    public CloseFrame() {
        CloseFrame closeFrame = this;
        super(Opcode.CLOSING);
        closeFrame.setReason("");
        closeFrame.setCode(1000);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ByteBuffer byteBuffer, int n9) throws InvalidDataException {
        Throwable throwable2;
        block5: {
            ByteBuffer byteBuffer2 = byteBuffer;
            int n10 = n9;
            CloseFrame closeFrame = this;
            ByteBuffer byteBuffer3 = byteBuffer;
            ByteBuffer byteBuffer4 = byteBuffer3;
            byteBuffer3.position(byteBuffer3.position() + 2);
            {
                catch (Throwable throwable2) {
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                {
                    throw new InvalidDataException(1007);
                }
            }
            {
                closeFrame.i = Charsetfunctions.stringUtf8(byteBuffer4);
            }
            byteBuffer2.position(n10);
            return;
        }
        byteBuffer.position(n9);
        throw throwable2;
    }

    private void a() {
        CloseFrame closeFrame = this;
        byte[] byArray = Charsetfunctions.utf8Bytes(closeFrame.i);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(this.h);
        byteBuffer.position(2);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byArray.length + 2);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.put(byArray);
        byteBuffer2.rewind();
        super.setPayload(byteBuffer2);
    }

    public void setCode(int n9) {
        this.h = n9;
        if (n9 == 1015) {
            CloseFrame closeFrame = this;
            closeFrame.h = 1005;
            closeFrame.i = "";
        }
        this.a();
    }

    public void setReason(String string) {
        if (string == null) {
            string = "";
        }
        this.i = string;
        this.a();
    }

    public int getCloseCode() {
        return this.h;
    }

    public String getMessage() {
        return this.i;
    }

    @Override
    @NonNull
    public String toString() {
        return super.toString() + "code: " + this.h;
    }

    @Override
    public void isValid() throws InvalidDataException {
        CloseFrame closeFrame = this;
        super.isValid();
        if (closeFrame.h == 1007 && this.i.isEmpty()) {
            throw new InvalidDataException(1007, "Received text is no valid utf8 string!");
        }
        if (this.h == 1005 && this.i.length() > 0) {
            throw new InvalidDataException(1002, "A close frame must have a closecode if it has a reason");
        }
        int n9 = this.h;
        if (n9 > 1015 && n9 < 3000) {
            throw new InvalidDataException(1002, "Trying to send an illegal close code!");
        }
        if (n9 != 1006 && n9 != 1015 && n9 != 1005 && n9 <= 4999 && n9 >= 1000 && n9 != 1004) {
            return;
        }
        throw new InvalidFrameException("closecode must not be sent over the wire: " + this.h);
    }

    @Override
    public void setPayload(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        CloseFrame closeFrame = this;
        closeFrame.h = 1005;
        closeFrame.i = "";
        byteBuffer2.mark();
        if (byteBuffer2.remaining() == 0) {
            this.h = 1000;
        } else if (byteBuffer.remaining() == 1) {
            this.h = 1002;
        } else {
            if (byteBuffer.remaining() >= 2) {
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(4);
                byteBuffer3.position(2);
                byteBuffer3.putShort(byteBuffer.getShort());
                byteBuffer3.position(0);
                this.h = byteBuffer3.getInt();
            }
            ByteBuffer byteBuffer4 = byteBuffer;
            byteBuffer4.reset();
            try {
                this.a(byteBuffer, byteBuffer4.position());
            }
            catch (InvalidDataException invalidDataException) {
                CloseFrame closeFrame2 = this;
                closeFrame2.h = 1007;
                closeFrame2.i = null;
            }
        }
    }

    @Override
    public ByteBuffer getPayloadData() {
        if (this.h == 1005) {
            return ByteBufferUtils.getEmptyByteBuffer();
        }
        return super.getPayloadData();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            if (!super.equals(object)) {
                return false;
            }
            object = (CloseFrame)object;
            if (this.h != ((CloseFrame)object).h) {
                return false;
            }
            return Objects.equals(this.i, ((CloseFrame)object).i);
        }
        return false;
    }

    @Override
    public int hashCode() {
        CloseFrame closeFrame = this;
        int n9 = (super.hashCode() * 31 + this.h) * 31;
        String string = closeFrame.i;
        int n10 = string != null ? string.hashCode() : 0;
        return n9 + n10;
    }
}

