/*
 * Decompiled with CFR 0.152.
 */
package cn.m4399.operate.support.websocket.drafts;

import android.support.annotation.NonNull;
import cn.m4399.operate.support.websocket.WebSocket;
import cn.m4399.operate.support.websocket.WebSocketImpl;
import cn.m4399.operate.support.websocket.drafts.Draft;
import cn.m4399.operate.support.websocket.enums.CloseHandshakeType;
import cn.m4399.operate.support.websocket.enums.HandshakeState;
import cn.m4399.operate.support.websocket.enums.Opcode;
import cn.m4399.operate.support.websocket.enums.ReadyState;
import cn.m4399.operate.support.websocket.enums.Role;
import cn.m4399.operate.support.websocket.exceptions.IncompleteException;
import cn.m4399.operate.support.websocket.exceptions.InvalidDataException;
import cn.m4399.operate.support.websocket.exceptions.InvalidFrameException;
import cn.m4399.operate.support.websocket.exceptions.InvalidHandshakeException;
import cn.m4399.operate.support.websocket.exceptions.LimitExceededException;
import cn.m4399.operate.support.websocket.exceptions.NotSendableException;
import cn.m4399.operate.support.websocket.extensions.DefaultExtension;
import cn.m4399.operate.support.websocket.extensions.IExtension;
import cn.m4399.operate.support.websocket.framing.BinaryFrame;
import cn.m4399.operate.support.websocket.framing.CloseFrame;
import cn.m4399.operate.support.websocket.framing.Framedata;
import cn.m4399.operate.support.websocket.framing.FramedataImpl1;
import cn.m4399.operate.support.websocket.framing.TextFrame;
import cn.m4399.operate.support.websocket.handshake.ClientHandshake;
import cn.m4399.operate.support.websocket.handshake.ClientHandshakeBuilder;
import cn.m4399.operate.support.websocket.handshake.HandshakeBuilder;
import cn.m4399.operate.support.websocket.handshake.Handshakedata;
import cn.m4399.operate.support.websocket.handshake.ServerHandshake;
import cn.m4399.operate.support.websocket.handshake.ServerHandshakeBuilder;
import cn.m4399.operate.support.websocket.protocols.IProtocol;
import cn.m4399.operate.support.websocket.protocols.Protocol;
import cn.m4399.operate.support.websocket.util.Base64;
import cn.m4399.operate.support.websocket.util.Charsetfunctions;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Draft_6455
extends Draft {
    private static final String o = "Sec-WebSocket-Key";
    private static final String p = "Sec-WebSocket-Protocol";
    private static final String q = "Sec-WebSocket-Extensions";
    private static final String r = "Sec-WebSocket-Accept";
    private static final String s = "Upgrade";
    private static final String t = "Connection";
    static final /* synthetic */ boolean u;
    private final Logger c = Logger.getLogger(Draft_6455.class.getName());
    private IExtension d = new DefaultExtension();
    private final IExtension e = new DefaultExtension();
    private final List<IExtension> f;
    private IExtension g;
    private IProtocol h;
    private final List<IProtocol> i;
    private Framedata j;
    private final List<ByteBuffer> k;
    private ByteBuffer l;
    private final SecureRandom m = new SecureRandom();
    private final int n;

    public Draft_6455() {
        this(Collections.emptyList());
    }

    public Draft_6455(IExtension iExtension) {
        this(Collections.singletonList(iExtension));
    }

    public Draft_6455(List<IExtension> list) {
        this(list, Collections.singletonList(new Protocol("")));
    }

    public Draft_6455(List<IExtension> list, List<IProtocol> list2) {
        this(list, list2, Integer.MAX_VALUE);
    }

    public Draft_6455(List<IExtension> list, int n9) {
        this(list, Collections.singletonList(new Protocol("")), n9);
    }

    public Draft_6455(List<IExtension> list, List<IProtocol> list2, int n9) {
        if (list != null && list2 != null && n9 >= 1) {
            Draft_6455 draft_6455 = this;
            draft_6455.f = new ArrayList<IExtension>(list.size());
            draft_6455.i = new ArrayList<IProtocol>(list2.size());
            boolean bl = false;
            draft_6455.k = new ArrayList<ByteBuffer>();
            Iterator<IExtension> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getClass().equals(DefaultExtension.class)) continue;
                bl = true;
            }
            this.f.addAll(list);
            if (!bl) {
                List<IExtension> list3 = this.f;
                int n10 = list3.size();
                list3.add(n10, this.d);
            }
            Draft_6455 draft_64552 = this;
            this.i.addAll(list2);
            draft_64552.n = n9;
            draft_64552.g = null;
            return;
        }
        throw new IllegalArgumentException();
    }

    private HandshakeState a(String string) {
        for (IProtocol iProtocol : this.i) {
            if (!iProtocol.acceptProvidedProtocol(string)) continue;
            this.h = iProtocol;
            this.c.fine("acceptHandshake - Matching protocol found: " + this.h);
            return HandshakeState.MATCHED;
        }
        return HandshakeState.NOT_MATCHED;
    }

    private ByteBuffer a(Framedata object) {
        block14: {
            ByteBuffer byteBuffer;
            boolean bl;
            ByteBuffer byteBuffer2;
            block12: {
                byte by;
                block13: {
                    block11: {
                        byteBuffer2 = object.getPayloadData();
                        bl = this.a == Role.CLIENT;
                        by = this.b(byteBuffer2);
                        int n9 = 1;
                        byte by2 = by > 1 ? by + 1 : by;
                        n9 = by2 + n9;
                        by2 = bl ? (byte)4 : 0;
                        byteBuffer = ByteBuffer.allocate(n9 + by2 + byteBuffer2.remaining());
                        by2 = this.a(object.getOpcode());
                        by2 = (byte)((byte)(object.isFin() ? -128 : 0) | by2);
                        if (object.isRSV1()) {
                            by2 = (byte)(by2 | this.a(1));
                        }
                        if (object.isRSV2()) {
                            by2 = (byte)(by2 | this.a(2));
                        }
                        if (object.isRSV3()) {
                            by2 = (byte)(by2 | this.a(3));
                        }
                        byteBuffer.put(by2);
                        object = this.a((long)byteBuffer2.remaining(), (int)by);
                        if (!u && ((Object)object).length != by) {
                            throw new AssertionError();
                        }
                        if (by != 1) break block11;
                        byteBuffer.put((byte)(object[0] | this.a(bl)));
                        break block12;
                    }
                    if (by != 2) break block13;
                    byteBuffer.put((byte)(this.a(bl) | 0x7E));
                    byteBuffer.put((byte[])object);
                    break block12;
                }
                if (by != 8) break block14;
                byteBuffer.put((byte)(this.a(bl) | 0x7F));
                byteBuffer.put((byte[])object);
            }
            if (bl) {
                object = ByteBuffer.allocate(4);
                ((ByteBuffer)object).putInt(this.m.nextInt());
                byteBuffer.put(((ByteBuffer)object).array());
                int n10 = 0;
                while (byteBuffer2.hasRemaining()) {
                    byteBuffer.put((byte)(byteBuffer2.get() ^ ((ByteBuffer)object).get(n10 % 4)));
                    ++n10;
                }
            } else {
                byteBuffer.put(byteBuffer2);
                byteBuffer2.flip();
            }
            if (!u && byteBuffer.remaining() != 0) {
                throw new AssertionError(byteBuffer.remaining());
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.flip();
            return byteBuffer3;
        }
        throw new IllegalStateException("Size representation not supported/specified");
    }

    private Framedata c(ByteBuffer object) throws IncompleteException, InvalidDataException {
        if (object != null) {
            int n9 = ((Buffer)object).remaining();
            int n10 = 2;
            ((Draft_6455)((Object)logger)).a(n9, 2);
            byte by = ((ByteBuffer)object).get();
            boolean bl = by >> 8 != 0;
            boolean bl2 = (by & 0x40) != 0;
            boolean bl3 = (by & 0x20) != 0;
            boolean bl4 = (by & 0x10) != 0;
            int n11 = ((ByteBuffer)object).get();
            int n12 = (n11 & 0xFFFFFF80) != 0 ? 1 : 0;
            n11 = n11 & 0x7F;
            Object object2 = ((Draft_6455)((Object)logger)).a((byte)(by & 0xF));
            if (n11 < 0 || n11 > 125) {
                a a10 = ((Draft_6455)((Object)logger)).a((ByteBuffer)object, (Opcode)((Object)object2), n11, n9, n10);
                n11 = a10.a();
                n10 = a10.b();
            }
            ((Draft_6455)((Object)logger)).a((long)n11);
            int n13 = n12 != 0 ? 4 : 0;
            ((Draft_6455)((Object)logger)).a(n9, n10 + n13 + n11);
            Object object3 = ByteBuffer.allocate(((Draft)((Object)logger)).checkAlloc(n11));
            if (n12 != 0) {
                byte[] byArray = new byte[4];
                ((ByteBuffer)object).get(byArray);
                for (n12 = 0; n12 < n11; ++n12) {
                    ((ByteBuffer)object3).put((byte)(((ByteBuffer)object).get() ^ byArray[n12 % 4]));
                }
            } else {
                ByteBuffer byteBuffer = object;
                ByteBuffer byteBuffer2 = object3;
                ByteBuffer byteBuffer3 = object;
                object = byteBuffer3.array();
                n10 = byteBuffer3.position();
                n11 = byteBuffer2.limit();
                byteBuffer2.put((byte[])object, n10, n11);
                byteBuffer.position(byteBuffer.position() + ((Buffer)object3).limit());
            }
            object = FramedataImpl1.get(object2);
            ByteBuffer byteBuffer = object3;
            ((FramedataImpl1)object).setFin(bl);
            ((FramedataImpl1)object).setRSV1(bl2);
            ((FramedataImpl1)object).setRSV2(bl3);
            ((FramedataImpl1)object).setRSV3(bl4);
            byteBuffer.flip();
            ((FramedataImpl1)object).setPayload(byteBuffer);
            if (((FramedataImpl1)object).getOpcode() != Opcode.CONTINUOUS) {
                ((Draft_6455)((Object)logger)).g = !(((FramedataImpl1)object).isRSV1() || ((FramedataImpl1)object).isRSV2() || ((FramedataImpl1)object).isRSV3()) ? ((Draft_6455)((Object)logger)).e : ((Draft_6455)((Object)logger)).getExtension();
            }
            if (((Draft_6455)((Object)logger)).g == null) {
                ((Draft_6455)((Object)logger)).g = ((Draft_6455)((Object)logger)).e;
            }
            Draft_6455 draft_6455 = logger;
            draft_6455.g.isFrameValid((Framedata)object);
            draft_6455.g.decodeFrame((Framedata)object);
            if (draft_6455.c.isLoggable(Level.FINE)) {
                Object object4 = object;
                Logger logger = ((Draft_6455)((Object)logger)).c;
                object3 = "afterDecoding(%s): %s";
                Integer n14 = ((FramedataImpl1)object4).getPayloadData().remaining();
                if (((FramedataImpl1)object4).getPayloadData().remaining() > 1000) {
                    object2 = "too big to display";
                } else {
                    String string;
                    object2 = string;
                    string = new String(((FramedataImpl1)object).getPayloadData().array());
                }
                logger.fine(String.format((String)object3, n14, object2));
            }
            Object object5 = object;
            ((FramedataImpl1)object5).isValid();
            return object5;
        }
        throw new IllegalArgumentException();
    }

    private a a(ByteBuffer byteBuffer, Opcode object, int n9, int n10, int n11) throws InvalidFrameException, IncompleteException, LimitExceededException {
        if (object != Opcode.PING && object != Opcode.PONG && object != Opcode.CLOSING) {
            int n12;
            int n13;
            if (n9 == 126) {
                n13 = n11 + 2;
                this.a(n10, n13);
                byte[] byArray = new byte[3];
                object = byArray;
                object[1] = (Opcode)byteBuffer.get();
                byArray[2] = byteBuffer.get();
                n12 = new BigInteger((byte[])object).intValue();
            } else {
                int n14 = n11 + 8;
                this.a(n10, n14);
                byte[] byArray = new byte[8];
                for (n10 = 0; n10 < 8; ++n10) {
                    byArray[n10] = byteBuffer.get();
                }
                long l9 = new BigInteger(byArray).longValue();
                this.a(l9);
                n12 = (int)l9;
                n13 = n14;
            }
            return new a(n12, n13);
        }
        this.c.fine("Invalid frame: more than 125 octets");
        throw new InvalidFrameException("more than 125 octets");
    }

    private void a(long l9) throws LimitExceededException {
        if (l9 <= Integer.MAX_VALUE) {
            int n9 = this.n;
            if (l9 <= (long)n9) {
                if (l9 >= 0L) {
                    return;
                }
                this.c.fine("Limit underflow: Payloadsize is to little...");
                throw new LimitExceededException("Payloadsize is to little...");
            }
            Integer n10 = n9;
            Long l10 = l9;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n10;
            objectArray[1] = l10;
            this.c.fine(String.format("Payload limit reached. Allowed: %s Current: %s", objectArray2));
            throw new LimitExceededException("Payload limit reached.", this.n);
        }
        this.c.fine("Limit exedeed: Payloadsize is to big...");
        throw new LimitExceededException("Payloadsize is to big...");
    }

    private void a(int n9, int n10) throws IncompleteException {
        if (n9 >= n10) {
            return;
        }
        this.c.fine("Incomplete frame: maxpacketsize < realpacketsize");
        throw new IncompleteException(n10);
    }

    private byte a(int n9) {
        if (n9 != 1) {
            if (n9 != 2) {
                if (n9 != 3) {
                    return 0;
                }
                return 16;
            }
            return 32;
        }
        return 64;
    }

    private byte a(boolean bl) {
        return bl ? (byte)-128 : 0;
    }

    private int b(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() <= 125) {
            return 1;
        }
        if (byteBuffer.remaining() <= 65535) {
            return 2;
        }
        return 8;
    }

    private String e() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(calendar.getTime());
    }

    private String b(String string) {
        String string2 = string.trim();
        try {
            return Base64.encodeBytes(MessageDigest.getInstance("SHA1").digest(((String)string2 + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    private byte[] a(long l9, int n9) {
        int n10 = n9;
        Object object = new byte[n10];
        int n11 = n10 * 8 - 8;
        for (int i9 = 0; i9 < n9; ++i9) {
            object[i9] = (byte)(l9 >>> n11 - i9 * 8);
        }
        return object;
    }

    private byte a(Opcode opcode) {
        if (opcode == Opcode.CONTINUOUS) {
            return 0;
        }
        if (opcode == Opcode.TEXT) {
            return 1;
        }
        if (opcode == Opcode.BINARY) {
            return 2;
        }
        if (opcode == Opcode.CLOSING) {
            return 8;
        }
        if (opcode == Opcode.PING) {
            return 9;
        }
        if (opcode == Opcode.PONG) {
            return 10;
        }
        throw new IllegalArgumentException("Don't know how to handle " + ((Object)((Object)opcode)).toString());
    }

    private Opcode a(byte by) throws InvalidFrameException {
        if (by != 0) {
            if (by != 1) {
                if (by != 2) {
                    switch (by) {
                        default: {
                            throw new InvalidFrameException("Unknown opcode " + (short)by);
                        }
                        case 10: {
                            return Opcode.PONG;
                        }
                        case 9: {
                            return Opcode.PING;
                        }
                        case 8: 
                    }
                    return Opcode.CLOSING;
                }
                return Opcode.BINARY;
            }
            return Opcode.TEXT;
        }
        return Opcode.CONTINUOUS;
    }

    private void a(WebSocketImpl webSocketImpl, Framedata framedata, Opcode opcode) throws InvalidDataException {
        block8: {
            Opcode opcode2;
            block6: {
                block7: {
                    block5: {
                        opcode2 = Opcode.CONTINUOUS;
                        if (opcode == opcode2) break block5;
                        this.b(framedata);
                        break block6;
                    }
                    if (!framedata.isFin()) break block7;
                    this.c(webSocketImpl, framedata);
                    break block6;
                }
                if (this.j == null) break block8;
            }
            if (opcode == Opcode.TEXT && !Charsetfunctions.isValidUTF8(framedata.getPayloadData())) {
                this.c.severe("Protocol error: Payload is not UTF8");
                throw new InvalidDataException(1007);
            }
            if (opcode == opcode2 && this.j != null) {
                this.a(framedata.getPayloadData());
            }
            return;
        }
        this.c.severe("Protocol error: Continuous frame sequence was not started.");
        throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
    }

    private void a(WebSocketImpl webSocketImpl, Framedata framedata) {
        try {
            webSocketImpl.getWebSocketListener().onWebsocketMessage((WebSocket)webSocketImpl, framedata.getPayloadData());
        }
        catch (RuntimeException runtimeException) {
            this.a(webSocketImpl, runtimeException);
        }
    }

    private void a(WebSocketImpl webSocketImpl, RuntimeException runtimeException) {
        this.c.severe("Runtime exception during onWebsocketMessage");
        runtimeException.printStackTrace();
        webSocketImpl.getWebSocketListener().onWebsocketError(webSocketImpl, runtimeException);
    }

    private void d(WebSocketImpl webSocketImpl, Framedata framedata) throws InvalidDataException {
        try {
            webSocketImpl.getWebSocketListener().onWebsocketMessage((WebSocket)webSocketImpl, Charsetfunctions.stringUtf8(framedata.getPayloadData()));
        }
        catch (RuntimeException runtimeException) {
            this.a(webSocketImpl, runtimeException);
        }
    }

    private void c(WebSocketImpl webSocketImpl, Framedata framedata) throws InvalidDataException {
        if (this.j != null) {
            Draft_6455 draft_6455 = this;
            draft_6455.a(framedata.getPayloadData());
            draft_6455.a();
            if (draft_6455.j.getOpcode() == Opcode.TEXT) {
                Draft_6455 draft_64552 = this;
                ((FramedataImpl1)draft_64552.j).setPayload(this.d());
                ((FramedataImpl1)draft_64552.j).isValid();
                try {
                    webSocketImpl.getWebSocketListener().onWebsocketMessage((WebSocket)webSocketImpl, Charsetfunctions.stringUtf8(this.j.getPayloadData()));
                }
                catch (RuntimeException runtimeException) {
                    this.a(webSocketImpl, runtimeException);
                }
            } else if (this.j.getOpcode() == Opcode.BINARY) {
                Draft_6455 draft_64553 = this;
                ((FramedataImpl1)draft_64553.j).setPayload(this.d());
                ((FramedataImpl1)draft_64553.j).isValid();
                try {
                    webSocketImpl.getWebSocketListener().onWebsocketMessage((WebSocket)webSocketImpl, this.j.getPayloadData());
                }
                catch (RuntimeException runtimeException) {
                    this.a(webSocketImpl, runtimeException);
                }
            }
            this.j = null;
            this.b();
            return;
        }
        this.c.fine("Protocol error: Previous continuous frame sequence not completed.");
        throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
    }

    private void b(Framedata framedata) throws InvalidDataException {
        if (this.j == null) {
            Draft_6455 draft_6455 = this;
            this.j = framedata;
            draft_6455.a(framedata.getPayloadData());
            draft_6455.a();
            return;
        }
        this.c.fine("Protocol error: Previous continuous frame sequence not completed.");
        throw new InvalidDataException(1002, "Previous continuous frame sequence not completed.");
    }

    private void b(WebSocketImpl webSocketImpl, Framedata framedata) {
        int n9 = 1005;
        String string = "";
        if (framedata instanceof CloseFrame) {
            CloseFrame closeFrame = (CloseFrame)framedata;
            n9 = closeFrame.getCloseCode();
            string = closeFrame.getMessage();
        }
        if (webSocketImpl.getReadyState() == ReadyState.CLOSING) {
            webSocketImpl.closeConnection(n9, string, true);
        } else if (this.getCloseHandshakeType() == CloseHandshakeType.TWOWAY) {
            webSocketImpl.close(n9, string, true);
        } else {
            webSocketImpl.flushAndClose(n9, string, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        List<ByteBuffer> list = this.k;
        synchronized (list) {
            this.k.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ByteBuffer byteBuffer) {
        List<ByteBuffer> list = this.k;
        synchronized (list) {
            this.k.add(byteBuffer);
            return;
        }
    }

    private void a() throws LimitExceededException {
        long l9 = this.c();
        if (l9 <= (long)this.n) {
            return;
        }
        Draft_6455 draft_6455 = this;
        draft_6455.b();
        Integer n9 = this.n;
        Long l10 = l9;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n9;
        objectArray[1] = l10;
        draft_6455.c.fine(String.format("Payload limit reached. Allowed: %s Current: %s", objectArray2));
        throw new LimitExceededException(this.n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer d() throws LimitExceededException {
        Object object;
        Draft_6455 draft_6455 = byteBuffer;
        long l9 = 0L;
        List<ByteBuffer> list = draft_6455.k;
        synchronized (list) {
            Iterator<ByteBuffer> iterator;
            try {
                Iterator<ByteBuffer> iterator2 = draft_6455.k.iterator();
                while (iterator2.hasNext()) {
                    l9 += (long)iterator2.next().limit();
                }
                Draft_6455 draft_64552 = byteBuffer;
                ((Draft_6455)((Object)byteBuffer)).a();
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)l9);
                iterator = draft_64552.k.iterator();
            }
            catch (Throwable throwable) {}
            throw throwable;
            while (iterator.hasNext()) {
                byteBuffer.put(iterator.next());
            }
            {
                Object object2 = byteBuffer;
                object = object2;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl24 : MonitorExitStatement: MONITOREXIT : var3_3
                ((ByteBuffer)object2).flip();
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long c() {
        Draft_6455 draft_6455 = list;
        long l9 = 0L;
        List<ByteBuffer> list = draft_6455.k;
        synchronized (list) {
            try {
                Iterator<ByteBuffer> iterator = draft_6455.k.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return l9;
                    }
                    l9 += (long)iterator.next().limit();
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    static {
        u = Draft_6455.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public HandshakeState acceptHandshakeAsServer(ClientHandshake object) throws InvalidHandshakeException {
        if (this.b((Handshakedata)object) != 13) {
            this.c.fine("acceptHandshakeAsServer - Wrong websocket version.");
            return HandshakeState.NOT_MATCHED;
        }
        HandshakeState handshakeState = HandshakeState.NOT_MATCHED;
        String string = object.getFieldValue(q);
        for (IExtension iExtension : this.f) {
            if (!iExtension.acceptProvidedExtensionAsServer(string)) continue;
            this.d = iExtension;
            handshakeState = HandshakeState.MATCHED;
            this.c.fine("acceptHandshakeAsServer - Matching extension found: " + this.d);
            break;
        }
        if (this.a(object.getFieldValue(p)) == (object = HandshakeState.MATCHED) && handshakeState == object) {
            return object;
        }
        this.c.fine("acceptHandshakeAsServer - No matching extension or protocol found.");
        return HandshakeState.NOT_MATCHED;
    }

    @Override
    public HandshakeState acceptHandshakeAsClient(ClientHandshake object, ServerHandshake object2) throws InvalidHandshakeException {
        if (!this.a((Handshakedata)object2)) {
            this.c.fine("acceptHandshakeAsClient - Missing/wrong upgrade or connection in handshake.");
            return HandshakeState.NOT_MATCHED;
        }
        if (object.hasFieldValue(o) && object2.hasFieldValue(r)) {
            ClientHandshake clientHandshake = object;
            object = object2.getFieldValue(r);
            if (!this.b(clientHandshake.getFieldValue(o)).equals(object)) {
                this.c.fine("acceptHandshakeAsClient - Wrong key for Sec-WebSocket-Key.");
                return HandshakeState.NOT_MATCHED;
            }
            object = HandshakeState.NOT_MATCHED;
            String string = object2.getFieldValue(q);
            for (IExtension iExtension : this.f) {
                if (!iExtension.acceptProvidedExtensionAsClient(string)) continue;
                this.d = iExtension;
                object = HandshakeState.MATCHED;
                this.c.fine("acceptHandshakeAsClient - Matching extension found: " + this.d);
                break;
            }
            if (this.a(object2.getFieldValue(p)) == (object2 = HandshakeState.MATCHED) && object == object2) {
                return object2;
            }
            this.c.fine("acceptHandshakeAsClient - No matching extension or protocol found.");
            return HandshakeState.NOT_MATCHED;
        }
        this.c.fine("acceptHandshakeAsClient - Missing Sec-WebSocket-Key or Sec-WebSocket-Accept");
        return HandshakeState.NOT_MATCHED;
    }

    public IExtension getExtension() {
        return this.d;
    }

    public List<IExtension> getKnownExtensions() {
        return this.f;
    }

    public IProtocol getProtocol() {
        return this.h;
    }

    public int getMaxFrameSize() {
        return this.n;
    }

    public List<IProtocol> getKnownProtocols() {
        return this.i;
    }

    @Override
    public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(ClientHandshakeBuilder clientHandshakeBuilder) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder4;
        ClientHandshakeBuilder clientHandshakeBuilder2 = clientHandshakeBuilder;
        clientHandshakeBuilder2.put(s, "websocket");
        clientHandshakeBuilder2.put(t, s);
        byte[] byArray = new byte[16];
        ((Draft_6455)((Object)stringBuilder4)).m.nextBytes(byArray);
        clientHandshakeBuilder2.put(o, Base64.encodeBytes(byArray));
        clientHandshakeBuilder2.put("Sec-WebSocket-Version", "13");
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2 = new StringBuilder();
        for (IExtension iExtension : ((Draft_6455)((Object)stringBuilder4)).f) {
            if (iExtension.getProvidedExtensionAsClient() == null || iExtension.getProvidedExtensionAsClient().length() == 0) continue;
            if (stringBuilder3.length() > 0) {
                stringBuilder3.append(", ");
            }
            stringBuilder3.append(iExtension.getProvidedExtensionAsClient());
        }
        if (stringBuilder3.length() != 0) {
            clientHandshakeBuilder.put(q, stringBuilder3.toString());
        }
        Draft_6455 draft_6455 = stringBuilder4;
        stringBuilder4 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (IProtocol iProtocol : draft_6455.i) {
            if (iProtocol.getProvidedProtocol().length() == 0) continue;
            if (stringBuilder4.length() > 0) {
                stringBuilder4.append(", ");
            }
            stringBuilder4.append(iProtocol.getProvidedProtocol());
        }
        if (stringBuilder4.length() != 0) {
            clientHandshakeBuilder.put(p, stringBuilder4.toString());
        }
        return clientHandshakeBuilder;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(ClientHandshake object, ServerHandshakeBuilder serverHandshakeBuilder) throws InvalidHandshakeException {
        serverHandshakeBuilder.put(s, "websocket");
        serverHandshakeBuilder.put(t, object.getFieldValue(t));
        object = object.getFieldValue(o);
        if (object != null && !"".equals(object)) {
            serverHandshakeBuilder.put(r, this.b((String)object));
            if (this.getExtension().getProvidedExtensionAsServer().length() != 0) {
                serverHandshakeBuilder.put(q, this.getExtension().getProvidedExtensionAsServer());
            }
            if (this.getProtocol() != null && this.getProtocol().getProvidedProtocol().length() != 0) {
                serverHandshakeBuilder.put(p, this.getProtocol().getProvidedProtocol());
            }
            ServerHandshakeBuilder serverHandshakeBuilder2 = serverHandshakeBuilder;
            ServerHandshakeBuilder serverHandshakeBuilder3 = serverHandshakeBuilder;
            serverHandshakeBuilder3.setHttpStatusMessage("Web Socket Protocol Handshake");
            serverHandshakeBuilder3.put("Server", "TooTallNate Java-WebSocket");
            serverHandshakeBuilder2.put("Date", this.e());
            return serverHandshakeBuilder2;
        }
        throw new InvalidHandshakeException("missing Sec-WebSocket-Key");
    }

    @Override
    public Draft copyInstance() {
        ArrayList arrayList;
        ArrayList<IExtension> arrayList2;
        ArrayList<IExtension> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<IExtension>();
        Object object = this.getKnownExtensions().iterator();
        while (object.hasNext()) {
            arrayList3.add(object.next().copyInstance());
        }
        object = arrayList;
        arrayList = new ArrayList();
        Iterator<IProtocol> iterator = this.getKnownProtocols().iterator();
        while (iterator.hasNext()) {
            ((ArrayList)object).add(iterator.next().copyInstance());
        }
        int n9 = this.n;
        return new Draft_6455(arrayList3, (List<IProtocol>)object, n9);
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        Draft_6455 draft_6455 = this;
        draft_6455.getExtension().encodeFrame(framedata);
        if (draft_6455.c.isLoggable(Level.FINE)) {
            String string;
            Framedata framedata2 = framedata;
            Logger logger = this.c;
            String string2 = "afterEncoding(%s): %s";
            Integer n9 = framedata2.getPayloadData().remaining();
            if (framedata2.getPayloadData().remaining() > 1000) {
                string = "too big to display";
            } else {
                String string3;
                string = string3;
                string3 = new String(framedata.getPayloadData().array());
            }
            logger.fine(String.format(string2, n9, string));
        }
        return this.a(framedata);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Framedata> translateFrame(ByteBuffer byteBuffer) throws InvalidDataException {
        Object object;
        while (true) {
            IncompleteException incompleteException2;
            block14: {
                int n9;
                block15: {
                    ByteBuffer byteBuffer2;
                    ByteBuffer byteBuffer3;
                    int n10;
                    ByteBuffer byteBuffer4;
                    Draft_6455 draft_6455;
                    LinkedList<Framedata> linkedList;
                    object = linkedList;
                    linkedList = new LinkedList<Framedata>();
                    if (this.l == null) break;
                    try {
                        draft_6455 = this;
                        ByteBuffer byteBuffer5 = byteBuffer;
                        byteBuffer4 = byteBuffer5;
                        byteBuffer5.mark();
                    }
                    catch (IncompleteException incompleteException2) {
                        break block14;
                    }
                    {
                        n10 = byteBuffer4.remaining();
                        n9 = draft_6455.l.remaining();
                        if (n9 <= n10) break block15;
                    }
                    {
                        ByteBuffer byteBuffer6 = byteBuffer;
                        byteBuffer3 = byteBuffer6;
                        byteBuffer2 = byteBuffer6;
                        ByteBuffer byteBuffer7 = byteBuffer;
                        object = byteBuffer7.array();
                        this.l.put((byte[])object, byteBuffer7.position(), n10);
                    }
                    {
                        byteBuffer2.position(byteBuffer3.position() + n10);
                    }
                    return Collections.emptyList();
                }
                Draft_6455 draft_6455 = this;
                ByteBuffer byteBuffer8 = byteBuffer;
                ByteBuffer byteBuffer9 = byteBuffer;
                byte[] byArray = byteBuffer9.array();
                this.l.put(byArray, byteBuffer9.position(), n9);
                {
                    byteBuffer8.position(byteBuffer8.position() + n9);
                }
                {
                    object.add(draft_6455.c((ByteBuffer)draft_6455.l.duplicate().position(0)));
                }
                {
                    this.l = null;
                    break;
                }
            }
            object = ByteBuffer.allocate(this.checkAlloc(incompleteException2.getPreferredSize()));
            if (!u && ((Buffer)object).limit() <= this.l.limit()) {
                throw new AssertionError();
            }
            Draft_6455 draft_6455 = this;
            draft_6455.l.rewind();
            ((ByteBuffer)object).put(draft_6455.l);
            this.l = this.l;
        }
        while (byteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer10 = byteBuffer;
            byteBuffer10.mark();
            try {
                object.add((Framedata)this.c(byteBuffer10));
            }
            catch (IncompleteException incompleteException) {
                ByteBuffer byteBuffer11;
                byteBuffer.reset();
                this.l = byteBuffer11 = ByteBuffer.allocate(this.checkAlloc(incompleteException.getPreferredSize()));
                byteBuffer11.put(byteBuffer);
                return object;
            }
        }
        return object;
    }

    @Override
    public List<Framedata> createFrames(ByteBuffer byteBuffer, boolean bl) {
        BinaryFrame binaryFrame;
        BinaryFrame binaryFrame2 = binaryFrame;
        binaryFrame2();
        binaryFrame2.setPayload(byteBuffer);
        binaryFrame.setTransferemasked(bl);
        try {
            binaryFrame.isValid();
        }
        catch (InvalidDataException invalidDataException) {
            throw new NotSendableException(invalidDataException);
        }
        return Collections.singletonList(binaryFrame);
    }

    @Override
    public List<Framedata> createFrames(String string, boolean bl) {
        TextFrame textFrame;
        TextFrame textFrame2 = textFrame;
        textFrame2();
        textFrame2.setPayload(ByteBuffer.wrap(Charsetfunctions.utf8Bytes(string)));
        textFrame.setTransferemasked(bl);
        try {
            textFrame.isValid();
        }
        catch (InvalidDataException invalidDataException) {
            throw new NotSendableException(invalidDataException);
        }
        return Collections.singletonList(textFrame);
    }

    @Override
    public void reset() {
        DefaultExtension defaultExtension;
        ((Draft_6455)((Object)defaultExtension2)).l = null;
        IExtension iExtension = ((Draft_6455)((Object)defaultExtension2)).d;
        if (iExtension != null) {
            iExtension.reset();
        }
        Draft_6455 draft_6455 = defaultExtension2;
        DefaultExtension defaultExtension2 = defaultExtension;
        defaultExtension = new DefaultExtension();
        draft_6455.d = defaultExtension2;
        draft_6455.h = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void processFrame(WebSocketImpl webSocketImpl, Framedata framedata) throws InvalidDataException {
        Opcode opcode = framedata.getOpcode();
        if (opcode == Opcode.CLOSING) {
            this.b(webSocketImpl, framedata);
            return;
        }
        if (opcode == Opcode.PING) {
            webSocketImpl.getWebSocketListener().onWebsocketPing(webSocketImpl, framedata);
            return;
        }
        if (opcode == Opcode.PONG) {
            WebSocketImpl webSocketImpl2 = webSocketImpl;
            webSocketImpl2.updateLastPong();
            webSocketImpl2.getWebSocketListener().onWebsocketPong(webSocketImpl, framedata);
            return;
        }
        if (framedata.isFin() && opcode != Opcode.CONTINUOUS) {
            if (this.j != null) {
                this.c.severe("Protocol error: Continuous frame sequence not completed.");
                throw new InvalidDataException(1002, "Continuous frame sequence not completed.");
            }
            if (opcode == Opcode.TEXT) {
                this.d(webSocketImpl, framedata);
                return;
            }
            if (opcode == Opcode.BINARY) {
                this.a(webSocketImpl, framedata);
                return;
            }
            this.c.severe("non control or continious frame expected");
            throw new InvalidDataException(1002, "non control or continious frame expected");
        }
        this.a(webSocketImpl, framedata, opcode);
    }

    @Override
    public CloseHandshakeType getCloseHandshakeType() {
        return CloseHandshakeType.TWOWAY;
    }

    @Override
    @NonNull
    public String toString() {
        Draft_6455 draft_6455 = this;
        String string = super.toString();
        if (draft_6455.getExtension() != null) {
            string = string + " extension: " + this.getExtension().toString();
        }
        if (this.getProtocol() != null) {
            string = string + " protocol: " + this.getProtocol().toString();
        }
        return string + " max frame size: " + this.n;
    }

    public boolean equals(Object object) {
        if (iProtocol == object) {
            return true;
        }
        if (object != null && iProtocol.getClass() == object.getClass()) {
            if (((Draft_6455)((Object)iProtocol)).n != ((Draft_6455)(object = (Draft_6455)object)).getMaxFrameSize()) {
                return false;
            }
            IExtension iExtension = ((Draft_6455)((Object)iProtocol)).d;
            if (iExtension != null ? !iExtension.equals(((Draft_6455)object).getExtension()) : ((Draft_6455)object).getExtension() != null) {
                return false;
            }
            IProtocol iProtocol = ((Draft_6455)((Object)iProtocol)).h;
            return iProtocol != null ? iProtocol.equals(((Draft_6455)object).getProtocol()) : ((Draft_6455)object).getProtocol() == null;
        }
        return false;
    }

    public int hashCode() {
        IExtension iExtension = this.d;
        int n9 = (iExtension != null ? iExtension.hashCode() : 0) * 31;
        IProtocol iProtocol = this.h;
        int n10 = iProtocol != null ? iProtocol.hashCode() : 0;
        int n11 = this.n;
        return (n9 + n10) * 31 + (n11 ^ n11 >>> 32);
    }

    private static class a {
        private final int a;
        private final int b;

        private int a() {
            return this.a;
        }

        private int b() {
            return this.b;
        }

        a(int n9, int n10) {
            this.a = n9;
            this.b = n10;
        }
    }
}

