/*
 * Decompiled with CFR 0.152.
 */
package cn.m4399.operate.support;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import cn.m4399.operate.support.AlContext;

public class Device {
    public static final String Platform = "Android";
    public static final String Model = Build.MODEL;
    public static final String SystemVersion = Build.VERSION.RELEASE;
    @SuppressLint(value={"AnnotateVersionCheck"})
    public static final int SDK_INT = Build.VERSION.SDK_INT;
    public static final String SDK = String.valueOf(SDK_INT);
    private static final String a = "NO NETWORK";

    public static boolean networkTypeIsMobile() {
        return Device.networkTypeIsMobile(Device.networkType());
    }

    public static boolean networkTypeIsMobile(@NonNull String string) {
        return "2G".equals(string) || "3G".equals(string) || "4G".equals(string) || "5G".equals(string) || "MOBILE".equals(string);
    }

    public static boolean networkTypeIsWifi() {
        return Device.networkTypeIsWifi(Device.networkType());
    }

    public static boolean networkTypeIsWifi(@NonNull String string) {
        return "WIFI".equals(string);
    }

    public static boolean noAvailableNetwork() {
        return a.equals(Device.networkType());
    }

    public static String networkType() {
        Object object = (ConnectivityManager)AlContext.appContext().getApplicationContext().getSystemService("connectivity");
        if (object == null) {
            return a;
        }
        NetworkInfo networkInfo = object.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            networkInfo = object.getNetworkInfo(1);
            if (networkInfo != null && (networkInfo = networkInfo.getState()) != null && (networkInfo == NetworkInfo.State.CONNECTED || networkInfo == NetworkInfo.State.CONNECTING)) {
                return "WIFI";
            }
            if ((object = object.getNetworkInfo(0)) != null && object.getState() != null && (object.getState() == NetworkInfo.State.CONNECTED || object.getState() == NetworkInfo.State.CONNECTING)) {
                int n9 = object.getSubtype();
                if (n9 != 20) {
                    switch (n9) {
                        default: {
                            object = object.getSubtypeName();
                            if (!(((String)object).equalsIgnoreCase("TD-SCDMA") || ((String)object).equalsIgnoreCase("WCDMA") || ((String)object).equalsIgnoreCase("CDMA2000"))) {
                                return "MOBILE";
                            }
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                    }
                    return "2G";
                }
                return "5G";
            }
            return a;
        }
        return a;
    }

    @NonNull
    public String toString() {
        return "Device{Platform='Android', Model='" + Model + '\'' + ", SystemVersion='" + SystemVersion + '\'' + ", SDK_INT=" + SDK_INT + ", SDK='" + SDK + '\'' + ", networkType='" + Device.networkType() + '\'' + "}";
    }
}

