/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.record;

import android.graphics.YuvImage;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.tencent.cloud.huiyansdkface.normal.tools.WLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;

public class VideoEncoder {
    private static final String a = VideoEncoder.class.getSimpleName();
    public static final int COLOR_FORMAT_YUV_420_SEMI_PLANAR = 21;
    private IYUVToVideoEncoderCallback b;
    private File c;
    private ConcurrentLinkedQueue<YuvImage> d = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Object> e = new ConcurrentLinkedQueue();
    private byte[] f;
    private MediaCodec g;
    private MediaMuxer h;
    private boolean i = false;
    private final Object j = new Object();
    private final Object k = new Object();
    private CountDownLatch l;
    private static int m;
    private static int n;
    private boolean o = false;
    private int p = 0;
    private int q;
    private int r = 0;
    private boolean s = false;
    private boolean t = false;
    private boolean u = false;
    private int v = 21;
    private int w = 0;
    private byte[] x = new byte[0];
    private ByteArrayOutputStream y;

    public VideoEncoder(IYUVToVideoEncoderCallback iYUVToVideoEncoderCallback, boolean bl) {
        this.b = iYUVToVideoEncoderCallback;
        this.o = bl;
    }

    public boolean isEncodingStarted() {
        return this.u;
    }

    public int getYUVImageSize() {
        return this.d.size();
    }

    public int getColorFormat() {
        return this.w;
    }

    public void startEncoding(int n, int n2, File file, int n3, int n4, int n5) {
        String string;
        if (Build.VERSION.SDK_INT < 18) {
            WLogger.w((String)a, (String)"not support recording!");
            return;
        }
        WLogger.d((String)a, (String)"startEncoding");
        if (!this.o) {
            return;
        }
        m = n;
        VideoEncoder.n = n2;
        this.c = file;
        try {
            string = file.getCanonicalPath();
            WLogger.d((String)a, (String)"new MediaMuxer");
            if (this.h == null) {
                this.h = new MediaMuxer(string, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.w((String)a, (String)("Unable to get path for " + file + "," + exception.toString()));
            return;
        }
        WLogger.d((String)a, (String)"selectCodec");
        string = VideoEncoder.a("video/avc");
        if (string == null) {
            WLogger.e((String)a, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        WLogger.i((String)a, (String)("found codec: " + string.getName()));
        this.v = 21;
        try {
            this.w = this.v = VideoEncoder.a((MediaCodecInfo)string, "video/avc");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.e((String)a, (String)"Unable to find color format use default");
            this.v = 21;
        }
        try {
            this.g = MediaCodec.createByCodecName((String)string.getName());
            WLogger.d((String)a, (String)"Create videoEncoder createByCodecName");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.w((String)a, (String)("Unable to create MediaCodec " + exception.toString()));
            return;
        }
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)m, (int)VideoEncoder.n);
            mediaFormat.setInteger("bitrate", n3);
            mediaFormat.setInteger("frame-rate", n4);
            mediaFormat.setInteger("color-format", this.v);
            mediaFormat.setInteger("i-frame-interval", n5);
            this.g.configure(mediaFormat, (Surface)null, (MediaCrypto)null, 1);
            this.g.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.e((String)a, (String)("encoder configure failed:" + exception.toString()));
            return;
        }
        WLogger.i((String)a, (String)("Initialization complete. Starting encoder..." + Thread.currentThread().getName()));
        this.u = true;
    }

    public void startEncodingH264(int n, int n2, ByteArrayOutputStream byteArrayOutputStream, int n3, int n4, int n5) {
        if (Build.VERSION.SDK_INT < 18) {
            WLogger.w((String)a, (String)"not support recording!");
            return;
        }
        WLogger.d((String)a, (String)"startEncoding");
        if (!this.o) {
            return;
        }
        m = n;
        VideoEncoder.n = n2;
        this.y = byteArrayOutputStream;
        WLogger.d((String)a, (String)"selectCodec");
        MediaCodecInfo mediaCodecInfo = VideoEncoder.a("video/avc");
        if (mediaCodecInfo == null) {
            WLogger.e((String)a, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        WLogger.i((String)a, (String)("found codec: " + mediaCodecInfo.getName()));
        this.v = 21;
        try {
            this.w = this.v = VideoEncoder.a(mediaCodecInfo, "video/avc");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.e((String)a, (String)"Unable to find color format use default");
            this.v = 21;
        }
        try {
            this.g = MediaCodec.createByCodecName((String)mediaCodecInfo.getName());
            WLogger.d((String)a, (String)"Create videoEncoder createByCodecName");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.w((String)a, (String)("Unable to create MediaCodec " + exception.toString()));
            return;
        }
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)m, (int)VideoEncoder.n);
            mediaFormat.setInteger("bitrate", n3);
            mediaFormat.setInteger("frame-rate", n4);
            mediaFormat.setInteger("color-format", this.v);
            mediaFormat.setInteger("i-frame-interval", n5);
            this.g.configure(mediaFormat, (Surface)null, (MediaCrypto)null, 1);
            this.g.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLogger.e((String)a, (String)("encoder configure failed:" + exception.toString()));
            return;
        }
        WLogger.i((String)a, (String)("Initialization complete. Starting encoder..." + Thread.currentThread().getName()));
        this.u = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEncoding() {
        this.u = false;
        if (!this.o) {
            return;
        }
        if (this.g != null && this.h != null) {
            WLogger.i((String)a, (String)"Stopping encoding");
            this.s = true;
            Object object = this.j;
            synchronized (object) {
                if (this.l != null && this.l.getCount() > 0L) {
                    this.l.countDown();
                }
            }
            this.a();
        } else {
            Log.i((String)a, (String)"Failed to stop encoding since it never started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEncodingH264() {
        this.u = false;
        if (!this.o) {
            return;
        }
        if (this.g != null) {
            WLogger.i((String)a, (String)"Stopping encodingH264");
            this.s = true;
            Object object = this.j;
            synchronized (object) {
                if (this.l != null && this.l.getCount() > 0L) {
                    this.l.countDown();
                }
            }
            this.a();
        } else {
            Log.i((String)a, (String)"Failed to stop encoding since it never started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEncoding() {
        this.u = false;
        if (this.c != null) {
            WLogger.d((String)a, (String)"Clean up record file");
            this.c.delete();
            this.c = null;
        }
        if (this.y != null) {
            try {
                this.y.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WLogger.e((String)a, (String)("byteOutput close failed:" + exception.toString()));
            }
            this.y = null;
            WLogger.d((String)a, (String)"RELEASE byteOutput");
        }
        if (this.o) {
            if (this.g != null && this.h != null) {
                WLogger.i((String)a, (String)"Aborting encoding");
                this.a();
                this.s = true;
                this.t = true;
                this.d = new ConcurrentLinkedQueue();
                Object object = this.j;
                synchronized (object) {
                    if (this.l != null && this.l.getCount() > 0L) {
                        this.l.countDown();
                    }
                }
            } else {
                WLogger.i((String)a, (String)"Failed to abort encoding since it never started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFrame(YuvImage yuvImage) {
        if (!this.o) {
            return;
        }
        if (this.g != null && this.h != null) {
            WLogger.d((String)a, (String)"Queueing frame");
            this.d.add(yuvImage);
            Object object = this.j;
            synchronized (object) {
                if (this.l != null && this.l.getCount() > 0L) {
                    this.l.countDown();
                }
            }
        } else {
            Log.d((String)a, (String)"Failed to queue frame. Encoding not started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFrameH264(YuvImage yuvImage) {
        if (!this.o) {
            return;
        }
        if (this.g != null) {
            WLogger.d((String)a, (String)"Queueing H264 frame");
            this.d.add(yuvImage);
            Object object = this.j;
            synchronized (object) {
                if (this.l != null && this.l.getCount() > 0L) {
                    this.l.countDown();
                }
            }
        } else {
            Log.d((String)a, (String)"Failed to queue frame. Encoding not started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode() {
        block22: {
            if (!this.o) {
                return;
            }
            if (this.u) {
                Object object;
                WLogger.d((String)a, (String)"Encoder started");
                if (this.s && this.d.size() == 0) {
                    return;
                }
                YuvImage yuvImage = this.d.poll();
                if (yuvImage == null) {
                    object = this.j;
                    synchronized (object) {
                        this.l = new CountDownLatch(1);
                    }
                    try {
                        this.l.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    yuvImage = this.d.poll();
                }
                if (yuvImage != null) {
                    try {
                        int n;
                        Object object2;
                        object = this.a(m, VideoEncoder.n, yuvImage);
                        long l2 = 200000L;
                        int n2 = this.g.dequeueInputBuffer(l2);
                        long l3 = this.a(this.p, 30);
                        if (n2 >= 0) {
                            object2 = this.a(com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a, n2);
                            ((ByteBuffer)object2).clear();
                            ((ByteBuffer)object2).put((byte[])object);
                            this.g.queueInputBuffer(n2, 0, ((Object)object).length, l3, 0);
                            ++this.p;
                        }
                        if ((n = this.g.dequeueOutputBuffer((MediaCodec.BufferInfo)(object2 = new MediaCodec.BufferInfo()), l2)) == -1) {
                            WLogger.e((String)a, (String)"No output from encoder available");
                            break block22;
                        }
                        if (n == -2) {
                            MediaFormat mediaFormat = this.g.getOutputFormat();
                            this.a(com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a, mediaFormat);
                            break block22;
                        }
                        if (n < 0) {
                            WLogger.e((String)a, (String)("unexpected result from encoder.dequeueOutputBuffer: " + n));
                            break block22;
                        }
                        if (((MediaCodec.BufferInfo)object2).size == 0) break block22;
                        ByteBuffer byteBuffer = this.b(com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a, n);
                        if (byteBuffer == null) {
                            WLogger.e((String)a, (String)("encoderOutputBuffer " + n + " was null"));
                            break block22;
                        }
                        byteBuffer.position(((MediaCodec.BufferInfo)object2).offset);
                        byteBuffer.limit(((MediaCodec.BufferInfo)object2).offset + ((MediaCodec.BufferInfo)object2).size);
                        WLogger.d((String)a, (String)("media muxer write video data outputindex " + this.p));
                        MediaMuxer mediaMuxer = this.h;
                        synchronized (mediaMuxer) {
                            this.h.writeSampleData(this.q, byteBuffer, (MediaCodec.BufferInfo)object2);
                        }
                        this.g.releaseOutputBuffer(n, false);
                        WLogger.d((String)a, (String)"videoEncoder releaseOutputBuffer");
                    }
                    catch (Exception exception) {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        exception.printStackTrace(printWriter);
                        String string = stringWriter.toString();
                        try {
                            stringWriter.close();
                            printWriter.close();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        WLogger.e((String)a, (String)string);
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeH264() {
        if (!this.o) {
            return;
        }
        if (this.u) {
            Object object;
            WLogger.d((String)a, (String)"Encoder started");
            if (this.s && this.d.size() == 0) {
                return;
            }
            YuvImage yuvImage = this.d.poll();
            if (yuvImage == null) {
                object = this.j;
                synchronized (object) {
                    this.l = new CountDownLatch(1);
                }
                try {
                    this.l.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                yuvImage = this.d.poll();
            }
            if (yuvImage != null) {
                try {
                    int n;
                    Object object2;
                    object = this.a(m, VideoEncoder.n, yuvImage);
                    long l2 = 200000L;
                    int n2 = this.g.dequeueInputBuffer(l2);
                    long l3 = this.a(this.p, 30);
                    if (n2 >= 0) {
                        object2 = this.a(com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a, n2);
                        ((ByteBuffer)object2).clear();
                        ((ByteBuffer)object2).put((byte[])object);
                        this.g.queueInputBuffer(n2, 0, ((Object)object).length, l3, 0);
                        ++this.p;
                    }
                    if ((n = this.g.dequeueOutputBuffer((MediaCodec.BufferInfo)(object2 = new MediaCodec.BufferInfo()), l2)) == -1) {
                        WLogger.e((String)a, (String)"No output from encoder available");
                    } else if (n == -2) {
                        WLogger.d((String)a, (String)"start output");
                    } else if (n < 0) {
                        WLogger.e((String)a, (String)("unexpected result from encoder.dequeueOutputBuffer: " + n));
                    } else if (((MediaCodec.BufferInfo)object2).size != 0) {
                        ByteBuffer byteBuffer = this.b(com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a, n);
                        byte[] byArray = new byte[((MediaCodec.BufferInfo)object2).size];
                        byteBuffer.get(byArray);
                        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1 && byArray[4] == 103) {
                            this.x = byArray;
                        } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1 && byArray[4] == 101) {
                            byte[] byArray2 = new byte[this.x.length + byArray.length];
                            System.arraycopy(this.x, 0, byArray2, 0, this.x.length);
                            System.arraycopy(byArray, 0, byArray2, this.x.length, byArray.length);
                            byArray = byArray2;
                        }
                        this.y.write(byArray);
                        this.g.releaseOutputBuffer(n, false);
                        byArray = null;
                        WLogger.d((String)a, (String)"videoEncoder releaseOutputBuffer");
                    }
                }
                catch (Exception exception) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    String string = stringWriter.toString();
                    try {
                        stringWriter.close();
                        printWriter.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    WLogger.e((String)a, (String)string);
                    exception.printStackTrace();
                }
            }
        }
    }

    private ByteBuffer a(a a2, int n) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.g.getInputBuffer(n);
        }
        return this.g.getInputBuffers()[n];
    }

    private ByteBuffer b(a a2, int n) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.g.getOutputBuffer(n);
        }
        return this.g.getOutputBuffers()[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        WLogger.d((String)a, (String)"release");
        Object object = this.k;
        synchronized (object) {
            if (this.g != null) {
                try {
                    this.g.stop();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    WLogger.w((String)a, (String)("videoEncoder stop failed:" + exception.toString()));
                }
                this.g.release();
                this.g = null;
                WLogger.d((String)a, (String)"RELEASE Video CODEC");
            }
            if (this.h != null) {
                try {
                    this.h.stop();
                    this.h.release();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    WLogger.e((String)a, (String)("media muxer stop failed:" + exception.toString()));
                }
                this.h = null;
                this.i = false;
                WLogger.d((String)a, (String)"RELEASE MUXER");
            }
        }
    }

    private static MediaCodecInfo a(String string) {
        int n = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    private static int a(MediaCodecInfo mediaCodecInfo, String string) {
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
        for (int i2 = 0; i2 < codecCapabilities.colorFormats.length; ++i2) {
            int n = codecCapabilities.colorFormats[i2];
            WLogger.d((String)a, (String)("found colorformat: " + n));
            if (!VideoEncoder.a(n)) continue;
            return n;
        }
        return 0;
    }

    private static boolean a(int n) {
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 2130706688: {
                return true;
            }
        }
        return false;
    }

    private byte[] a(int n, int n2, YuvImage yuvImage) {
        return this.v == 21 ? this.b(n, n2, yuvImage) : this.c(n, n2, yuvImage);
    }

    private byte[] b(int n, int n2, YuvImage yuvImage) {
        if (this.f == null) {
            this.f = new byte[n * n2 * 3 / 2];
        }
        byte[] byArray = yuvImage.getYuvData();
        int n3 = n * n2;
        if (n3 >= 0) {
            System.arraycopy(byArray, 0, this.f, 0, n3);
        }
        for (int i2 = n3; i2 < n3 * 3 / 2; ++i2) {
            if ((i2 + 1) % 2 != 0) continue;
            this.f[i2] = byArray[i2 - 1];
            this.f[i2 - 1] = byArray[i2];
        }
        return this.f;
    }

    private byte[] c(int n, int n2, YuvImage yuvImage) {
        if (this.f == null) {
            this.f = new byte[n * n2 * 3 / 2];
        }
        byte[] byArray = yuvImage.getYuvData();
        int n3 = n * n2;
        if (n3 >= 0) {
            System.arraycopy(byArray, 0, this.f, 0, n3);
        }
        int n4 = n3;
        int n5 = n3 + n3 / 4;
        for (int i2 = n3; i2 < n3 * 3 / 2; i2 += 2) {
            this.f[n5] = byArray[i2];
            this.f[n4] = byArray[i2 + 1];
            ++n5;
            ++n4;
        }
        return this.f;
    }

    private long a(long l2, int n) {
        return 132L + l2 * 1000000L / (long)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(a a2, MediaFormat mediaFormat) {
        Object object = this.k;
        synchronized (object) {
            if (!this.i) {
                if (a2 == com.tencent.cloud.huiyansdkface.record.VideoEncoder$a.a) {
                    this.q = this.h.addTrack(mediaFormat);
                    ++this.r;
                }
                if (this.r >= 1) {
                    WLogger.d((String)a, (String)"Media muxer is starting...");
                    this.h.start();
                    this.i = true;
                    this.k.notifyAll();
                }
            }
        }
    }

    public static interface IYUVToVideoEncoderCallback {
        public void onEncodingComplete(File var1);
    }

    private static enum a {
        a;

    }
}

