/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wejson;

import android.text.TextUtils;
import android.util.Log;
import com.tencent.cloud.huiyansdkface.wejson.WeJsonException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WeJson {
    private static final String EMPTY_MAP = "{}";
    private static final String EMPTY_ARR = "[]";
    private boolean cutLongStr = false;
    private int longStringLength = 262144;
    private static final String[] replacementArr = new String[128];

    public <T> String toJson(T t2) {
        return this.toJson(t2, 0);
    }

    public <T> String toJson(T t2, int n2) {
        if (t2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.process(stringBuilder, t2);
        return stringBuilder.toString();
    }

    private <T> void process(StringBuilder stringBuilder, T object) {
        if (object.getClass().isPrimitive()) {
            stringBuilder.append(object);
            return;
        }
        if (object instanceof String) {
            object = (String)object;
            if (this.cutLongStr && ((String)object).length() > this.longStringLength) {
                object = ((String)object).substring(0, 256) + "....." + (((String)object).length() - 512) + "........." + ((String)object).substring(((String)object).length() - 256);
            }
            this.string(stringBuilder, (String)object);
            return;
        }
        if (this.isPrimitivePackageType(object)) {
            stringBuilder.append(object);
            return;
        }
        if (object.getClass().isArray()) {
            this.processArr(stringBuilder, (Object[])object);
            return;
        }
        if (object instanceof Iterable) {
            this.processIterable(stringBuilder, (Iterable)object);
            return;
        }
        if (object instanceof Map) {
            this.processMap(stringBuilder, (Map)object);
            return;
        }
        this.processObj(stringBuilder, object);
    }

    public void setCutLongStr(boolean bl) {
        this.cutLongStr = bl;
    }

    public void setLongStringLength(int n2) {
        if (n2 < 600) {
            n2 = 600;
        }
        this.longStringLength = n2;
    }

    private void string(StringBuilder stringBuilder, String string) {
        String[] stringArray = replacementArr;
        stringBuilder.append("\"");
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n2 < i2) {
                stringBuilder.append(string, n2, i2);
            }
            stringBuilder.append(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            stringBuilder.append(string, n2, n3);
        }
        stringBuilder.append("\"");
    }

    private <T> boolean isPrimitivePackageType(T t2) {
        return t2 instanceof Integer || t2 instanceof Short || t2 instanceof Long || t2 instanceof Byte || t2 instanceof Boolean || t2 instanceof Float || t2 instanceof Double || t2 instanceof Character;
    }

    private void processMap(StringBuilder stringBuilder, Map<String, Object> object) {
        if (object.size() == 0) {
            stringBuilder.append(EMPTY_MAP);
            return;
        }
        stringBuilder.append('{');
        int n2 = 0;
        int n3 = object.size();
        for (Map.Entry entry : object.entrySet()) {
            Object v2 = entry.getValue();
            String string = (String)entry.getKey();
            if (string == null || string.equals("") || v2 == null || v2 instanceof String && entry.equals("")) continue;
            stringBuilder.append('\"').append(string).append('\"');
            stringBuilder.append(':');
            this.process(stringBuilder, v2);
            if (n2 < n3 - 1) {
                stringBuilder.append(',');
            }
            ++n2;
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private <T> void processObj(StringBuilder stringBuilder, T object) {
        int n2;
        int n3;
        Object object2;
        Class<?> clazz;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz2 = clazz = object.getClass(); clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            object2 = clazz2.getDeclaredFields();
            for (int i2 = 0; i2 < ((Field[])object2).length; ++i2) {
                arrayList.add(object2[i2]);
            }
        }
        if (arrayList.size() == 0) {
            stringBuilder.append(EMPTY_MAP);
            return;
        }
        object2 = new HashMap();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            Object object4;
            Object object5 = (Field)arrayList.get(n3);
            n2 = ((Field)object5).getModifiers();
            if ((n2 & 8) != 0 || ((String)(object4 = ((Field)object5).getName())).contains("$")) continue;
            if ((n2 & 1) != 0) {
                void var10_18;
                Object illegalAccessException = null;
                try {
                    Object invocationTargetException = ((Field)object5).get(object);
                }
                catch (IllegalAccessException illegalAccessException2) {
                    Log.w((String)"WeJson", (String)("read public field value failed:" + illegalAccessException2.getMessage()));
                }
                if (var10_18 == null) continue;
                object2.put(object4, var10_18);
                continue;
            }
            try {
                Method method = clazz.getMethod("get" + ((String)object4).substring(0, 1).toUpperCase() + (((String)object4).length() == 1 ? "" : ((String)object4).substring(1)), new Class[0]);
                if (method == null || (object5 = method.invoke(object, new Object[0])) == null) continue;
                object2.put(object4, object5);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)"WeJson", (String)("read field value by getter method failed:" + illegalAccessException.getMessage()));
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.w((String)"WeJson", (String)("read field value by getter method failed:" + invocationTargetException.getMessage()));
            }
        }
        stringBuilder.append('{');
        n3 = 0;
        n2 = object2.size();
        for (Map.Entry entry : object2.entrySet()) {
            ++n3;
            String string = (String)entry.getKey();
            object = entry.getValue();
            if (object == null) continue;
            stringBuilder.append('\"').append(string).append('\"').append(':');
            this.process(stringBuilder, object);
            if (n3 >= n2) continue;
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append('}');
    }

    private void processIterable(StringBuilder stringBuilder, Iterable object) {
        object = object.iterator();
        stringBuilder.append('[');
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 == null) continue;
            this.process(stringBuilder, e2);
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(']');
    }

    private <T> void processArr(StringBuilder stringBuilder, Object[] objectArray) {
        if (objectArray.length == 0) {
            stringBuilder.append(EMPTY_ARR);
            return;
        }
        stringBuilder.append('[');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            this.process(stringBuilder, objectArray[i2]);
            if (i2 >= objectArray.length - 1) continue;
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(']');
    }

    public <T> T fromJson(String string, Class<T> clazz) throws WeJsonException {
        return this.fromJson(string, (Type)clazz);
    }

    public <T> T fromJson(String string, Type type) throws WeJsonException {
        block9: {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            if (type == null) {
                throw new WeJsonException("\u5fc5\u987b\u6307\u5b9atypeOfT");
            }
            if ((string = string.trim()).startsWith("[")) {
                try {
                    string = new JSONArray(string);
                    string = this.fromJsonArr((JSONArray)string, type);
                    if (string != null) {
                        return (T)string;
                    }
                    break block9;
                }
                catch (Exception exception) {
                    throw new WeJsonException("json resolve err:" + exception.getMessage(), exception);
                }
            }
            if (string.startsWith("{")) {
                try {
                    string = new JSONObject(string);
                    return (T)this.fromJsonObj((JSONObject)string, type);
                }
                catch (Exception exception) {
                    throw new WeJsonException("json resolve err:" + exception.getMessage(), exception);
                }
            }
        }
        throw new WeJsonException("illegal json format");
    }

    public <T> T fromJsonArr(JSONArray jSONArray, Type object) throws WeJsonException {
        if (object == null) {
            object = List.class;
        }
        if (object instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object;
            Class clazz = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(clazz)) {
                return (T)this.fromList(jSONArray, clazz, this.getComponentTypeOfList((Type)object, jSONArray));
            }
            throw new WeJsonException("unsupported type:" + clazz);
        }
        if (object instanceof GenericArrayType) {
            return this.fromArr(jSONArray, (GenericArrayType)object);
        }
        if (object instanceof Class) {
            Class clazz = (Class)object;
            boolean bl = clazz.isArray();
            if (bl) {
                return this.fromArr(jSONArray, clazz.getComponentType());
            }
            if (List.class.isAssignableFrom(clazz)) {
                return (T)this.fromList(jSONArray, clazz, this.getComponentTypeOfList(clazz, jSONArray));
            }
        }
        throw new WeJsonException("unsupported type:" + object);
    }

    private Type getComponentTypeOfList(Type type, JSONArray jSONArray) throws WeJsonException {
        block3: {
            String string = "java.util.List";
            while (true) {
                Class clazz;
                if (type instanceof Class) {
                    clazz = (Class)type;
                    if ((type = this.getTypeOfList(type, string, jSONArray)) == null) {
                        type = clazz.getGenericSuperclass();
                        continue;
                    }
                    return type;
                }
                if (!(type instanceof ParameterizedType)) break block3;
                clazz = (Class)((ParameterizedType)type).getRawType();
                if ((type = this.getTypeOfList(type, string, jSONArray)) != null) break;
                type = clazz.getGenericSuperclass();
            }
            return type;
        }
        throw new WeJsonException("unsupported type:" + type);
    }

    private Type getTypeOfList(Type type, String object, JSONArray jSONArray) throws WeJsonException {
        if (type instanceof Class) {
            object = (Class)type;
        } else if (type instanceof ParameterizedType) {
            object = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new WeJsonException("unsupported type of list:" + type);
        }
        if (object.equals(List.class) || object.equals(ArrayList.class) || object.equals(LinkedList.class)) {
            object = null;
            if (type instanceof Class) {
                object = this.getValueType(jSONArray.opt(0));
            } else if (type instanceof ParameterizedType) {
                object = ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return object;
        }
        return null;
    }

    public Object fromJsonObj(JSONObject jSONObject, Type object) throws WeJsonException {
        if (object == null) {
            object = Map.class;
        }
        if (object instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object;
            Class clazz = (Class)parameterizedType.getRawType();
            if (Map.class.isAssignableFrom(clazz) || HashMap.class.isAssignableFrom(clazz)) {
                object = parameterizedType.getActualTypeArguments()[1];
                return this.fromMap(jSONObject, clazz, (Type)object);
            }
            return this.fromPojo(jSONObject, (Type)object);
        }
        if (object instanceof Class) {
            if (object.equals(Map.class) || object.equals(HashMap.class)) {
                return this.fromMap(jSONObject, (Class)object, null);
            }
            return this.fromPojo(jSONObject, (Type)object);
        }
        throw new WeJsonException("unsupported type:" + object);
    }

    private List fromList(JSONArray jSONArray, Class<List> object, Type type) throws WeJsonException {
        if (((Class)object).getName().equals("java.util.List")) {
            object = new ArrayList();
        } else {
            try {
                object = ((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new WeJsonException("\u521b\u5efaList\u7c7b\u578b\u5931\u8d25,\u8be5\u5217\u8868\u4e0d\u652f\u6301\u65e0\u53c2\u5b9e\u4f8b\u5316", exception);
            }
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object2 = this.getObject(jSONArray, i2);
            if (type == null && !(object2 instanceof JSONObject) && !(object2 instanceof JSONArray)) {
                object.add(object2);
                continue;
            }
            if (object2 instanceof JSONArray) {
                object.add(this.fromJsonArr((JSONArray)object2, type));
                continue;
            }
            if (object2 instanceof JSONObject) {
                object.add(this.fromJsonObj((JSONObject)object2, type));
                continue;
            }
            object.add(object2);
        }
        return object;
    }

    private Map fromMap(JSONObject jSONObject, Class<Map> object, Type type) throws WeJsonException {
        if (((Class)object).getName().equals("java.util.Map")) {
            object = new HashMap();
        } else {
            try {
                object = ((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new WeJsonException("\u521b\u5efaMap\u7c7b\u578b\u5931\u8d25,\u8be5Map\u4e0d\u652f\u6301\u65e0\u53c2\u5b9e\u4f8b\u5316", exception);
            }
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object2 = this.getObject(jSONObject, string);
            if (object2 != null) {
                if (type == null && !(object2 instanceof JSONObject) && !(object2 instanceof JSONArray)) {
                    object.put(string, object2);
                    continue;
                }
                Class<List> clazz = type;
                if (object2 instanceof JSONObject && clazz == null) {
                    clazz = Map.class;
                } else if (object2 instanceof JSONArray && clazz == null) {
                    clazz = List.class;
                }
                object.put(string, this.fromJsonData(object2, (Type)((Object)clazz)));
                continue;
            }
            object.put(string, null);
        }
        return object;
    }

    private Object getObject(JSONArray object, int n2) throws WeJsonException {
        try {
            object = object.get(n2);
        }
        catch (JSONException jSONException) {
            throw new WeJsonException("JSONArray.get() cause JSONException", jSONException);
        }
        return object;
    }

    private Object getObject(JSONObject object, String string) throws WeJsonException {
        try {
            object = object.get(string);
        }
        catch (JSONException jSONException) {
            throw new WeJsonException("JSONObject.get() cause JSONException", jSONException);
        }
        return object;
    }

    private Object fromJsonData(Object object, Type type) throws WeJsonException {
        if (object instanceof JSONArray) {
            return this.fromJsonArr((JSONArray)object, type);
        }
        if (object instanceof JSONObject) {
            return this.fromJsonObj((JSONObject)object, type);
        }
        return object;
    }

    private <T> T fromArr(JSONArray jSONArray, GenericArrayType type) throws WeJsonException {
        type = type.getGenericComponentType();
        Object object = this.getClassOfType(type);
        object = Array.newInstance(object, jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object2 = this.getObject(jSONArray, i2);
            Array.set(object, i2, this.fromJsonData(object2, type));
        }
        return (T)object;
    }

    private <T> T fromArr(JSONArray jSONArray, Class clazz) throws WeJsonException {
        Object object = Array.newInstance(clazz, jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object2 = this.getObject(jSONArray, i2);
            Array.set(object, i2, this.fromJsonData(object2, clazz));
        }
        return (T)object;
    }

    private Class getClassOfType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            return null;
        }
        return null;
    }

    private Object fromPojo(JSONObject jSONObject, Type type) throws WeJsonException {
        Object object;
        Class clazz;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class clazz2 = clazz = this.getClassOfType(type); clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            object = clazz2.getDeclaredFields();
            for (int i2 = 0; i2 < ((Field[])object).length; ++i2) {
                arrayList.add(object[i2]);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        try {
            object = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WeJsonException("\u5fc5\u987b\u4e3a\u8be5\u7c7b\u578b\u63d0\u4f9b\u4e00\u4e2a\u65e0\u53c2\u6784\u9020\u65b9\u6cd5:" + clazz.getName(), exception);
        }
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            boolean bl;
            Class<?> clazz3;
            Object object2 = (Field)arrayList.get(i3);
            Object object3 = ((Field)object2).getName();
            if (((String)object3).contains("$")) continue;
            int n2 = ((Field)object2).getModifiers();
            Object object4 = jSONObject.opt((String)object3);
            if (object4 == null) continue;
            if (JSONObject.NULL.equals(object4 = this.fromJsonData(object4, this.getMemberType(type, (Field)object2, object4)))) {
                object4 = null;
            }
            boolean bl2 = (clazz3 = ((Field)object2).getType()).equals(Double.class) || clazz3.equals(Double.TYPE);
            boolean bl3 = clazz3.equals(Float.class) || clazz3.equals(Float.TYPE);
            boolean bl4 = bl = clazz3.equals(Long.class) || clazz3.equals(Long.TYPE);
            if ((n2 & 1) != 0) {
                try {
                    if (object4 instanceof Number) {
                        if (bl2) {
                            ((Field)object2).set(object, ((Number)object4).doubleValue());
                            continue;
                        }
                        if (bl3) {
                            ((Field)object2).set(object, Float.valueOf(((Number)object4).floatValue()));
                            continue;
                        }
                        if (bl) {
                            ((Field)object2).set(object, ((Number)object4).longValue());
                            continue;
                        }
                        ((Field)object2).set(object, object4);
                        continue;
                    }
                    ((Field)object2).set(object, object4);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new WeJsonException("\u8bbe\u7f6e\u6210\u5458\u53d8\u91cf\u503c\u5931\u8d25.", illegalAccessException);
                }
            }
            object2 = "set" + ((String)object3).substring(0, 1).toUpperCase() + (((String)object3).length() == 1 ? "" : ((String)object3).substring(1));
            object3 = clazz3;
            try {
                object2 = clazz.getMethod((String)object2, new Class[]{object3});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            try {
                if (object4 instanceof Number) {
                    if (bl2) {
                        ((Method)object2).invoke(object, ((Number)object4).doubleValue());
                        continue;
                    }
                    if (bl3) {
                        ((Method)object2).invoke(object, Float.valueOf(((Number)object4).floatValue()));
                        continue;
                    }
                    if (bl) {
                        ((Method)object2).invoke(object, ((Number)object4).longValue());
                        continue;
                    }
                    ((Method)object2).invoke(object, object4);
                    continue;
                }
                ((Method)object2).invoke(object, object4);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WeJsonException("\u8c03\u7528set\u65b9\u6cd5\u5931\u8d25.", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WeJsonException("\u8c03\u7528set\u65b9\u6cd5\u5931\u8d25.", invocationTargetException);
            }
        }
        return object;
    }

    private <T> Type getMemberType(Type type, Field object, Object object2) throws WeJsonException {
        if ((object = ((Field)object).getGenericType()) instanceof TypeVariable) {
            object = this.getClassOfType(type);
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            type = ((Class)object).getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                type = (ParameterizedType)type;
                return type.getActualTypeArguments()[0];
            }
            return this.getValueType(object2);
        }
        if (object instanceof ParameterizedType) {
            return object;
        }
        if (object instanceof Class) {
            return object;
        }
        if (object instanceof GenericArrayType) {
            return object;
        }
        throw new WeJsonException("unsupported member type:" + object);
    }

    private Type getValueType(Object object) {
        if (object == null) {
            return String.class;
        }
        if (object instanceof JSONObject) {
            return Map.class;
        }
        if (object instanceof JSONArray) {
            return List.class;
        }
        if (object instanceof String) {
            return String.class;
        }
        if (object instanceof Integer) {
            return Integer.class;
        }
        if (object instanceof Long) {
            return Long.class;
        }
        if (object instanceof Boolean) {
            return Boolean.class;
        }
        if (object instanceof Double) {
            return Double.class;
        }
        return String.class;
    }

    private <T> Type getSubType(Type type, Field field, Object object) throws WeJsonException {
        object = field.getGenericType();
        type = this.getClassOfType(type);
        if (object instanceof TypeVariable) {
            object = ((Class)type).getGenericSuperclass();
            if (object instanceof ParameterizedType) {
                type = ((ParameterizedType)object).getActualTypeArguments()[0];
                if (type instanceof Class) {
                    if ((type = ((Class)type).getGenericSuperclass()) instanceof ParameterizedType) {
                        if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                            return (Class)type;
                        }
                        throw new WeJsonException("\u4e0d\u652f\u6301\u8fd9\u79cd\u5d4c\u5957\u6a21\u5f0f");
                    }
                    return null;
                }
                if (type instanceof ParameterizedType) {
                    if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                        return (Class)type;
                    }
                    throw new WeJsonException("\u4e0d\u652f\u6301\u8fd9\u79cd\u5d4c\u5957\u6a21\u5f0f");
                }
                throw new WeJsonException("\u4e0d\u652f\u6301\u5d4c\u5957\u6cdb\u578b");
            }
            throw new WeJsonException("\u7f3a\u5c11\u6cdb\u578b\u4fe1\u606f:" + type);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            if (object instanceof ParameterizedType) {
                if ((object = ((ParameterizedType)object).getActualTypeArguments()[0]) instanceof Class) {
                    return (Class)object;
                }
                throw new WeJsonException("\u4e0d\u652f\u6301\u5d4c\u5957\u6cdb\u578b:" + field.getName());
            }
            throw new WeJsonException("\u7f3a\u5c11\u6cdb\u578b\u7c7b\u578b\u58f0\u660e:" + field.getName());
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            if (object instanceof ParameterizedType) {
                if ((object = ((ParameterizedType)object).getActualTypeArguments()[1]) instanceof Class) {
                    return (Class)object;
                }
                throw new WeJsonException("\u4e0d\u652f\u6301\u5d4c\u5957\u6cdb\u578b:" + field.getName());
            }
            throw new WeJsonException("\u7f3a\u5c11\u6cdb\u578b\u7c7b\u578b\u58f0\u660e:" + field.getName());
        }
        if (object instanceof ParameterizedType) {
            if ((object = ((ParameterizedType)object).getActualTypeArguments()[0]) instanceof Class) {
                return (Class)object;
            }
            throw new WeJsonException("\u4e0d\u652f\u6301\u5d4c\u5957\u6cdb\u578b:" + field.getName());
        }
        if (object instanceof WildcardType) {
            throw new WeJsonException("\u4e0d\u652f\u6301WildcardType\u7c7b\u578b\u7684\u6cdb\u578b:" + field.getName());
        }
        if (object instanceof GenericArrayType) {
            if ((object = ((GenericArrayType)object).getGenericComponentType()) instanceof ParameterizedType) {
                return (Class)((ParameterizedType)object).getRawType();
            }
            return (Class)object;
        }
        return null;
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            WeJson.replacementArr[i2] = String.format("\\u%04x", i2);
        }
        WeJson.replacementArr[34] = "\\\"";
        WeJson.replacementArr[92] = "\\\\";
        WeJson.replacementArr[9] = "\\t";
        WeJson.replacementArr[8] = "\\b";
        WeJson.replacementArr[10] = "\\n";
        WeJson.replacementArr[13] = "\\r";
        WeJson.replacementArr[12] = "\\f";
    }

    public static class TypeToken<T> {
        public Type type() {
            Type type = this.getClass().getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            throw new RuntimeException("weJson:get type failed");
        }
    }
}

