/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wehttp2;

import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.wehttp2.HttpsCertificateUtils;
import com.tencent.cloud.huiyansdkface.wehttp2.Pin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PinManager {
    private volatile String a;
    private Object b = new Object();
    private List<Pin> c = new ArrayList<Pin>();
    private List<Pin> d = new ArrayList<Pin>();

    public PinManager setPinDefHostPattern(String string) {
        if (string != null) {
            this.a = string;
        }
        return this;
    }

    public String getPinDefHostPattern() {
        return this.a;
    }

    public PinManager setErrorPins(String ... stringArray) {
        this.setErrorPins4Host(this.a, stringArray);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PinManager setErrorPins4Host(String string, String ... stringArray) {
        Object object = this.b;
        synchronized (object) {
            this.a(string, true);
            return this.addErrorPins4Host(string, stringArray);
        }
    }

    public PinManager setPins(String ... stringArray) {
        return this.setPins4Host(this.a, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PinManager setPins4Host(String string, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("must set  pin host");
        }
        Object object = this.b;
        synchronized (object) {
            this.a(string, false);
            this.addPins4Host(string, stringArray);
        }
        return this;
    }

    public PinManager addPemPins(String ... stringArray) {
        return this.addPemPins4Host(this.a, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PinManager addPemPins4Host(String string, String ... stringArray) {
        LinkedList<Pin> linkedList = new LinkedList<Pin>();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2 == null || string2.isEmpty()) continue;
                string2 = HttpsCertificateUtils.getFingerPrint(HttpsCertificateUtils.getCertificate(string2));
                linkedList.add(new Pin(string, "sha256/" + ByteString.decodeHex(string2).base64()));
            }
        }
        Object object = this.b;
        synchronized (object) {
            this.c.addAll(0, linkedList);
        }
        return this;
    }

    public PinManager addPins(String ... stringArray) {
        return this.addPins4Host(this.a, stringArray);
    }

    public PinManager addErrorPins(String ... stringArray) {
        return this.addErrorPins4Host(this.a, stringArray);
    }

    public PinManager addPins4Host(String string, String ... stringArray) {
        return this.a(this.c, string, stringArray);
    }

    public PinManager addErrorPins4Host(String string, String ... stringArray) {
        return this.a(this.d, string, stringArray);
    }

    @Deprecated
    public PinManager addPins(List<byte[]> list) {
        return this.addPins4Host(this.a, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public PinManager addPins4Host(String string, List<byte[]> list) {
        if (list == null) {
            return this;
        }
        Object object = this.b;
        synchronized (object) {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                byte[] byArray = list.get(i2);
                if (byArray == null) continue;
                this.c.add(0, new Pin(string, "sha1/" + ByteString.of(byArray).base64()));
            }
        }
        return this;
    }

    public List<String> getPins(String string) {
        return this.a(this.c, string);
    }

    public List<String> getErrorPins(String string) {
        return this.a(this.d, string);
    }

    public List<String> getPins() {
        return this.b(this.c, this.a);
    }

    public List<String> getErrorPins() {
        return this.b(this.d, this.a);
    }

    public List<Pin> getAllPinErrorList() {
        return Collections.unmodifiableList(this.d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pin> getAllPinList() {
        Object object = this.b;
        synchronized (object) {
            return Collections.unmodifiableList(this.c);
        }
    }

    public String[] getPinArray4HostPattern(String object) {
        object = this.b(this.c, (String)object);
        return object.toArray(new String[object.size()]);
    }

    public List<String> getPinList4HostPattern(String string) {
        return this.b(this.c, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PinManager a(List<Pin> list, String string, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("must set  pin host");
        }
        if (stringArray == null) {
            return this;
        }
        Object object = this.b;
        synchronized (object) {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                String string2 = stringArray[i2];
                if (string2 == null) continue;
                list.add(0, new Pin(string, string2));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> a(List<Pin> object, String string) {
        Object object2 = this.b;
        synchronized (object2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Pin pin = (Pin)object.next();
                if (!pin.match(string)) continue;
                arrayList.add(pin.getPin());
            }
            return arrayList;
        }
    }

    public String pinListToString() {
        return this.pinListToString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pinListToString(String object) {
        Object object2 = this.b;
        synchronized (object2) {
            List<String> list;
            HashMap<String, ArrayList<String>> object32 = new HashMap<String, ArrayList<String>>();
            for (Pin pin : this.c) {
                String string = pin.getPattern();
                if (object != null && !((String)((Object)object)).equals(string)) continue;
                list = (ArrayList<String>)object32.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    object32.put(string, (ArrayList<String>)list);
                }
                list.add(pin.getPin());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : object32.entrySet()) {
                stringBuilder.append((String)entry.getKey() + ":\n");
                list = (List)entry.getValue();
                for (String string : list) {
                    stringBuilder.append("\t" + string);
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString().trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> b(List<Pin> object, String string) {
        Object object2 = this.b;
        synchronized (object2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Pin pin = (Pin)object.next();
                if (!pin.getPattern().equals(string)) continue;
                arrayList.add(pin.getPin());
            }
            return arrayList;
        }
    }

    private void a(String string, boolean bl) {
        if (string == null) {
            return;
        }
        Object object = bl ? this.d : this.c;
        object = object.iterator();
        while (object.hasNext()) {
            Pin pin = (Pin)object.next();
            if (!pin.getPattern().equals(string)) continue;
            object.remove();
        }
    }
}

