/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okio;

import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import com.tencent.cloud.huiyansdkface.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSink
implements BufferedSink {
    public final Buffer buffer = new Buffer();
    public final Sink sink;
    boolean closed;

    RealBufferedSink(Sink sink) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        this.sink = sink;
    }

    @Override
    public final Buffer buffer() {
        return this.buffer;
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(buffer, l2);
        this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink write(ByteString byteString) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byteString);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeUtf8(String string) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeUtf8(String string, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string, n2, n3);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeUtf8CodePoint(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8CodePoint(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeString(String string, Charset charset) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeString(string, charset);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeString(String string, int n2, int n3, Charset charset) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeString(string, n2, n3, charset);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray, n2, n3);
        return this.emitCompleteSegments();
    }

    @Override
    public final int write(ByteBuffer byteBuffer) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        int n2 = this.buffer.write(byteBuffer);
        this.emitCompleteSegments();
        return n2;
    }

    @Override
    public final long writeAll(Source source) throws IOException {
        long l2;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l3 = 0L;
        while ((l2 = source.read(this.buffer, 8192L)) != -1L) {
            l3 += l2;
            this.emitCompleteSegments();
        }
        return l3;
    }

    @Override
    public final BufferedSink write(Source source, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = source.read(this.buffer, l2);
            if (l3 == -1L) {
                throw new EOFException();
            }
            l2 -= l3;
            this.emitCompleteSegments();
        }
        return this;
    }

    @Override
    public final BufferedSink writeByte(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeByte(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeShort(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShort(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeShortLe(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShortLe(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeInt(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeInt(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeIntLe(int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeIntLe(n2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeLong(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLong(l2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeLongLe(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLongLe(l2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeDecimalLong(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeDecimalLong(l2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink writeHexadecimalUnsignedLong(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeHexadecimalUnsignedLong(l2);
        return this.emitCompleteSegments();
    }

    @Override
    public final BufferedSink emitCompleteSegments() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l2 = this.buffer.completeSegmentByteCount();
        if (l2 > 0L) {
            this.sink.write(this.buffer, l2);
        }
        return this;
    }

    @Override
    public final BufferedSink emit() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l2 = this.buffer.size();
        if (l2 > 0L) {
            this.sink.write(this.buffer, l2);
        }
        return this;
    }

    @Override
    public final OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                if (RealBufferedSink.this.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSink.this.buffer.writeByte((byte)n2);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                if (RealBufferedSink.this.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSink.this.buffer.write(byArray, n2, n3);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void flush() throws IOException {
                if (!RealBufferedSink.this.closed) {
                    RealBufferedSink.this.flush();
                }
            }

            @Override
            public void close() throws IOException {
                RealBufferedSink.this.close();
            }

            public String toString() {
                return RealBufferedSink.this + ".outputStream()";
            }
        };
    }

    @Override
    public final void flush() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size > 0L) {
            this.sink.write(this.buffer, this.buffer.size);
        }
        this.sink.flush();
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    @Override
    public final void close() throws IOException {
        Throwable throwable;
        block7: {
            if (this.closed) {
                return;
            }
            throwable = null;
            try {
                if (this.buffer.size > 0L) {
                    this.sink.write(this.buffer, this.buffer.size);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block7;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    public final String toString() {
        return "buffer(" + this.sink + ")";
    }
}

