/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okio;

import com.tencent.cloud.huiyansdkface.okio.AsyncTimeout;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.RealBufferedSink;
import com.tencent.cloud.huiyansdkface.okio.RealBufferedSource;
import com.tencent.cloud.huiyansdkface.okio.Segment;
import com.tencent.cloud.huiyansdkface.okio.SegmentPool;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import com.tencent.cloud.huiyansdkface.okio.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Sink(){

            @Override
            public final void write(Buffer buffer, long l2) throws IOException {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    timeout.throwIfReached();
                    Segment segment = buffer.head;
                    int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                    outputStream.write(segment.data, segment.pos, n2);
                    segment.pos += n2;
                    l2 -= (long)n2;
                    buffer.size -= (long)n2;
                    if (segment.pos != segment.limit) continue;
                    buffer.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
            }

            @Override
            public final void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public final void close() throws IOException {
                outputStream.close();
            }

            @Override
            public final Timeout timeout() {
                return timeout;
            }

            public final String toString() {
                return "sink(" + outputStream + ")";
            }
        };
    }

    public static Sink sink(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException("socket == null");
        }
        if (closeable.getOutputStream() == null) {
            throw new IOException("socket's output stream == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.sink(closeable.getOutputStream(), asyncTimeout);
        return asyncTimeout.sink((Sink)closeable);
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Source(){

            @Override
            public final long read(Buffer buffer, long l2) throws IOException {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + l2);
                }
                if (l2 == 0L) {
                    return 0L;
                }
                try {
                    timeout.throwIfReached();
                    Segment segment = buffer.writableSegment(1);
                    int n2 = (int)Math.min(l2, (long)(8192 - segment.limit));
                    n2 = inputStream.read(segment.data, segment.limit, n2);
                    if (n2 == -1) {
                        return -1L;
                    }
                    segment.limit += n2;
                    buffer.size += (long)n2;
                    return n2;
                }
                catch (AssertionError assertionError) {
                    AssertionError assertionError2 = assertionError;
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        throw new IOException((Throwable)((Object)assertionError2));
                    }
                    throw assertionError2;
                }
            }

            @Override
            public final void close() throws IOException {
                inputStream.close();
            }

            @Override
            public final Timeout timeout() {
                return timeout;
            }

            public final String toString() {
                return "source(" + inputStream + ")";
            }
        };
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source(new FileInputStream(file));
    }

    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.source(Files.newInputStream(path, openOptionArray));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file, true));
    }

    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.sink(Files.newOutputStream(path, openOptionArray));
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public final void write(Buffer buffer, long l2) throws IOException {
                buffer.skip(l2);
            }

            @Override
            public final void flush() throws IOException {
            }

            @Override
            public final Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public final void close() throws IOException {
            }
        };
    }

    public static Source source(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException("socket == null");
        }
        if (closeable.getInputStream() == null) {
            throw new IOException("socket's input stream == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.source(closeable.getInputStream(), asyncTimeout);
        return asyncTimeout.source((Source)closeable);
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected final IOException newTimeoutException(IOException iOException) {
                SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
                if (iOException != null) {
                    socketTimeoutException.initCause(iOException);
                }
                return socketTimeoutException;
            }

            @Override
            protected final void timedOut() {
                try {
                    socket.close();
                    return;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to close timed out socket " + socket, exception);
                    return;
                }
                catch (AssertionError assertionError) {
                    AssertionError assertionError2 = assertionError;
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        logger.log(Level.WARNING, "Failed to close timed out socket " + socket, (Throwable)((Object)assertionError2));
                        return;
                    }
                    throw assertionError2;
                }
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }
}

