/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.ws;

import com.tencent.cloud.huiyansdkface.okhttp3.internal.ws.WebSocketProtocol;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    private boolean a;
    private BufferedSource b;
    private FrameCallback c;
    private boolean d;
    private int e;
    private long f;
    private boolean g;
    private boolean h;
    private final Buffer i = new Buffer();
    private final Buffer j = new Buffer();
    private final byte[] k;
    private final Buffer.UnsafeCursor l;

    WebSocketReader(boolean bl, BufferedSource bufferedSource, FrameCallback frameCallback) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        if (frameCallback == null) {
            throw new NullPointerException("frameCallback == null");
        }
        this.a = bl;
        this.b = bufferedSource;
        this.c = frameCallback;
        this.k = bl ? null : new byte[4];
        this.l = bl ? null : new Buffer.UnsafeCursor();
    }

    final void a() throws IOException {
        this.b();
        if (this.h) {
            this.c();
            return;
        }
        WebSocketReader webSocketReader = this;
        int n2 = webSocketReader.e;
        if (n2 != 1 && n2 != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n2));
        }
        webSocketReader.e();
        if (n2 == 1) {
            webSocketReader.c.onReadMessage(webSocketReader.j.readUtf8());
            return;
        }
        webSocketReader.c.onReadMessage(webSocketReader.j.readByteString());
    }

    private void b() throws IOException {
        int n2;
        if (this.d) {
            throw new IOException("closed");
        }
        long l2 = this.b.timeout().timeoutNanos();
        this.b.timeout().clearTimeout();
        try {
            n2 = this.b.readByte() & 0xFF;
        }
        finally {
            this.b.timeout().timeout(l2, TimeUnit.NANOSECONDS);
        }
        this.e = n2 & 0xF;
        this.g = (n2 & 0x80) != 0;
        boolean bl = this.h = (n2 & 8) != 0;
        if (this.h && !this.g) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean bl2 = (n2 & 0x40) != 0;
        boolean bl3 = (n2 & 0x20) != 0;
        int n3 = n2 = (n2 & 0x10) != 0 ? 1 : 0;
        if (bl2 || bl3 || n2 != 0) {
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        n2 = this.b.readByte() & 0xFF;
        bl3 = (n2 & 0x80) != 0;
        if (bl3 == this.a) {
            throw new ProtocolException(this.a ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.f = n2 & 0x7F;
        if (this.f == 126L) {
            this.f = (long)this.b.readShort() & 0xFFFFL;
        } else if (this.f == 127L) {
            this.f = this.b.readLong();
            if (this.f < 0L) {
                throw new ProtocolException("Frame length 0x" + Long.toHexString(this.f) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.h && this.f > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (bl3) {
            this.b.readFully(this.k);
        }
    }

    private void c() throws IOException {
        if (this.f > 0L) {
            this.b.readFully(this.i, this.f);
            if (!this.a) {
                this.i.readAndWriteUnsafe(this.l);
                this.l.seek(0L);
                WebSocketProtocol.a(this.l, this.k);
                this.l.close();
            }
        }
        switch (this.e) {
            case 9: {
                this.c.onReadPing(this.i.readByteString());
                return;
            }
            case 10: {
                this.c.onReadPong(this.i.readByteString());
                return;
            }
            case 8: {
                int n2 = 1005;
                String string = "";
                long l2 = this.i.size();
                if (l2 == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (l2 != 0L) {
                    n2 = this.i.readShort();
                    string = this.i.readUtf8();
                    String string2 = WebSocketProtocol.a(n2);
                    if (string2 != null) {
                        throw new ProtocolException(string2);
                    }
                }
                this.c.onReadClose(n2, string);
                this.d = true;
                return;
            }
        }
        throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.e));
    }

    private void d() throws IOException {
        while (!this.d) {
            this.b();
            if (!this.h) break;
            this.c();
        }
    }

    private void e() throws IOException {
        block4: {
            do {
                if (this.d) {
                    throw new IOException("closed");
                }
                if (this.f > 0L) {
                    this.b.readFully(this.j, this.f);
                    if (!this.a) {
                        this.j.readAndWriteUnsafe(this.l);
                        this.l.seek(this.j.size() - this.f);
                        WebSocketProtocol.a(this.l, this.k);
                        this.l.close();
                    }
                }
                if (this.g) break block4;
                this.d();
            } while (this.e == 0);
            throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.e));
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

