/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.platform;

import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.AndroidPlatform;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.BasicTrustRootIndex;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.CertificateChainCleaner;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final Platform a;
    private static final Logger b;

    public static Platform get() {
        return a;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    protected X509TrustManager a(SSLSocketFactory sSLSocketFactory) {
        try {
            Class<?> clazz = Class.forName("sun.security.ssl.SSLContextImpl");
            sSLSocketFactory = Platform.a(sSLSocketFactory, clazz, "context");
            if (sSLSocketFactory == null) {
                return null;
            }
            return Platform.a(sSLSocketFactory, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        socket.connect(inetSocketAddress, n2);
    }

    public void log(int n2, String string, Throwable throwable) {
        Level level = n2 == 5 ? Level.WARNING : Level.INFO;
        b.log(level, string, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        return true;
    }

    public Object getStackTraceForCloseable(String string) {
        if (b.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        if (object == null) {
            string = string + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(5, string, (Throwable)object);
    }

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.a) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sSLSocketFactory) {
        X509TrustManager x509TrustManager = this.a(sSLSocketFactory);
        if (x509TrustManager == null) {
            throw new IllegalStateException("Unable to extract the trust manager on " + Platform.get() + ", sslSocketFactory is " + sSLSocketFactory.getClass());
        }
        return this.buildCertificateChainCleaner(x509TrustManager);
    }

    public static boolean isConscryptPreferred() {
        if ("conscrypt".equals(System.getProperty("okhttp.platform"))) {
            return true;
        }
        String string = Security.getProviders()[0].getName();
        return "Conscrypt".equals(string);
    }

    static <T> T a(Object object, Class<T> clazz, String string) {
        while (true) {
            Object object2;
            for (object2 = object.getClass(); object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
                try {
                    Object object3 = ((Class)object2).getDeclaredField(string);
                    ((Field)object3).setAccessible(true);
                    object3 = ((Field)object3).get(object);
                    if (object3 == null || !clazz.isInstance(object3)) {
                        return null;
                    }
                    return clazz.cast(object3);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError();
                }
            }
            if (string.equals("delegate") || (object2 = Platform.a(object, Object.class, "delegate")) == null) break;
            object = object2;
        }
        return null;
    }

    public SSLContext getSSLContext() {
        String string = System.getProperty("java.specification.version");
        if ("1.7".equals(string)) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        return new BasicTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        Platform platform = AndroidPlatform.buildIfSupported();
        a = platform != null ? platform : new Platform();
        b = Logger.getLogger(OkHttpClient.class.getName());
    }
}

