/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.OptionalMethod;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.CertificateChainCleaner;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.TrustRootIndex;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private final Class<?> a;
    private final OptionalMethod<Socket> b;
    private final OptionalMethod<Socket> c;
    private final OptionalMethod<Socket> d;
    private final OptionalMethod<Socket> e;
    private final CloseGuard f = CloseGuard.a();

    private AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.a = clazz;
        this.b = optionalMethod;
        this.c = optionalMethod2;
        this.d = optionalMethod3;
        this.e = optionalMethod4;
    }

    @Override
    public void connectSocket(Socket object, InetSocketAddress serializable, int n2) throws IOException {
        try {
            ((Socket)object).connect((SocketAddress)serializable, n2);
            return;
        }
        catch (AssertionError assertionError) {
            object = assertionError;
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)object);
            }
            throw object;
        }
        catch (SecurityException securityException) {
            serializable = new IOException("Exception in connect");
            ((Throwable)serializable).initCause(securityException);
            throw serializable;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                serializable = new IOException("Exception in connect");
                ((Throwable)serializable).initCause(classCastException);
                throw serializable;
            }
            throw classCastException;
        }
    }

    @Override
    protected final X509TrustManager a(SSLSocketFactory sSLSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.a(sSLSocketFactory, this.a, "sslParameters");
        if (object2 == null) {
            try {
                object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.a(sSLSocketFactory, object, "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.a(sSLSocketFactory);
            }
        }
        if ((object = AndroidPlatform.a(object2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.a(object2, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String objectArray, List<Protocol> object) {
        if (objectArray != null) {
            this.b.invokeOptionalWithoutCheckedException(sSLSocket, true);
            this.c.invokeOptionalWithoutCheckedException(sSLSocket, new Object[]{objectArray});
        }
        if (this.e != null && this.e.isSupported(sSLSocket)) {
            Object[] objectArray2 = new Object[1];
            objectArray = object;
            object = new Buffer();
            int n2 = objectArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Protocol protocol = (Protocol)((Object)objectArray.get(i2));
                if (protocol == Protocol.a) continue;
                ((Buffer)object).writeByte(protocol.toString().length());
                ((Buffer)object).writeUtf8(protocol.toString());
            }
            objectArray2[0] = ((Buffer)object).readByteArray();
            objectArray = objectArray2;
            this.e.invokeWithoutCheckedException(sSLSocket, objectArray);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket object) {
        if (this.d == null) {
            return null;
        }
        if (!this.d.isSupported((Socket)object)) {
            return null;
        }
        byte[] byArray = (byte[])this.d.invokeWithoutCheckedException((Socket)object, new Object[0]);
        object = byArray;
        if (byArray != null) {
            return new String((byte[])object, Util.d);
        }
        return null;
    }

    @Override
    public void log(int n2, String string, Throwable throwable) {
        int n3 = n2 = n2 == 5 ? 5 : 3;
        if (throwable != null) {
            string = string + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = string.indexOf(10, i2);
            n6 = n6 != -1 ? n6 : n4;
            do {
                n5 = Math.min(n6, i2 + 4000);
                Log.println((int)n2, (String)"OkHttp", (String)string.substring(i2, n5));
            } while ((i2 = n5) < n6);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String string) {
        return this.f.a(string);
    }

    @Override
    public void logCloseableLeak(String string, Object object) {
        boolean bl = this.f.a(object);
        if (!bl) {
            this.log(5, string, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String string) {
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Object object = clazz.getMethod("getInstance", new Class[0]);
            object = ((Method)object).invoke(null, new Object[0]);
            return this.a(string, clazz, object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw Util.assertionError("unable to determine cleartext support", exception);
        }
    }

    private boolean a(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = clazz.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)method.invoke(object, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.b(string, clazz, object);
        }
    }

    private boolean b(String string, Class<?> genericDeclaration, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            genericDeclaration = genericDeclaration.getMethod("isCleartextTrafficPermitted", new Class[0]);
            return (Boolean)((Method)genericDeclaration).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string);
        }
    }

    private static boolean a() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            GenericDeclaration genericDeclaration = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = genericDeclaration.getConstructor(X509TrustManager.class);
            constructor = constructor.newInstance(x509TrustManager);
            genericDeclaration = genericDeclaration.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(constructor, (Method)genericDeclaration);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod<Socket> optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            if (AndroidPlatform.a()) {
                optionalMethod3 = new OptionalMethod<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                optionalMethod4 = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            return new AndroidPlatform(clazz, optionalMethod, optionalMethod2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Method method = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            method.setAccessible(true);
            return new AndroidTrustRootIndex(x509TrustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    @Override
    public SSLContext getSSLContext() {
        boolean bl;
        try {
            bl = Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = true;
        }
        if (bl) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager a;
        private final Method b;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.b = method;
            this.a = x509TrustManager;
        }

        @Override
        public final X509Certificate findByIssuerAndSignature(X509Certificate object) {
            try {
                object = (TrustAnchor)this.b.invoke((Object)this.a, object);
                if (object != null) {
                    return ((TrustAnchor)object).getTrustedCert();
                }
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.assertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            object = (AndroidTrustRootIndex)object;
            return this.a.equals(((AndroidTrustRootIndex)object).a) && this.b.equals(((AndroidTrustRootIndex)object).b);
        }

        public final int hashCode() {
            return this.a.hashCode() + 31 * this.b.hashCode();
        }
    }

    static final class CloseGuard {
        private final Method a;
        private final Method b;
        private final Method c;

        private CloseGuard(Method method, Method method2, Method method3) {
            this.a = method;
            this.b = method2;
            this.c = method3;
        }

        final Object a(String string) {
            if (this.a != null) {
                try {
                    Object object = this.a.invoke(null, new Object[0]);
                    this.b.invoke(object, string);
                    return object;
                }
                catch (Exception exception) {}
            }
            return null;
        }

        final boolean a(Object object) {
            boolean bl = false;
            if (object != null) {
                try {
                    this.c.invoke(object, new Object[0]);
                    bl = true;
                }
                catch (Exception exception) {}
            }
            return bl;
        }

        static CloseGuard a() {
            Method method;
            Method method2;
            GenericDeclaration genericDeclaration;
            try {
                genericDeclaration = Class.forName("dalvik.system.CloseGuard");
                method2 = genericDeclaration.getMethod("get", new Class[0]);
                method = genericDeclaration.getMethod("open", String.class);
                genericDeclaration = genericDeclaration.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception exception) {
                method2 = null;
                method = null;
                genericDeclaration = null;
            }
            return new CloseGuard(method2, method, (Method)genericDeclaration);
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object a;
        private final Method b;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.a = object;
            this.b = method;
        }

        @Override
        public final List<Certificate> clean(List<Certificate> x509CertificateArray, String object) throws SSLPeerUnverifiedException {
            try {
                x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[x509CertificateArray.size()]);
                return (List)this.b.invoke(this.a, x509CertificateArray, "RSA", object);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                ((Throwable)object).initCause(invocationTargetException);
                throw object;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public final boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public final int hashCode() {
            return 0;
        }
    }
}

