/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http2;

import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Hpack;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Settings;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Writer
implements Closeable {
    private static final Logger a = Logger.getLogger(Http2.class.getName());
    private final BufferedSink b;
    private final boolean c;
    private final Buffer d;
    private int e;
    private boolean f;
    private Hpack.Writer g;

    Http2Writer(BufferedSink bufferedSink, boolean bl) {
        this.b = bufferedSink;
        this.c = bl;
        this.d = new Buffer();
        this.g = new Hpack.Writer(this.d);
        this.e = 16384;
    }

    public final synchronized void connectionPreface() throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        if (!this.c) {
            return;
        }
        if (a.isLoggable(Level.FINE)) {
            a.fine(Util.format(">> CONNECTION %s", Http2.a.hex()));
        }
        this.b.write(Http2.a.toByteArray());
        this.b.flush();
    }

    public final synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.e = settings.d(this.e);
        if (settings.c() != -1) {
            this.g.a(settings.c());
        }
        this.frameHeader(0, 0, (byte)4, (byte)1);
        this.b.flush();
    }

    public final synchronized void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.g.a(list);
        long l2 = this.d.size();
        int n4 = (int)Math.min((long)(this.e - 4), l2);
        byte by = l2 == (long)n4 ? (byte)4 : 0;
        this.frameHeader(n2, n4 + 4, (byte)5, by);
        this.b.writeInt(n3 & Integer.MAX_VALUE);
        this.b.write(this.d, (long)n4);
        if (l2 > (long)n4) {
            this.a(n2, l2 - (long)n4);
        }
    }

    public final synchronized void flush() throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.b.flush();
    }

    public final synchronized void synStream(boolean bl, int n2, int n3, List<Header> list) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.a(bl, n2, list);
    }

    public final synchronized void synReply(boolean bl, int n2, List<Header> list) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.a(bl, n2, list);
    }

    public final synchronized void headers(int n2, List<Header> list) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        this.a(false, n2, list);
    }

    public final synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        if (errorCode.g == -1) {
            throw new IllegalArgumentException();
        }
        this.frameHeader(n2, 4, (byte)3, (byte)0);
        this.b.writeInt(errorCode.g);
        this.b.flush();
    }

    public final int maxDataLength() {
        return this.e;
    }

    public final synchronized void data(boolean bl, int n2, Buffer buffer, int n3) throws IOException {
        byte by;
        if (this.f) {
            throw new IOException("closed");
        }
        boolean by2 = false;
        if (bl) {
            by = 1;
        }
        int n4 = n3;
        Buffer buffer2 = buffer;
        byte by3 = by;
        Http2Writer http2Writer = this;
        http2Writer.frameHeader(n2, n4, (byte)0, by3);
        if (n4 > 0) {
            http2Writer.b.write(buffer2, (long)n4);
        }
    }

    public final synchronized void settings(Settings settings) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        int n2 = settings.b() * 6;
        this.frameHeader(0, n2, (byte)4, (byte)0);
        for (n2 = 0; n2 < 10; ++n2) {
            if (!settings.a(n2)) continue;
            int n3 = n2;
            if (n3 == 4) {
                n3 = 3;
            } else if (n3 == 7) {
                n3 = 4;
            }
            this.b.writeShort(n3);
            this.b.writeInt(settings.b(n2));
        }
        this.b.flush();
    }

    public final synchronized void ping(boolean bl, int n2, int n3) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        bl = bl;
        this.frameHeader(0, 8, (byte)6, (byte)(bl ? 1 : 0));
        this.b.writeInt(n2);
        this.b.writeInt(n3);
        this.b.flush();
    }

    public final synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        if (errorCode.g == -1) {
            throw Http2.a("errorCode.httpCode == -1", new Object[0]);
        }
        int n3 = 8 + byArray.length;
        this.frameHeader(0, n3, (byte)7, (byte)0);
        this.b.writeInt(n2);
        this.b.writeInt(errorCode.g);
        if (byArray.length > 0) {
            this.b.write(byArray);
        }
        this.b.flush();
    }

    public final synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (this.f) {
            throw new IOException("closed");
        }
        if (l2 == 0L || l2 > Integer.MAX_VALUE) {
            throw Http2.a("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", l2);
        }
        this.frameHeader(n2, 4, (byte)8, (byte)0);
        this.b.writeInt((int)l2);
        this.b.flush();
    }

    public final void frameHeader(int n2, int n3, byte by, byte by2) throws IOException {
        if (a.isLoggable(Level.FINE)) {
            a.fine(Http2.a(false, n2, n3, by, by2));
        }
        if (n3 > this.e) {
            throw Http2.a("FRAME_SIZE_ERROR length > %d: %d", this.e, n3);
        }
        if ((n2 & Integer.MIN_VALUE) != 0) {
            throw Http2.a("reserved bit set: %s", n2);
        }
        int n4 = n3;
        BufferedSink bufferedSink = this.b;
        bufferedSink.writeByte(n4 >>> 16 & 0xFF);
        bufferedSink.writeByte(n4 >>> 8 & 0xFF);
        bufferedSink.writeByte(n4 & 0xFF);
        this.b.writeByte(by & 0xFF);
        this.b.writeByte(by2 & 0xFF);
        this.b.writeInt(n2 & Integer.MAX_VALUE);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.f = true;
        this.b.close();
    }

    private void a(int n2, long l2) throws IOException {
        while (l2 > 0L) {
            int n3;
            this.frameHeader(n2, n3, (byte)9, (l2 -= (long)(n3 = (int)Math.min((long)this.e, l2))) == 0L ? (byte)4 : 0);
            this.b.write(this.d, (long)n3);
        }
    }

    private void a(boolean bl, int n2, List<Header> list) throws IOException {
        byte by;
        if (this.f) {
            throw new IOException("closed");
        }
        this.g.a(list);
        long l2 = this.d.size();
        int n3 = (int)Math.min((long)this.e, l2);
        byte by2 = by = l2 == (long)n3 ? (byte)4 : 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        this.frameHeader(n2, n3, (byte)1, by);
        this.b.write(this.d, (long)n3);
        if (l2 > (long)n3) {
            this.a(n2, l2 - (long)n3);
        }
    }
}

