/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http2;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Connection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.StreamResetException;
import com.tencent.cloud.huiyansdkface.okio.AsyncTimeout;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class Http2Stream {
    long a = 0L;
    long b;
    final int c;
    final Http2Connection d;
    private final Deque<Headers> i = new ArrayDeque<Headers>();
    private Header.Listener j;
    private boolean k;
    private final FramingSource l;
    final FramingSink e;
    final StreamTimeout f = new StreamTimeout(this);
    final StreamTimeout g = new StreamTimeout(this);
    ErrorCode h = null;

    Http2Stream(int n2, Http2Connection http2Connection, boolean bl, boolean bl2, Headers headers) {
        if (http2Connection == null) {
            throw new NullPointerException("connection == null");
        }
        this.c = n2;
        this.d = http2Connection;
        this.b = http2Connection.k.d();
        this.l = new FramingSource(this, http2Connection.j.d());
        this.e = new FramingSink(this);
        this.l.b = bl2;
        this.e.b = bl;
        if (headers != null) {
            this.i.add(headers);
        }
        if (this.isLocallyInitiated() && headers != null) {
            throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
        }
        if (!this.isLocallyInitiated() && headers == null) {
            throw new IllegalStateException("remotely-initiated streams should have headers");
        }
    }

    public final int getId() {
        return this.c;
    }

    public final synchronized boolean isOpen() {
        if (this.h != null) {
            return false;
        }
        return !this.l.b && !this.l.a || !this.e.b && !this.e.a || !this.k;
    }

    public final boolean isLocallyInitiated() {
        boolean bl;
        boolean bl2 = bl = (this.c & 1) == 1;
        return this.d.a == bl;
    }

    public final Http2Connection getConnection() {
        return this.d;
    }

    public final synchronized Headers takeHeaders() throws IOException {
        this.f.enter();
        try {
            while (this.i.isEmpty() && this.h == null) {
                this.d();
            }
        }
        finally {
            this.f.exitAndThrowIfTimedOut();
        }
        if (!this.i.isEmpty()) {
            return this.i.removeFirst();
        }
        throw new StreamResetException(this.h);
    }

    public final synchronized ErrorCode getErrorCode() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeHeaders(List<Header> object, boolean bl) throws IOException {
        assert (!Thread.holdsLock(this));
        if (object == null) {
            throw new NullPointerException("headers == null");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Object object2 = this;
        synchronized (object2) {
            this.k = true;
            if (!bl) {
                this.e.b = true;
                bl3 = true;
                bl2 = true;
            }
        }
        if (!bl3) {
            object2 = this.d;
            synchronized (object2) {
                bl3 = this.d.i == 0L;
            }
        }
        object2 = object;
        int n2 = this.c;
        object = this.d;
        ((Http2Connection)object).m.synReply(bl2, n2, (List<Header>)object2);
        if (bl3) {
            this.d.flush();
        }
    }

    public final Timeout readTimeout() {
        return this.f;
    }

    public final Timeout writeTimeout() {
        return this.g;
    }

    public final Source getSource() {
        return this.l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!this.k && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.e;
    }

    public final void close(ErrorCode errorCode) throws IOException {
        if (!this.b(errorCode)) {
            return;
        }
        this.d.b(this.c, errorCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        if (!this.b(errorCode)) {
            return;
        }
        this.d.a(this.c, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.h != null) {
                return false;
            }
            if (this.l.b && this.e.b) {
                return false;
            }
            this.h = errorCode;
            this.notifyAll();
        }
        this.d.b(this.c);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(List<Header> list) {
        boolean bl;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.k = true;
            this.i.add(Util.toHeaders(list));
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.d.b(this.c);
        }
    }

    final void a(BufferedSource bufferedSource, int n2) throws IOException {
        assert (!Thread.holdsLock(this));
        this.l.a(bufferedSource, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a() {
        boolean bl;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.l.b = true;
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.d.b(this.c);
        }
    }

    final synchronized void a(ErrorCode errorCode) {
        if (this.h == null) {
            this.h = errorCode;
            this.notifyAll();
        }
    }

    public final synchronized void setHeadersListener(Header.Listener listener) {
        this.j = listener;
        if (!this.i.isEmpty() && listener != null) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void b() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            bl2 = !this.l.b && this.l.a && (this.e.b || this.e.a);
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.f);
            return;
        }
        if (!bl) {
            this.d.b(this.c);
        }
    }

    final void a(long l2) {
        this.b += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    final void c() throws IOException {
        if (this.e.a) {
            throw new IOException("stream closed");
        }
        if (this.e.b) {
            throw new IOException("stream finished");
        }
        if (this.h != null) {
            throw new StreamResetException(this.h);
        }
    }

    final void d() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        private /* synthetic */ Http2Stream a;

        StreamTimeout(Http2Stream http2Stream) {
            this.a = http2Stream;
        }

        @Override
        protected void timedOut() {
            this.a.closeLater(ErrorCode.f);
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }

    final class FramingSink
    implements Sink {
        private final Buffer c = new Buffer();
        boolean a;
        boolean b;
        private /* synthetic */ Http2Stream e;

        FramingSink(Http2Stream http2Stream) {
            this.e = http2Stream;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            assert (!Thread.holdsLock(this.e));
            this.c.write(buffer, l2);
            while (this.c.size() >= 16384L) {
                this.a(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(boolean bl) throws IOException {
            long l2;
            Http2Stream http2Stream = this.e;
            synchronized (http2Stream) {
                this.e.g.enter();
                try {
                    while (this.e.b <= 0L && !this.b && !this.a && this.e.h == null) {
                        this.e.d();
                    }
                }
                finally {
                    this.e.g.exitAndThrowIfTimedOut();
                }
                this.e.c();
                l2 = Math.min(this.e.b, this.c.size());
                this.e.b -= l2;
            }
            this.e.g.enter();
            try {
                this.e.d.writeData(this.e.c, bl && l2 == this.c.size(), this.c, l2);
                return;
            }
            finally {
                this.e.g.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void flush() throws IOException {
            assert (!Thread.holdsLock(this.e));
            Http2Stream http2Stream = this.e;
            synchronized (http2Stream) {
                this.e.c();
            }
            while (this.c.size() > 0L) {
                this.a(false);
                this.e.d.flush();
            }
        }

        @Override
        public final Timeout timeout() {
            return this.e.g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            assert (!Thread.holdsLock(this.e));
            Http2Stream http2Stream = this.e;
            synchronized (http2Stream) {
                if (this.a) {
                    return;
                }
            }
            if (!this.e.e.b) {
                if (this.c.size() > 0L) {
                    while (this.c.size() > 0L) {
                        this.a(true);
                    }
                } else {
                    this.e.d.writeData(this.e.c, true, null, 0L);
                }
            }
            http2Stream = this.e;
            synchronized (http2Stream) {
                this.a = true;
            }
            this.e.d.flush();
            this.e.b();
        }
    }

    final class FramingSource
    implements Source {
        private final Buffer c = new Buffer();
        private final Buffer d = new Buffer();
        private final long e;
        boolean a;
        boolean b;
        private /* synthetic */ Http2Stream g;

        FramingSource(Http2Stream http2Stream, long l2) {
            this.g = http2Stream;
            this.e = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long read(Buffer buffer, long l2) throws IOException {
            ErrorCode errorCode;
            long l3;
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            while (true) {
                Headers headers = null;
                Header.Listener listener = null;
                l3 = -1L;
                errorCode = null;
                Http2Stream http2Stream = this.g;
                synchronized (http2Stream) {
                    this.g.f.enter();
                    try {
                        if (this.g.h != null) {
                            errorCode = this.g.h;
                        }
                        if (this.a) {
                            throw new IOException("stream closed");
                        }
                        if (!this.g.i.isEmpty() && this.g.j != null) {
                            headers = (Headers)this.g.i.removeFirst();
                            listener = this.g.j;
                        } else if (this.d.size() > 0L) {
                            l3 = this.d.read(buffer, Math.min(l2, this.d.size()));
                            this.g.a += l3;
                            if (errorCode == null && this.g.a >= (long)(this.g.d.j.d() / 2)) {
                                this.g.d.a(this.g.c, this.g.a);
                                this.g.a = 0L;
                            }
                        } else if (!this.b && errorCode == null) {
                            this.g.d();
                            continue;
                        }
                    }
                    finally {
                        this.g.f.exitAndThrowIfTimedOut();
                    }
                }
                if (headers == null || listener == null) break;
                listener.onHeaders(headers);
            }
            if (l3 != -1L) {
                this.a(l3);
                return l3;
            }
            if (errorCode != null) {
                throw new StreamResetException(errorCode);
            }
            return -1L;
        }

        private void a(long l2) {
            assert (!Thread.holdsLock(this.g));
            this.g.d.a(l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void a(BufferedSource bufferedSource, long l2) throws IOException {
            assert (!Thread.holdsLock(this.g));
            while (l2 > 0L) {
                boolean bl;
                boolean bl2;
                Http2Stream http2Stream = this.g;
                synchronized (http2Stream) {
                    bl2 = this.b;
                    bl = l2 + this.d.size() > this.e;
                }
                if (bl) {
                    bufferedSource.skip(l2);
                    this.g.closeLater(ErrorCode.d);
                    return;
                }
                if (bl2) {
                    bufferedSource.skip(l2);
                    return;
                }
                long l3 = bufferedSource.read(this.c, l2);
                if (l3 == -1L) {
                    throw new EOFException();
                }
                l2 -= l3;
                Http2Stream http2Stream2 = this.g;
                synchronized (http2Stream2) {
                    bl = this.d.size() == 0L;
                    this.d.writeAll(this.c);
                    if (bl) {
                        this.g.notifyAll();
                    }
                }
            }
        }

        @Override
        public final Timeout timeout() {
            return this.g.f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            long l2;
            ArrayList arrayList = null;
            Header.Listener listener = null;
            Http2Stream http2Stream = this.g;
            synchronized (http2Stream) {
                this.a = true;
                l2 = this.d.size();
                this.d.clear();
                if (!this.g.i.isEmpty() && this.g.j != null) {
                    arrayList = new ArrayList(this.g.i);
                    this.g.i.clear();
                    listener = this.g.j;
                }
                this.g.notifyAll();
            }
            if (l2 > 0L) {
                this.a(l2);
            }
            this.g.b();
            if (listener != null) {
                for (Headers headers : arrayList) {
                    listener.onHeaders(headers);
                }
            }
        }
    }
}

