/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http2;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.NamedRunnable;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ConnectionShutdownException;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ErrorCode;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Reader;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Stream;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Http2Writer;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.PushObserver;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Settings;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    private static final ExecutorService o = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    final boolean a;
    final Listener b;
    final Map<Integer, Http2Stream> c = new LinkedHashMap<Integer, Http2Stream>();
    final String d;
    int e;
    int f;
    boolean g;
    private final ScheduledExecutorService p;
    private final ExecutorService q;
    final PushObserver h;
    private boolean r;
    private long s = 0L;
    long i;
    Settings j = new Settings();
    final Settings k = new Settings();
    boolean l = false;
    private Socket t;
    final Http2Writer m;
    private ReaderRunnable u;
    final Set<Integer> n = new LinkedHashSet<Integer>();

    Http2Connection(Builder builder) {
        this.h = builder.f;
        this.a = builder.g;
        this.b = builder.e;
        int n2 = this.f = builder.g ? 1 : 2;
        if (builder.g) {
            this.f += 2;
        }
        if (builder.g) {
            this.j.a(7, 0x1000000);
        }
        this.d = builder.b;
        this.p = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", this.d), false));
        if (builder.h != 0) {
            this.p.scheduleAtFixedRate(new PingRunnable(this, false, 0, 0), builder.h, builder.h, TimeUnit.MILLISECONDS);
        }
        this.q = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.d), true));
        this.k.a(7, 65535);
        this.k.a(5, 16384);
        this.i = this.k.d();
        this.t = builder.a;
        this.m = new Http2Writer(builder.d, this.a);
        this.u = new ReaderRunnable(new Http2Reader(builder.c, this.a));
    }

    public final Protocol getProtocol() {
        return Protocol.d;
    }

    public final synchronized int openStreamCount() {
        return this.c.size();
    }

    final synchronized Http2Stream a(int n2) {
        return this.c.get(n2);
    }

    final synchronized Http2Stream b(int n2) {
        Http2Stream http2Stream = this.c.remove(n2);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized int maxConcurrentStreams() {
        return this.k.c(Integer.MAX_VALUE);
    }

    final synchronized void a(long l2) {
        this.s += l2;
        if (this.s >= (long)(this.j.d() / 2)) {
            this.a(0, this.s);
            this.s = 0L;
        }
    }

    public final Http2Stream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (this.a) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        return this.b(n2, list, bl);
    }

    public final Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.b(0, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream b(int n2, List<Header> list, boolean bl) throws IOException {
        Http2Stream http2Stream;
        boolean bl2 = !bl;
        Http2Writer http2Writer = this.m;
        synchronized (http2Writer) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.f > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.e);
                }
                if (this.g) {
                    throw new ConnectionShutdownException();
                }
                n3 = this.f;
                this.f += 2;
                http2Stream = new Http2Stream(n3, this, bl2, false, null);
                boolean bl3 = bl = !bl || this.i == 0L || http2Stream.b == 0L;
                if (http2Stream.isOpen()) {
                    this.c.put(n3, http2Stream);
                }
            }
            if (n2 == 0) {
                this.m.synStream(bl2, n3, n2, list);
            } else {
                if (this.a) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.m.pushPromise(n2, n3, list);
            }
        }
        if (bl) {
            this.m.flush();
        }
        return http2Stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int n2, boolean bl, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.m.data(bl, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.i <= 0L) {
                        if (!this.c.containsKey(n2)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                n3 = (int)Math.min(l2, this.i);
                n3 = Math.min(n3, this.m.maxDataLength());
                this.i -= (long)n3;
            }
            this.m.data(bl && (l2 -= (long)n3) == 0L, n2, buffer, n3);
        }
    }

    final void a(int n2, ErrorCode errorCode) {
        try {
            this.p.execute(new NamedRunnable(this, "OkHttp %s stream %d", new Object[]{this.d, n2}, n2, errorCode){
                private /* synthetic */ int a;
                private /* synthetic */ ErrorCode b;
                private /* synthetic */ Http2Connection c;
                {
                    this.c = http2Connection;
                    this.a = n2;
                    this.b = errorCode;
                    super(string, objectArray);
                }

                @Override
                public void execute() {
                    try {
                        this.c.b(this.a, this.b);
                        return;
                    }
                    catch (IOException iOException) {
                        this.c.b();
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void b(int n2, ErrorCode errorCode) throws IOException {
        this.m.rstStream(n2, errorCode);
    }

    final void a(int n2, long l2) {
        try {
            this.p.execute(new NamedRunnable(this, "OkHttp Window Update %s stream %d", new Object[]{this.d, n2}, n2, l2){
                private /* synthetic */ int a;
                private /* synthetic */ long b;
                private /* synthetic */ Http2Connection c;
                {
                    this.c = http2Connection;
                    this.a = n2;
                    this.b = l2;
                    super(string, objectArray);
                }

                @Override
                public void execute() {
                    try {
                        this.c.m.windowUpdate(this.a, this.b);
                        return;
                    }
                    catch (IOException iOException) {
                        this.c.b();
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(boolean bl, int n2, int n3) {
        if (!bl) {
            boolean bl2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                bl2 = this.r;
                this.r = true;
            }
            if (bl2) {
                this.b();
                return;
            }
        }
        try {
            this.m.ping(bl, n2, n3);
            return;
        }
        catch (IOException iOException) {
            this.b();
            return;
        }
    }

    public final void flush() throws IOException {
        this.m.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.m;
        synchronized (http2Writer) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.g) {
                    return;
                }
                this.g = true;
                n2 = this.e;
            }
            this.m.goAway(n2, errorCode, Util.a);
            return;
        }
    }

    @Override
    public final void close() throws IOException {
        this.a(ErrorCode.a, ErrorCode.f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(ErrorCode http2StreamArray, ErrorCode errorCode) throws IOException {
        IOException iOException;
        block16: {
            assert (!Thread.holdsLock(this));
            iOException = null;
            try {
                this.shutdown((ErrorCode)((Object)http2StreamArray));
            }
            catch (IOException iOException2) {
                http2StreamArray = iOException2;
                iOException = iOException2;
            }
            http2StreamArray = null;
            Http2Connection object = this;
            synchronized (object) {
                if (!this.c.isEmpty()) {
                    http2StreamArray = this.c.values().toArray(new Http2Stream[this.c.size()]);
                    this.c.clear();
                }
            }
            if (http2StreamArray != null) {
                Object iOException4 = http2StreamArray;
                int n2 = ((Http2Stream[])http2StreamArray).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Http2Stream http2Stream = iOException4[i2];
                    try {
                        http2Stream.close(errorCode);
                        continue;
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) continue;
                        iOException = iOException3;
                    }
                }
            }
            try {
                this.m.close();
            }
            catch (IOException iOException4) {
                if (iOException != null) break block16;
                iOException = iOException4;
            }
        }
        try {
            this.t.close();
        }
        catch (IOException iOException5) {
            IOException iOException6 = iOException5;
            iOException = iOException5;
        }
        this.p.shutdown();
        this.q.shutdown();
        if (iOException != null) {
            throw iOException;
        }
    }

    private void b() {
        try {
            this.a(ErrorCode.b, ErrorCode.b);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void start() throws IOException {
        boolean bl = true;
        Http2Connection http2Connection = this;
        http2Connection.m.connectionPreface();
        http2Connection.m.settings(http2Connection.j);
        int n2 = http2Connection.j.d();
        if (n2 != 65535) {
            http2Connection.m.windowUpdate(0, n2 - 65535);
        }
        new Thread(http2Connection.u).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.m;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.g) {
                    throw new ConnectionShutdownException();
                }
                this.j.a(settings);
            }
            this.m.settings(settings);
            return;
        }
    }

    public final synchronized boolean isShutdown() {
        return this.g;
    }

    static boolean c(int n2) {
        return n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(int n2, List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.n.contains(n2)) {
                this.a(n2, ErrorCode.b);
                return;
            }
            this.n.add(n2);
        }
        try {
            this.a(new NamedRunnable(this, "OkHttp %s Push Request[%s]", new Object[]{this.d, n2}, n2, list){
                private /* synthetic */ int a;
                private /* synthetic */ List b;
                private /* synthetic */ Http2Connection c;
                {
                    this.c = http2Connection;
                    this.a = n2;
                    this.b = list;
                    super(string, objectArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block6: {
                        boolean bl = this.c.h.onRequest(this.a, this.b);
                        try {
                            if (bl) {
                                this.c.m.rstStream(this.a, ErrorCode.f);
                                Http2Connection http2Connection = this.c;
                                synchronized (http2Connection) {
                                    this.c.n.remove(this.a);
                                    break block6;
                                }
                            }
                            return;
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void a(int n2, List<Header> list, boolean bl) {
        try {
            this.a(new NamedRunnable(this, "OkHttp %s Push Headers[%s]", new Object[]{this.d, n2}, n2, list, bl){
                private /* synthetic */ int a;
                private /* synthetic */ List b;
                private /* synthetic */ boolean c;
                private /* synthetic */ Http2Connection d;
                {
                    this.d = http2Connection;
                    this.a = n2;
                    this.b = list;
                    this.c = bl;
                    super(string, objectArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block7: {
                        boolean bl = this.d.h.onHeaders(this.a, this.b, this.c);
                        try {
                            if (bl) {
                                this.d.m.rstStream(this.a, ErrorCode.f);
                            }
                            if (bl || this.c) {
                                Http2Connection http2Connection = this.d;
                                synchronized (http2Connection) {
                                    this.d.n.remove(this.a);
                                    break block7;
                                }
                            }
                            return;
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void a(int n2, BufferedSource bufferedSource, int n3, boolean bl) throws IOException {
        Buffer buffer = new Buffer();
        bufferedSource.require(n3);
        bufferedSource.read(buffer, n3);
        if (buffer.size() != (long)n3) {
            throw new IOException(buffer.size() + " != " + n3);
        }
        this.a(new NamedRunnable(this, "OkHttp %s Push Data[%s]", new Object[]{this.d, n2}, n2, buffer, n3, bl){
            private /* synthetic */ int a;
            private /* synthetic */ Buffer b;
            private /* synthetic */ int c;
            private /* synthetic */ boolean d;
            private /* synthetic */ Http2Connection e;
            {
                this.e = http2Connection;
                this.a = n2;
                this.b = buffer;
                this.c = n3;
                this.d = bl;
                super(string, objectArray);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block7: {
                    try {
                        boolean bl = this.e.h.onData(this.a, this.b, this.c, this.d);
                        if (bl) {
                            this.e.m.rstStream(this.a, ErrorCode.f);
                        }
                        if (bl || this.d) {
                            Http2Connection http2Connection = this.e;
                            synchronized (http2Connection) {
                                this.e.n.remove(this.a);
                                break block7;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    final void c(int n2, ErrorCode errorCode) {
        this.a(new NamedRunnable(this, "OkHttp %s Push Reset[%s]", new Object[]{this.d, n2}, n2, errorCode){
            private /* synthetic */ int a;
            private /* synthetic */ ErrorCode b;
            private /* synthetic */ Http2Connection c;
            {
                this.c = http2Connection;
                this.a = n2;
                this.b = errorCode;
                super(string, objectArray);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                this.c.h.onReset(this.a, this.b);
                Http2Connection http2Connection = this.c;
                synchronized (http2Connection) {
                    this.c.n.remove(this.a);
                    return;
                }
            }
        });
    }

    private synchronized void a(NamedRunnable namedRunnable) {
        if (!this.isShutdown()) {
            this.q.execute(namedRunnable);
        }
    }

    static /* synthetic */ boolean a(Http2Connection http2Connection, boolean bl) {
        http2Connection.r = false;
        return false;
    }

    public static abstract class Listener {
        public static final Listener e = new Listener(){

            @Override
            public final void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.e);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        private Http2Reader b;

        ReaderRunnable(Http2Reader http2Reader) {
            super("OkHttp %s", Http2Connection.this.d);
            this.b = http2Reader;
        }

        /*
         * Loose catch block
         */
        @Override
        protected void execute() {
            ErrorCode errorCode = ErrorCode.c;
            ErrorCode errorCode2 = ErrorCode.c;
            this.b.readConnectionPreface(this);
            while (this.b.nextFrame(false, this)) {
            }
            errorCode = ErrorCode.a;
            errorCode2 = ErrorCode.f;
            try {
                Http2Connection.this.a(errorCode, errorCode2);
            }
            catch (IOException iOException) {}
            Util.closeQuietly(this.b);
            return;
            catch (IOException iOException) {
                try {
                    errorCode = ErrorCode.b;
                    errorCode2 = ErrorCode.b;
                }
                catch (Throwable throwable) {
                    try {
                        Http2Connection.this.a(errorCode, errorCode2);
                    }
                    catch (IOException iOException2) {}
                    Util.closeQuietly(this.b);
                    throw throwable;
                }
                try {
                    Http2Connection.this.a(errorCode, errorCode2);
                }
                catch (IOException iOException3) {}
                Util.closeQuietly(this.b);
                return;
            }
        }

        @Override
        public void data(boolean bl, int n2, BufferedSource bufferedSource, int n3) throws IOException {
            if (Http2Connection.c(n2)) {
                Http2Connection.this.a(n2, bufferedSource, n3, bl);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.a(n2);
            if (http2Stream == null) {
                Http2Connection.this.a(n2, ErrorCode.b);
                Http2Connection.this.a((long)n3);
                bufferedSource.skip(n3);
                return;
            }
            http2Stream.a(bufferedSource, n3);
            if (bl) {
                http2Stream.a();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl, int n2, int n3, List<Header> list) {
            Object object;
            if (Http2Connection.c(n2)) {
                Http2Connection.this.a(n2, list, bl);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                object = Http2Connection.this.a(n2);
                if (object == null) {
                    if (Http2Connection.this.g) {
                        return;
                    }
                    if (n2 <= Http2Connection.this.e) {
                        return;
                    }
                    if (n2 % 2 == Http2Connection.this.f % 2) {
                        return;
                    }
                    object = Util.toHeaders(list);
                    Http2Stream http2Stream = new Http2Stream(n2, Http2Connection.this, false, bl, (Headers)object);
                    Http2Connection.this.e = n2;
                    Http2Connection.this.c.put(n2, http2Stream);
                    o.execute(new NamedRunnable(this, "OkHttp %s stream %d", new Object[]{Http2Connection.this.d, n2}, http2Stream){
                        private /* synthetic */ Http2Stream a;
                        private /* synthetic */ ReaderRunnable b;
                        {
                            this.b = readerRunnable;
                            this.a = http2Stream;
                            super(string, objectArray);
                        }

                        @Override
                        public void execute() {
                            try {
                                this.b.Http2Connection.this.b.onStream(this.a);
                                return;
                            }
                            catch (IOException iOException) {
                                Platform.get().log(4, "Http2Connection.Listener failure for " + this.b.Http2Connection.this.d, iOException);
                                try {
                                    this.a.close(ErrorCode.b);
                                    return;
                                }
                                catch (IOException iOException2) {
                                    return;
                                }
                            }
                        }
                    });
                    return;
                }
            }
            ((Http2Stream)object).a(list);
            if (bl) {
                ((Http2Stream)object).a();
            }
        }

        @Override
        public void rstStream(int n2, ErrorCode errorCode) {
            if (Http2Connection.c(n2)) {
                Http2Connection.this.c(n2, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.b(n2);
            if (http2Stream != null) {
                http2Stream.a(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void settings(boolean bl, Settings object) {
            Http2Connection http2Connection;
            long l2 = 0L;
            Object object2 = null;
            Http2Connection http2Connection2 = Http2Connection.this;
            // MONITORENTER : http2Connection2
            int n2 = Http2Connection.this.k.d();
            if (bl) {
                Http2Connection.this.k.a();
            }
            Http2Connection.this.k.a((Settings)((Object)http2Connection));
            ReaderRunnable readerRunnable = this;
            try {
                readerRunnable.Http2Connection.this.p.execute(new NamedRunnable(readerRunnable, "OkHttp %s ACK Settings", new Object[]{readerRunnable.Http2Connection.this.d}, (Settings)((Object)http2Connection)){
                    private /* synthetic */ Settings a;
                    private /* synthetic */ ReaderRunnable b;
                    {
                        this.b = readerRunnable;
                        this.a = settings;
                        super(string, objectArray);
                    }

                    @Override
                    public void execute() {
                        try {
                            this.b.Http2Connection.this.m.applyAndAckSettings(this.a);
                            return;
                        }
                        catch (IOException iOException) {
                            this.b.Http2Connection.this.b();
                            return;
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
            int n3 = Http2Connection.this.k.d();
            if (n3 != -1 && n3 != n2) {
                l2 = n3 - n2;
                if (!Http2Connection.this.l) {
                    Http2Connection.this.l = true;
                }
                if (!Http2Connection.this.c.isEmpty()) {
                    object2 = Http2Connection.this.c.values().toArray(new Http2Stream[Http2Connection.this.c.size()]);
                }
            }
            o.execute(new NamedRunnable(this, "OkHttp %s settings", new Object[]{Http2Connection.this.d}){
                private /* synthetic */ ReaderRunnable a;
                {
                    this.a = readerRunnable;
                    super(string, objectArray);
                }

                @Override
                public void execute() {
                    this.a.Http2Connection.this.b.onSettings(this.a.Http2Connection.this);
                }
            });
            // MONITOREXIT : http2Connection2
            if (object2 == null) return;
            if (l2 == 0L) return;
            http2Connection2 = object2;
            n2 = (object2).length;
            n3 = 0;
            while (n3 < n2) {
                http2Connection = http2Connection2[n3];
                object2 = http2Connection;
                // MONITORENTER : http2Connection
                ((Http2Stream)((Object)http2Connection)).a(l2);
                // MONITOREXIT : object2
                ++n3;
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean bl, int n2, int n3) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.a(Http2Connection.this, false);
                    Http2Connection.this.notifyAll();
                }
            } else {
                try {
                    Http2Connection.this.p.execute(new PingRunnable(Http2Connection.this, true, n2, n3));
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n2, ErrorCode http2StreamArray, ByteString http2StreamArray2) {
            http2StreamArray2.size();
            http2StreamArray2 = Http2Connection.this;
            synchronized (http2StreamArray2) {
                http2StreamArray = Http2Connection.this.c.values().toArray(new Http2Stream[Http2Connection.this.c.size()]);
                Http2Connection.this.g = true;
            }
            http2StreamArray2 = http2StreamArray;
            int n3 = http2StreamArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Http2Stream http2Stream = http2StreamArray2[i2];
                if (http2Stream.getId() <= n2 || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.a(ErrorCode.e);
                Http2Connection.this.b(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.i += l2;
                    Http2Connection.this.notifyAll();
                }
            } else {
                Http2Stream http2Stream = Http2Connection.this.a(n2);
                if (http2Stream != null) {
                    Http2Stream http2Stream2 = http2Stream;
                    synchronized (http2Stream2) {
                        http2Stream.a(l2);
                        return;
                    }
                }
            }
        }

        @Override
        public void priority(int n2, int n3, int n4, boolean bl) {
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) {
            Http2Connection.this.a(n3, list);
        }

        @Override
        public void alternateService(int n2, String string, ByteString byteString, String string2, int n3, long l2) {
        }
    }

    public static class Builder {
        Socket a;
        String b;
        BufferedSource c;
        BufferedSink d;
        Listener e = Listener.e;
        PushObserver f = PushObserver.a;
        boolean g;
        int h;

        public Builder(boolean bl) {
            this.g = bl;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.a = socket;
            this.b = string;
            this.c = bufferedSource;
            this.d = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.e = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.f = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n2) {
            this.h = n2;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        private boolean a;
        private int b;
        private int c;
        private /* synthetic */ Http2Connection d;

        PingRunnable(Http2Connection http2Connection, boolean bl, int n2, int n3) {
            this.d = http2Connection;
            super("OkHttp %s ping %08x%08x", http2Connection.d, n2, n3);
            this.a = bl;
            this.b = n2;
            this.c = n3;
        }

        @Override
        public final void execute() {
            this.d.a(this.a, this.b, this.c);
        }
    }
}

