/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http1;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.ResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RealConnection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpCodec;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RealResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RequestLine;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.StatusLine;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ForwardingTimeout;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import com.tencent.cloud.huiyansdkface.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

public final class Http1Codec
implements HttpCodec {
    final OkHttpClient a;
    final StreamAllocation b;
    final BufferedSource c;
    final BufferedSink d;
    int e = 0;
    private long f = 262144L;

    public Http1Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.a = okHttpClient;
        this.b = streamAllocation;
        this.c = bufferedSource;
        this.d = bufferedSink;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l2 != -1L) {
            return this.newFixedLengthSink(l2);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        RealConnection realConnection = this.b.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public final void writeRequestHeaders(Request request) throws IOException {
        String string = RequestLine.get(request, this.b.connection().route().proxy().type());
        this.writeRequest(request.headers(), string);
    }

    @Override
    public final ResponseBody openResponseBody(Response closeable) throws IOException {
        this.b.b.responseBodyStart(this.b.a);
        String string = closeable.header("Content-Type");
        if (!HttpHeaders.hasBody(closeable)) {
            Source source = this.newFixedLengthSource(0L);
            return new RealResponseBody(string, 0L, Okio.buffer(source));
        }
        if ("chunked".equalsIgnoreCase(closeable.header("Transfer-Encoding"))) {
            Source source = this.newChunkedSource(closeable.request().url());
            return new RealResponseBody(string, -1L, Okio.buffer(source));
        }
        long l2 = HttpHeaders.contentLength(closeable);
        if (l2 != -1L) {
            closeable = this.newFixedLengthSource(l2);
            return new RealResponseBody(string, l2, Okio.buffer((Source)closeable));
        }
        return new RealResponseBody(string, -1L, Okio.buffer(this.newUnknownLengthSource()));
    }

    public final boolean isClosed() {
        return this.e == 6;
    }

    @Override
    public final void flushRequest() throws IOException {
        this.d.flush();
    }

    @Override
    public final void finishRequest() throws IOException {
        this.d.flush();
    }

    public final void writeRequest(Headers headers, String string) throws IOException {
        if (this.e != 0) {
            throw new IllegalStateException("state: " + this.e);
        }
        this.d.writeUtf8(string).writeUtf8("\r\n");
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.d.writeUtf8(headers.name(i2)).writeUtf8(": ").writeUtf8(headers.value(i2)).writeUtf8("\r\n");
        }
        this.d.writeUtf8("\r\n");
        this.e = 1;
    }

    @Override
    public final Response.Builder readResponseHeaders(boolean bl) throws IOException {
        if (this.e != 1 && this.e != 3) {
            throw new IllegalStateException("state: " + this.e);
        }
        try {
            StatusLine statusLine = StatusLine.parse(this.a());
            Response.Builder builder = new Response.Builder().protocol(statusLine.a).code(statusLine.b).message(statusLine.c).headers(this.readHeaders());
            if (bl && statusLine.b == 100) {
                return null;
            }
            if (statusLine.b == 100) {
                this.e = 3;
                return builder;
            }
            this.e = 4;
            return builder;
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException("unexpected end of stream on " + this.b);
            iOException.initCause(eOFException);
            throw iOException;
        }
    }

    private String a() throws IOException {
        String string = this.c.readUtf8LineStrict(this.f);
        this.f -= (long)string.length();
        return string;
    }

    public final Headers readHeaders() throws IOException {
        String string;
        Headers.Builder builder = new Headers.Builder();
        while ((string = this.a()).length() != 0) {
            Internal.a.addLenient(builder, string);
        }
        return builder.build();
    }

    public final Sink newChunkedSink() {
        if (this.e != 1) {
            throw new IllegalStateException("state: " + this.e);
        }
        this.e = 2;
        return new ChunkedSink(this);
    }

    public final Sink newFixedLengthSink(long l2) {
        if (this.e != 1) {
            throw new IllegalStateException("state: " + this.e);
        }
        this.e = 2;
        return new FixedLengthSink(this, l2);
    }

    public final Source newFixedLengthSource(long l2) throws IOException {
        if (this.e != 4) {
            throw new IllegalStateException("state: " + this.e);
        }
        this.e = 5;
        return new FixedLengthSource(this, l2);
    }

    public final Source newChunkedSource(HttpUrl httpUrl) throws IOException {
        if (this.e != 4) {
            throw new IllegalStateException("state: " + this.e);
        }
        this.e = 5;
        return new ChunkedSource(this, httpUrl);
    }

    public final Source newUnknownLengthSource() throws IOException {
        if (this.e != 4) {
            throw new IllegalStateException("state: " + this.e);
        }
        if (this.b == null) {
            throw new IllegalStateException("streamAllocation == null");
        }
        this.e = 5;
        this.b.noNewStreams();
        return new UnknownLengthSource(this);
    }

    static void a(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    class UnknownLengthSource
    extends AbstractSource {
        private boolean b;

        UnknownLengthSource(Http1Codec http1Codec) {
            super(http1Codec, (byte)0);
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.a) {
                throw new IllegalStateException("closed");
            }
            if (this.b) {
                return -1L;
            }
            long l3 = super.read(buffer, l2);
            if (l3 == -1L) {
                this.b = true;
                this.a(true, null);
                return -1L;
            }
            return l3;
        }

        @Override
        public void close() throws IOException {
            if (this.a) {
                return;
            }
            if (!this.b) {
                this.a(false, null);
            }
            this.a = true;
        }
    }

    class ChunkedSource
    extends AbstractSource {
        private final HttpUrl b;
        private long c;
        private boolean d;
        private /* synthetic */ Http1Codec e;

        ChunkedSource(Http1Codec http1Codec, HttpUrl httpUrl) {
            this.e = http1Codec;
            super(http1Codec, (byte)0);
            this.c = -1L;
            this.d = true;
            this.b = httpUrl;
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            long l3;
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.a) {
                throw new IllegalStateException("closed");
            }
            if (!this.d) {
                return -1L;
            }
            if (this.c == 0L || this.c == -1L) {
                ChunkedSource chunkedSource = this;
                if (chunkedSource.c != -1L) {
                    chunkedSource.e.c.readUtf8LineStrict();
                }
                try {
                    chunkedSource.c = chunkedSource.e.c.readHexadecimalUnsignedLong();
                    String string = chunkedSource.e.c.readUtf8LineStrict().trim();
                    if (chunkedSource.c < 0L || !string.isEmpty() && !string.startsWith(";")) {
                        throw new ProtocolException("expected chunk size and optional extensions but was \"" + chunkedSource.c + string + "\"");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException(numberFormatException.getMessage());
                }
                if (chunkedSource.c == 0L) {
                    chunkedSource.d = false;
                    HttpHeaders.receiveHeaders(chunkedSource.e.a.cookieJar(), chunkedSource.b, chunkedSource.e.readHeaders());
                    chunkedSource.a(true, null);
                }
                if (!this.d) {
                    return -1L;
                }
            }
            if ((l3 = super.read((Buffer)object, Math.min(l2, this.c))) == -1L) {
                object = new ProtocolException("unexpected end of stream");
                this.a(false, (IOException)object);
                throw object;
            }
            this.c -= l3;
            return l3;
        }

        @Override
        public void close() throws IOException {
            if (this.a) {
                return;
            }
            if (this.d && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.a(false, null);
            }
            this.a = true;
        }
    }

    class FixedLengthSource
    extends AbstractSource {
        private long b;

        FixedLengthSource(Http1Codec http1Codec, long l2) throws IOException {
            super(http1Codec, (byte)0);
            this.b = l2;
            if (this.b == 0L) {
                this.a(true, null);
            }
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.a) {
                throw new IllegalStateException("closed");
            }
            if (this.b == 0L) {
                return -1L;
            }
            long l3 = super.read((Buffer)object, Math.min(this.b, l2));
            if (l3 == -1L) {
                object = new ProtocolException("unexpected end of stream");
                this.a(false, (IOException)object);
                throw object;
            }
            this.b -= l3;
            if (this.b == 0L) {
                this.a(true, null);
            }
            return l3;
        }

        @Override
        public void close() throws IOException {
            if (this.a) {
                return;
            }
            if (this.b != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.a(false, null);
            }
            this.a = true;
        }
    }

    abstract class AbstractSource
    implements Source {
        private ForwardingTimeout b;
        protected boolean a;
        private long c;
        private /* synthetic */ Http1Codec d;

        private AbstractSource(Http1Codec http1Codec) {
            this.d = http1Codec;
            this.b = new ForwardingTimeout(this.d.c.timeout());
            this.c = 0L;
        }

        @Override
        public Timeout timeout() {
            return this.b;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            try {
                long l3 = this.d.c.read(buffer, l2);
                if (l3 > 0L) {
                    this.c += l3;
                }
                return l3;
            }
            catch (IOException iOException) {
                this.a(false, iOException);
                throw iOException;
            }
        }

        protected final void a(boolean bl, IOException iOException) throws IOException {
            if (this.d.e == 6) {
                return;
            }
            if (this.d.e != 5) {
                throw new IllegalStateException("state: " + this.d.e);
            }
            Http1Codec.a(this.b);
            this.d.e = 6;
            if (this.d.b != null) {
                this.d.b.streamFinished(!bl, this.d, this.c, iOException);
            }
        }

        /* synthetic */ AbstractSource(Http1Codec http1Codec, byte by) {
            this(http1Codec);
        }
    }

    final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout a;
        private boolean b;
        private /* synthetic */ Http1Codec c;

        ChunkedSink(Http1Codec http1Codec) {
            this.c = http1Codec;
            this.a = new ForwardingTimeout(this.c.d.timeout());
        }

        @Override
        public final Timeout timeout() {
            return this.a;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (this.b) {
                throw new IllegalStateException("closed");
            }
            if (l2 == 0L) {
                return;
            }
            this.c.d.writeHexadecimalUnsignedLong(l2);
            this.c.d.writeUtf8("\r\n");
            this.c.d.write(buffer, l2);
            this.c.d.writeUtf8("\r\n");
        }

        @Override
        public final synchronized void flush() throws IOException {
            if (this.b) {
                return;
            }
            this.c.d.flush();
        }

        @Override
        public final synchronized void close() throws IOException {
            if (this.b) {
                return;
            }
            this.b = true;
            this.c.d.writeUtf8("0\r\n\r\n");
            Http1Codec.a(this.a);
            this.c.e = 3;
        }
    }

    final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout a;
        private boolean b;
        private long c;
        private /* synthetic */ Http1Codec d;

        FixedLengthSink(Http1Codec http1Codec, long l2) {
            this.d = http1Codec;
            this.a = new ForwardingTimeout(this.d.d.timeout());
            this.c = l2;
        }

        @Override
        public final Timeout timeout() {
            return this.a;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (this.b) {
                throw new IllegalStateException("closed");
            }
            Util.checkOffsetAndCount(buffer.size(), 0L, l2);
            if (l2 > this.c) {
                throw new ProtocolException("expected " + this.c + " bytes but received " + l2);
            }
            this.d.d.write(buffer, l2);
            this.c -= l2;
        }

        @Override
        public final void flush() throws IOException {
            if (this.b) {
                return;
            }
            this.d.d.flush();
        }

        @Override
        public final void close() throws IOException {
            if (this.b) {
                return;
            }
            this.b = true;
            if (this.c > 0L) {
                throw new ProtocolException("unexpected end of stream");
            }
            Http1Codec.a(this.a);
            this.d.e = 3;
        }
    }
}

