/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http;

import com.tencent.cloud.huiyansdkface.okhttp3.Address;
import com.tencent.cloud.huiyansdkface.okhttp3.Call;
import com.tencent.cloud.huiyansdkface.okhttp3.CertificatePinner;
import com.tencent.cloud.huiyansdkface.okhttp3.EventListener;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpClient;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.RequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.Route;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RouteException;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpMethod;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RealInterceptorChain;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.UnrepeatableRequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.ConnectionShutdownException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private final OkHttpClient a;
    private volatile StreamAllocation b;
    private Object c;
    private volatile boolean d;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient, boolean bl) {
        this.a = okHttpClient;
    }

    public final void cancel() {
        this.d = true;
        StreamAllocation streamAllocation = this.b;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public final boolean isCanceled() {
        return this.d;
    }

    public final void setCallStackTrace(Object object) {
        this.c = object;
    }

    public final StreamAllocation streamAllocation() {
        return this.b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        StreamAllocation streamAllocation;
        Object object = chain.request();
        chain = (RealInterceptorChain)chain;
        Call call = ((RealInterceptorChain)chain).call();
        EventListener eventListener = ((RealInterceptorChain)chain).eventListener();
        this.b = streamAllocation = new StreamAllocation(this.a.connectionPool(), this.a(((Request)object).url()), call, eventListener, this.c);
        int n2 = 0;
        Response response = null;
        while (true) {
            Object object2;
            Response response2;
            if (this.d) {
                streamAllocation.release();
                throw new IOException("Canceled");
            }
            try {
                try {
                    response2 = ((RealInterceptorChain)chain).proceed((Request)object, streamAllocation, null, null);
                }
                catch (RouteException routeException) {
                    if (this.a(routeException.getLastConnectException(), streamAllocation, false, (Request)object)) continue;
                    throw routeException.getFirstConnectException();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    boolean bl = !(iOException instanceof ConnectionShutdownException);
                    if (this.a((IOException)object2, streamAllocation, bl, (Request)object)) continue;
                    throw object2;
                }
            }
            catch (Throwable throwable) {
                streamAllocation.streamFailed(null);
                streamAllocation.release();
                throw throwable;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            try {
                Request request;
                block32: {
                    object2 = streamAllocation.route();
                    response = response2;
                    object = this;
                    if (response == null) {
                        throw new IllegalStateException();
                    }
                    int n3 = response.code();
                    String string = response.request().method();
                    switch (n3) {
                        case 407: {
                            Proxy proxy = object2 != null ? ((Route)object2).proxy() : ((RetryAndFollowUpInterceptor)object).a.proxy();
                            if (proxy.type() != Proxy.Type.HTTP) {
                                throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                            }
                            request = ((RetryAndFollowUpInterceptor)object).a.proxyAuthenticator().authenticate((Route)object2, response);
                            break block32;
                        }
                        case 401: {
                            request = ((RetryAndFollowUpInterceptor)object).a.authenticator().authenticate((Route)object2, response);
                            break block32;
                        }
                        case 307: 
                        case 308: {
                            if (!string.equals("GET") && !string.equals("HEAD")) break;
                        }
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: {
                            if (!((RetryAndFollowUpInterceptor)object).a.followRedirects() || (object2 = response.header("Location")) == null || (object2 = response.request().url().resolve((String)object2)) == null) break;
                            boolean bl = ((HttpUrl)object2).scheme().equals(response.request().url().scheme());
                            n3 = bl ? 1 : 0;
                            if (!bl && !((RetryAndFollowUpInterceptor)object).a.followSslRedirects()) break;
                            object = response.request().newBuilder();
                            if (HttpMethod.permitsRequestBody(string)) {
                                n3 = HttpMethod.redirectsWithBody(string) ? 1 : 0;
                                if (HttpMethod.redirectsToGet(string)) {
                                    ((Request.Builder)object).method("GET", null);
                                } else {
                                    RequestBody requestBody = n3 != 0 ? response.request().body() : null;
                                    ((Request.Builder)object).method(string, requestBody);
                                }
                                if (n3 == 0) {
                                    ((Request.Builder)object).removeHeader("Transfer-Encoding");
                                    ((Request.Builder)object).removeHeader("Content-Length");
                                    ((Request.Builder)object).removeHeader("Content-Type");
                                }
                            }
                            if (!RetryAndFollowUpInterceptor.a(response, (HttpUrl)object2)) {
                                ((Request.Builder)object).removeHeader("Authorization");
                            }
                            request = ((Request.Builder)object).url((HttpUrl)object2).build();
                            break block32;
                        }
                        case 408: {
                            if (!((RetryAndFollowUpInterceptor)object).a.retryOnConnectionFailure() || response.request().body() instanceof UnrepeatableRequestBody || response.priorResponse() != null && response.priorResponse().code() == 408 || RetryAndFollowUpInterceptor.a(response, 0) > 0) break;
                            request = response.request();
                            break block32;
                        }
                        case 503: {
                            if (response.priorResponse() != null && response.priorResponse().code() == 503) break;
                            request = RetryAndFollowUpInterceptor.a(response, Integer.MAX_VALUE) == 0 ? response.request() : null;
                            break block32;
                        }
                    }
                    request = null;
                }
                object2 = request;
            }
            catch (IOException iOException) {
                streamAllocation.release();
                throw iOException;
            }
            if (object2 == null) {
                streamAllocation.release();
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (++n2 > 20) {
                streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + n2);
            }
            if (((Request)object2).body() instanceof UnrepeatableRequestBody) {
                streamAllocation.release();
                throw new HttpRetryException("Cannot retry streamed HTTP body", response2.code());
            }
            if (!RetryAndFollowUpInterceptor.a(response2, ((Request)object2).url())) {
                streamAllocation.release();
                this.b = streamAllocation = new StreamAllocation(this.a.connectionPool(), this.a(((Request)object2).url()), call, eventListener, this.c);
            } else if (streamAllocation.codec() != null) {
                throw new IllegalStateException("Closing the body of " + response2 + " didn't close its backing stream. Bad interceptor?");
            }
            object = object2;
            response = response2;
        }
    }

    private Address a(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.a.sslSocketFactory();
            hostnameVerifier = this.a.hostnameVerifier();
            certificatePinner = this.a.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.a.dns(), this.a.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.a.proxyAuthenticator(), this.a.proxy(), this.a.protocols(), this.a.connectionSpecs(), this.a.proxySelector());
    }

    private boolean a(IOException iOException, StreamAllocation streamAllocation, boolean bl, Request request) {
        streamAllocation.streamFailed(iOException);
        if (!this.a.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && request.body() instanceof UnrepeatableRequestBody) {
            return false;
        }
        if (!(iOException instanceof ProtocolException ? false : (iOException instanceof InterruptedIOException ? iOException instanceof SocketTimeoutException && !bl : (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException ? false : !(iOException instanceof SSLPeerUnverifiedException))))) {
            return false;
        }
        return streamAllocation.hasMoreRoutes();
    }

    private static int a(Response object, int n2) {
        if ((object = ((Response)object).header("Retry-After")) == null) {
            return n2;
        }
        if (((String)object).matches("\\d+")) {
            return Integer.valueOf((String)object);
        }
        return Integer.MAX_VALUE;
    }

    private static boolean a(Response object, HttpUrl httpUrl) {
        return ((HttpUrl)(object = ((Response)object).request().url())).host().equals(httpUrl.host()) && ((HttpUrl)object).port() == httpUrl.port() && ((HttpUrl)object).scheme().equals(httpUrl.scheme());
    }
}

