/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http;

import com.tencent.cloud.huiyansdkface.okhttp3.Challenge;
import com.tencent.cloud.huiyansdkface.okhttp3.Cookie;
import com.tencent.cloud.huiyansdkface.okhttp3.CookieJar;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class HttpHeaders {
    private static final ByteString a = ByteString.encodeUtf8("\"\\");
    private static final ByteString b = ByteString.encodeUtf8("\t ,=");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.a(headers.get("Content-Length"));
    }

    private static long a(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response object, Headers headers, Request request) {
        for (String string : HttpHeaders.varyFields(((Response)object).headers())) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"Vary".equalsIgnoreCase(headers.name(i2))) continue;
            String[] stringArray = headers.value(i2);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string : stringArray.split(",")) {
                set.add(string.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response object) {
        Headers headers = ((Response)object).networkResponse().request().headers();
        object = ((Response)object).headers();
        return HttpHeaders.varyHeaders(headers, (Headers)object);
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        if ((object = HttpHeaders.varyFields((Headers)object)).isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            if (!object.contains(string)) continue;
            builder.add(string, headers.value(i2));
        }
        return builder.build();
    }

    public static List<Challenge> parseChallenges(Headers headers, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        for (int i2 = 0; i2 < headers.size(); ++i2) {
            if (!string.equalsIgnoreCase(headers.name(i2))) continue;
            Buffer buffer = new Buffer().writeUtf8(headers.value(i2));
            HttpHeaders.a(arrayList, buffer);
        }
        return arrayList;
    }

    private static void a(List<Challenge> list, Buffer buffer) {
        Object object = null;
        while (true) {
            LinkedHashMap<String, String> linkedHashMap;
            String string;
            block11: {
                if (object == null) {
                    HttpHeaders.a(buffer);
                    object = HttpHeaders.c(buffer);
                    if (object == null) {
                        return;
                    }
                }
                string = object;
                boolean bl = HttpHeaders.a(buffer);
                object = HttpHeaders.c(buffer);
                if (object == null) {
                    if (!buffer.exhausted()) {
                        return;
                    }
                    list.add(new Challenge(string, Collections.emptyMap()));
                    return;
                }
                int n2 = HttpHeaders.a(buffer, (byte)61);
                boolean bl2 = HttpHeaders.a(buffer);
                if (!bl && (bl2 || buffer.exhausted())) {
                    StringBuilder stringBuilder = new StringBuilder().append((String)object);
                    int n3 = n2;
                    int n4 = 61;
                    char[] cArray = new char[n3];
                    object = cArray;
                    Arrays.fill(cArray, '=');
                    list.add(new Challenge(string, Collections.singletonMap(null, stringBuilder.append(new String((char[])object)).toString())));
                    object = null;
                    continue;
                }
                linkedHashMap = new LinkedHashMap<String, String>();
                n2 += HttpHeaders.a(buffer, (byte)61);
                do {
                    if (object == null) {
                        object = HttpHeaders.c(buffer);
                        if (HttpHeaders.a(buffer)) break block11;
                        n2 = HttpHeaders.a(buffer, (byte)61);
                    }
                    if (n2 == 0) break block11;
                    if (n2 > 1) {
                        return;
                    }
                    if (HttpHeaders.a(buffer)) {
                        return;
                    }
                    String string2 = !buffer.exhausted() && buffer.getByte(0L) == 34 ? HttpHeaders.b(buffer) : HttpHeaders.c(buffer);
                    if (string2 == null) {
                        return;
                    }
                    string2 = linkedHashMap.put((String)object, string2);
                    object = null;
                    if (string2 == null) continue;
                    return;
                } while (HttpHeaders.a(buffer) || buffer.exhausted());
                return;
            }
            list.add(new Challenge(string, linkedHashMap));
        }
    }

    private static boolean a(Buffer buffer) {
        boolean bl = false;
        while (!buffer.exhausted()) {
            byte by = buffer.getByte(0L);
            if (by == 44) {
                buffer.readByte();
                bl = true;
                continue;
            }
            if (by != 32 && by != 9) break;
            buffer.readByte();
        }
        return bl;
    }

    private static int a(Buffer buffer, byte by) {
        by = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == 61) {
            by = (byte)(by + 1);
            buffer.readByte();
        }
        return by;
    }

    private static String b(Buffer buffer) {
        if (buffer.readByte() != 34) {
            throw new IllegalArgumentException();
        }
        Buffer buffer2 = new Buffer();
        long l2;
        while ((l2 = buffer.indexOfElement(a)) != -1L) {
            if (buffer.getByte(l2) == 34) {
                buffer2.write(buffer, l2);
                buffer.readByte();
                return buffer2.readUtf8();
            }
            if (buffer.size() == l2 + 1L) {
                return null;
            }
            buffer2.write(buffer, l2);
            buffer.readByte();
            buffer2.write(buffer, 1L);
        }
        return null;
    }

    private static String c(Buffer buffer) {
        try {
            long l2 = buffer.indexOfElement(b);
            if (l2 == -1L) {
                l2 = buffer.size();
            }
            if (l2 != 0L) {
                return buffer.readUtf8(l2);
            }
            return null;
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers object) {
        if (cookieJar == CookieJar.a) {
            return;
        }
        if ((object = Cookie.parseAll(httpUrl, (Headers)object)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List<Cookie>)object);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String string, int n2, String string2) {
        while (n2 < string.length() && string2.indexOf(string.charAt(n2)) == -1) {
            ++n2;
        }
        return n2;
    }

    public static int skipWhitespace(String string, int n2) {
        char c2;
        while (n2 < string.length() && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t')) {
            ++n2;
        }
        return n2;
    }

    public static int parseSeconds(String string, int n2) {
        long l2;
        block3: {
            try {
                l2 = Long.parseLong(string);
                if (l2 > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (l2 >= 0L) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return (int)l2;
    }
}

