/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal.http;

import com.tencent.cloud.huiyansdkface.okhttp3.Cookie;
import com.tencent.cloud.huiyansdkface.okhttp3.CookieJar;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.MediaType;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.RequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Version;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.RealResponseBody;
import com.tencent.cloud.huiyansdkface.okio.GzipSource;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.IOException;

public final class BridgeInterceptor
implements Interceptor {
    private final CookieJar a;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.a = cookieJar;
    }

    @Override
    public final Response intercept(Interceptor.Chain object) throws IOException {
        Object object2;
        Object object3 = object.request();
        Object object4 = ((Request)object3).newBuilder();
        Object object5 = ((Request)object3).body();
        if (object5 != null) {
            long l2;
            MediaType mediaType = ((RequestBody)object5).contentType();
            if (mediaType != null) {
                ((Request.Builder)object4).header("Content-Type", mediaType.toString());
            }
            if ((l2 = ((RequestBody)object5).contentLength()) != -1L) {
                ((Request.Builder)object4).header("Content-Length", Long.toString(l2));
                ((Request.Builder)object4).removeHeader("Transfer-Encoding");
            } else {
                ((Request.Builder)object4).header("Transfer-Encoding", "chunked");
                ((Request.Builder)object4).removeHeader("Content-Length");
            }
        }
        if (((Request)object3).header("Host") == null) {
            ((Request.Builder)object4).header("Host", Util.hostHeader(((Request)object3).url(), false));
        }
        if (((Request)object3).header("Connection") == null) {
            ((Request.Builder)object4).header("Connection", "Keep-Alive");
        }
        boolean bl = false;
        if (((Request)object3).header("Accept-Encoding") == null && ((Request)object3).header("Range") == null) {
            bl = true;
            ((Request.Builder)object4).header("Accept-Encoding", "gzip");
        }
        if (!(object2 = this.a.loadForRequest(((Request)object3).url())).isEmpty()) {
            object5 = object2;
            object2 = new StringBuilder();
            int n2 = object5.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    ((StringBuilder)object2).append("; ");
                }
                Cookie cookie = (Cookie)object5.get(i2);
                ((StringBuilder)object2).append(cookie.name()).append('=').append(cookie.value());
            }
            ((Request.Builder)object4).header("Cookie", ((StringBuilder)object2).toString());
        }
        if (((Request)object3).header("User-Agent") == null) {
            ((Request.Builder)object4).header("User-Agent", Version.userAgent());
        }
        Response response = object.proceed(((Request.Builder)object4).build());
        HttpHeaders.receiveHeaders(this.a, ((Request)object3).url(), response.headers());
        object = response.newBuilder().request((Request)object3);
        if (bl && "gzip".equalsIgnoreCase(response.header("Content-Encoding")) && HttpHeaders.hasBody(response)) {
            object3 = new GzipSource(response.body().source());
            object4 = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            ((Response.Builder)object).headers((Headers)object4);
            object4 = response.header("Content-Type");
            ((Response.Builder)object).body(new RealResponseBody((String)object4, -1L, Okio.buffer((Source)object3)));
        }
        return ((Response.Builder)object).build();
    }
}

