/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3.internal;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.RequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.ResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http2.Header;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class Util {
    public static final byte[] a;
    public static final ResponseBody b;
    public static final RequestBody c;
    private static final ByteString h;
    private static final ByteString i;
    private static final ByteString j;
    private static final ByteString k;
    private static final ByteString l;
    public static final Charset d;
    public static final Charset e;
    private static final Charset m;
    private static final Charset n;
    private static final Charset o;
    private static final Charset p;
    public static final TimeZone f;
    public static final Comparator<String> g;
    private static final Method q;
    private static final Pattern r;

    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        if (q != null) {
            try {
                q.invoke((Object)throwable, throwable2);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
    }

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable object) {
        if (object != null) {
            try {
                object.close();
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(Socket object) {
        if (object != null) {
            try {
                ((Socket)object).close();
                return;
            }
            catch (AssertionError assertionError) {
                object = assertionError;
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw object;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(ServerSocket object) {
        if (object != null) {
            try {
                ((ServerSocket)object).close();
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l2 + Math.min(l3, timeUnit.toNanos(n2)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
        finally {
            if (l3 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l2 + l3);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(String string, boolean bl) {
        return new ThreadFactory(string, bl){
            private /* synthetic */ String a;
            private /* synthetic */ boolean b;
            {
                this.a = string;
                this.b = bl;
            }

            @Override
            public final Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, this.a);
                ((Thread)runnable).setDaemon(this.b);
                return runnable;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : stringArray) {
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray3[i2];
                if (comparator.compare(string, string2) != 0) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray3[i2];
                if (comparator.compare(string, string2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string;
        String string2 = string = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        if (bl || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme())) {
            return string + ":" + httpUrl.port();
        }
        return string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(stringArray[i2], string) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string, int n2, int n3) {
        while (n2 < n3) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n2;
                }
            }
            ++n2;
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            switch (string.charAt(n3)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n3 + 1;
                }
            }
            --n3;
        }
        return n2;
    }

    public static String trimSubstring(String string, int n2, int n3) {
        n2 = Util.skipLeadingAsciiWhitespace(string, n2, n3);
        n3 = Util.skipTrailingAsciiWhitespace(string, n2, n3);
        return string.substring(n2, n3);
    }

    public static int delimiterOffset(String string, int n2, int n3, String string2) {
        while (n2 < n3) {
            if (string2.indexOf(string.charAt(n2)) != -1) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int delimiterOffset(String string, int n2, int n3, char c2) {
        while (n2 < n3) {
            if (string.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static String canonicalizeHost(String object) {
        if (((String)object).contains(":")) {
            Object object2 = ((String)object).startsWith("[") && ((String)object).endsWith("]") ? Util.a((String)object, 1, ((String)object).length() - 1) : Util.a((String)object, 0, ((String)object).length());
            if (object2 == null) {
                return null;
            }
            byte[] byArray = ((InetAddress)object2).getAddress();
            object2 = byArray;
            if (byArray.length == 16) {
                int n2;
                int n3;
                object = object2;
                int n4 = -1;
                int n5 = 0;
                for (int i2 = 0; i2 < ((Object)object).length; i2 += 2) {
                    n3 = i2;
                    while (i2 < 16 && object[i2] == false && object[i2 + 1] == false) {
                        i2 += 2;
                    }
                    n2 = i2 - n3;
                    if (n2 <= n5 || n2 < 4) continue;
                    n4 = n3;
                    n5 = n2;
                }
                Buffer buffer = new Buffer();
                n3 = 0;
                while (n3 < ((Object)object).length) {
                    if (n3 == n4) {
                        buffer.writeByte(58);
                        if ((n3 += n5) != 16) continue;
                        buffer.writeByte(58);
                        continue;
                    }
                    if (n3 > 0) {
                        buffer.writeByte(58);
                    }
                    n2 = (object[n3] & 0xFF) << 8 | object[n3 + 1] & 0xFF;
                    buffer.writeHexadecimalUnsignedLong(n2);
                    n3 += 2;
                }
                return buffer.readUtf8();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + (String)object + "'"));
        }
        try {
            String string = IDN.toASCII((String)object).toLowerCase(Locale.US);
            if (string.isEmpty()) {
                return null;
            }
            if (Util.a(string)) {
                return null;
            }
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean a(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string) {
        return r.matcher(string).matches();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        if (bufferedSource.rangeEquals(0L, h)) {
            bufferedSource.skip(h.size());
            return d;
        }
        if (bufferedSource.rangeEquals(0L, i)) {
            bufferedSource.skip(i.size());
            return m;
        }
        if (bufferedSource.rangeEquals(0L, j)) {
            bufferedSource.skip(j.size());
            return n;
        }
        if (bufferedSource.rangeEquals(0L, k)) {
            bufferedSource.skip(k.size());
            return o;
        }
        if (bufferedSource.rangeEquals(0L, l)) {
            bufferedSource.skip(l.size());
            return p;
        }
        return charset;
    }

    public static int checkDuration(String string, long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + " too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException(string + " too small.");
        }
        return (int)l3;
    }

    public static AssertionError assertionError(String object, Exception exception) {
        object = new AssertionError(object);
        try {
            ((Throwable)object).initCause(exception);
        }
        catch (IllegalStateException illegalStateException) {}
        return object;
    }

    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    private static InetAddress a(String string, int n2, int n3) {
        byte[] byArray = new byte[16];
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (n2 < n3) {
            int n7;
            int n8;
            if (n4 == 16) {
                return null;
            }
            if (n2 + 2 <= n3 && string.regionMatches(n2, "::", 0, 2)) {
                if (n5 != -1) {
                    return null;
                }
                n5 = n4 += 2;
                if ((n2 += 2) == n3) {
                    break;
                }
            } else if (n4 != 0 && !string.regionMatches(n2, ":", 0, 1)) {
                if (string.regionMatches(n2, ".", 0, 1)) {
                    boolean bl;
                    block22: {
                        n8 = n4 - 2;
                        byte[] byArray2 = byArray;
                        n2 = n6;
                        n7 = n8;
                        while (n2 < n3) {
                            int n9;
                            if (n7 == 16) {
                                bl = false;
                                break block22;
                            }
                            if (n7 != n8 && string.charAt(n2) != '.') {
                                bl = false;
                                break block22;
                            }
                            int n10 = 0;
                            int n11 = ++n2;
                            while (n2 < n3 && (n9 = string.charAt(n2)) >= 48 && n9 <= 57) {
                                if (n10 == 0 && n11 != n2) {
                                    bl = false;
                                    break block22;
                                }
                                if ((n10 = n10 * 10 + n9 - 48) > 255) {
                                    bl = false;
                                    break block22;
                                }
                                ++n2;
                            }
                            n9 = n2 - n11;
                            if (n9 == 0) {
                                bl = false;
                                break block22;
                            }
                            byArray2[n7++] = (byte)n10;
                        }
                        bl = n7 == n8 + 4;
                    }
                    if (!bl) {
                        return null;
                    }
                    n4 += 2;
                    break;
                }
                return null;
            }
            n8 = 0;
            n6 = ++n2;
            while (n2 < n3) {
                n7 = string.charAt(n2);
                if ((n7 = Util.decodeHexDigit((char)n7)) == -1) break;
                n8 = (n8 << 4) + n7;
                ++n2;
            }
            if ((n7 = n2 - n6) == 0 || n7 > 4) {
                return null;
            }
            byArray[n4++] = (byte)(n8 >>> 8);
            byArray[n4++] = (byte)n8;
        }
        if (n4 != 16) {
            if (n5 == -1) {
                return null;
            }
            System.arraycopy(byArray, n5, byArray, 16 - (n4 - n5), n4 - n5);
            Arrays.fill(byArray, n5, n5 + (16 - n4), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    public static X509TrustManager platformTrustManager() {
        try {
            Object[] objectArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            objectArray.init((KeyStore)null);
            objectArray = objectArray.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
    }

    public static Headers toHeaders(List<Header> object) {
        Headers.Builder builder = new Headers.Builder();
        object = object.iterator();
        while (object.hasNext()) {
            Header header = (Header)object.next();
            Internal.a.addLenient(builder, header.g.utf8(), header.h.utf8());
        }
        return builder.build();
    }

    static {
        Method method;
        a = new byte[0];
        b = ResponseBody.create(null, a);
        c = RequestBody.create(null, a);
        h = ByteString.decodeHex("efbbbf");
        i = ByteString.decodeHex("feff");
        j = ByteString.decodeHex("fffe");
        k = ByteString.decodeHex("0000ffff");
        l = ByteString.decodeHex("ffff0000");
        d = Charset.forName("UTF-8");
        e = Charset.forName("ISO-8859-1");
        m = Charset.forName("UTF-16BE");
        n = Charset.forName("UTF-16LE");
        o = Charset.forName("UTF-32BE");
        p = Charset.forName("UTF-32LE");
        f = TimeZone.getTimeZone("GMT");
        g = new Comparator<String>(){

            @Override
            public final int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        };
        try {
            method = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {
            method = null;
        }
        q = method;
        r = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }
}

