/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.MediaType;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    private Reader a;

    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l2 = this.contentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + l2);
        }
        BufferedSource bufferedSource = this.source();
        try {
            byArray = bufferedSource.readByteArray();
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        if (l2 != -1L && l2 != (long)byArray.length) {
            throw new IOException("Content-Length (" + l2 + ") and stream length (" + byArray.length + ") disagree");
        }
        return byArray;
    }

    public final Reader charStream() {
        Reader reader = this.a;
        if (reader != null) {
            return reader;
        }
        this.a = new BomAwareReader(this.source(), this.a());
        return this.a;
    }

    public final String string() throws IOException {
        BufferedSource bufferedSource = this.source();
        try {
            Object object = Util.bomAwareCharset(bufferedSource, this.a());
            object = bufferedSource.readString((Charset)object);
            return object;
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private Charset a() {
        MediaType mediaType = this.contentType();
        if (mediaType != null) {
            return mediaType.charset(Util.d);
        }
        return Util.d;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public static ResponseBody create(MediaType mediaType, String object) {
        Charset charset = Util.d;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.d;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = new Buffer().writeString((String)object, charset);
        return ResponseBody.create(mediaType, ((Buffer)object).size(), (BufferedSource)object);
    }

    public static ResponseBody create(MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(MediaType mediaType, ByteString byteString) {
        Buffer buffer = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), buffer);
    }

    public static ResponseBody create(MediaType mediaType, long l2, BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(mediaType, l2, bufferedSource){
            private /* synthetic */ MediaType a;
            private /* synthetic */ long b;
            private /* synthetic */ BufferedSource c;
            {
                this.a = mediaType;
                this.b = l2;
                this.c = bufferedSource;
            }

            @Override
            public final MediaType contentType() {
                return this.a;
            }

            @Override
            public final long contentLength() {
                return this.b;
            }

            @Override
            public final BufferedSource source() {
                return this.c;
            }
        };
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferedSource a;
        private final Charset b;
        private boolean c;
        private Reader d;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.a = bufferedSource;
            this.b = charset;
        }

        @Override
        public final int read(char[] cArray, int n2, int n3) throws IOException {
            if (this.c) {
                throw new IOException("Stream closed");
            }
            Object object = this.d;
            if (object == null) {
                object = Util.bomAwareCharset(this.a, this.b);
                this.d = new InputStreamReader(this.a.inputStream(), (Charset)object);
                object = this.d;
            }
            return ((Reader)object).read(cArray, n2, n3);
        }

        @Override
        public final void close() throws IOException {
            this.c = true;
            if (this.d != null) {
                this.d.close();
                return;
            }
            this.a.close();
        }
    }
}

