/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.MediaType;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class RequestBody {
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;

    public static RequestBody create(MediaType mediaType, String object) {
        Charset charset = Util.d;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.d;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = ((String)object).getBytes(charset);
        return RequestBody.create(mediaType, (byte[])object);
    }

    public static RequestBody create(MediaType mediaType, ByteString byteString) {
        return new RequestBody(mediaType, byteString){
            private /* synthetic */ MediaType a;
            private /* synthetic */ ByteString b;
            {
                this.a = mediaType;
                this.b = byteString;
            }

            @Override
            public final MediaType contentType() {
                return this.a;
            }

            @Override
            public final long contentLength() throws IOException {
                return this.b.size();
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(this.b);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("content == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        return new RequestBody(mediaType, n3, byArray, n2){
            private /* synthetic */ MediaType a;
            private /* synthetic */ int b;
            private /* synthetic */ byte[] c;
            private /* synthetic */ int d;
            {
                this.a = mediaType;
                this.b = n2;
                this.c = byArray;
                this.d = n3;
            }

            @Override
            public final MediaType contentType() {
                return this.a;
            }

            @Override
            public final long contentLength() {
                return this.b;
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(this.c, this.d, this.b);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(mediaType, file){
            private /* synthetic */ MediaType a;
            private /* synthetic */ File b;
            {
                this.a = mediaType;
                this.b = file;
            }

            @Override
            public final MediaType contentType() {
                return this.a;
            }

            @Override
            public final long contentLength() {
                return this.b.length();
            }

            @Override
            public final void writeTo(BufferedSink bufferedSink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source(this.b);
                    bufferedSink.writeAll(source);
                    return;
                }
                finally {
                    Util.closeQuietly(source);
                }
            }
        };
    }
}

