/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.Address;
import com.tencent.cloud.huiyansdkface.okhttp3.Authenticator;
import com.tencent.cloud.huiyansdkface.okhttp3.Cache;
import com.tencent.cloud.huiyansdkface.okhttp3.Call;
import com.tencent.cloud.huiyansdkface.okhttp3.CertificatePinner;
import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionPool;
import com.tencent.cloud.huiyansdkface.okhttp3.ConnectionSpec;
import com.tencent.cloud.huiyansdkface.okhttp3.CookieJar;
import com.tencent.cloud.huiyansdkface.okhttp3.Dispatcher;
import com.tencent.cloud.huiyansdkface.okhttp3.Dns;
import com.tencent.cloud.huiyansdkface.okhttp3.EventListener;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.Interceptor;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.RealCall;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.Route;
import com.tencent.cloud.huiyansdkface.okhttp3.WebSocket;
import com.tencent.cloud.huiyansdkface.okhttp3.WebSocketListener;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Internal;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.InternalCache;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RealConnection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RouteDatabase;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.proxy.NullProxySelector;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.CertificateChainCleaner;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.tls.OkHostnameVerifier;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.ws.RealWebSocket;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OkHttpClient
implements Call.Factory,
WebSocket.Factory,
Cloneable {
    static final List<Protocol> a = Util.immutableList(Protocol.d, Protocol.b);
    static final List<ConnectionSpec> b = Util.immutableList(ConnectionSpec.a, ConnectionSpec.c);
    final Dispatcher c;
    final Proxy d;
    final List<Protocol> e;
    final List<ConnectionSpec> f;
    final List<Interceptor> g;
    final List<Interceptor> h;
    final EventListener.Factory i;
    final ProxySelector j;
    final CookieJar k;
    final Cache l;
    final InternalCache m;
    final SocketFactory n;
    final SSLSocketFactory o;
    final CertificateChainCleaner p;
    final HostnameVerifier q;
    final CertificatePinner r;
    final Authenticator s;
    final Authenticator t;
    final ConnectionPool u;
    final Dns v;
    final boolean w;
    final boolean x;
    final boolean y;
    final int z;
    final int A;
    final int B;
    final int C;
    final int D;

    public OkHttpClient() {
        this(new Builder());
    }

    OkHttpClient(Builder builder) {
        this.c = builder.a;
        this.d = builder.b;
        this.e = builder.c;
        this.f = builder.d;
        this.g = Util.immutableList(builder.e);
        this.h = Util.immutableList(builder.f);
        this.i = builder.g;
        this.j = builder.h;
        this.k = builder.i;
        this.l = builder.j;
        this.m = builder.k;
        this.n = builder.l;
        boolean bl = false;
        for (ConnectionSpec connectionSpec : this.f) {
            bl = bl || connectionSpec.isTls();
        }
        if (builder.m != null || !bl) {
            this.o = builder.m;
            this.p = builder.n;
        } else {
            X509TrustManager x509TrustManager = Util.platformTrustManager();
            this.o = OkHttpClient.a(x509TrustManager);
            this.p = CertificateChainCleaner.get(x509TrustManager);
        }
        if (this.o != null) {
            Platform.get().configureSslSocketFactory(this.o);
        }
        this.q = builder.o;
        this.r = builder.p.a(this.p);
        this.s = builder.q;
        this.t = builder.r;
        this.u = builder.s;
        this.v = builder.t;
        this.w = builder.u;
        this.x = builder.v;
        this.y = builder.w;
        this.z = builder.x;
        this.A = builder.y;
        this.B = builder.z;
        this.C = builder.A;
        this.D = builder.B;
        if (this.g.contains(null)) {
            throw new IllegalStateException("Null interceptor: " + this.g);
        }
        if (this.h.contains(null)) {
            throw new IllegalStateException("Null network interceptor: " + this.h);
        }
    }

    private static SSLSocketFactory a(X509TrustManager x509TrustManager) {
        try {
            SSLContext sSLContext = Platform.get().getSSLContext();
            sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
    }

    public int callTimeoutMillis() {
        return this.z;
    }

    public int connectTimeoutMillis() {
        return this.A;
    }

    public int readTimeoutMillis() {
        return this.B;
    }

    public int writeTimeoutMillis() {
        return this.C;
    }

    public int pingIntervalMillis() {
        return this.D;
    }

    public Proxy proxy() {
        return this.d;
    }

    public ProxySelector proxySelector() {
        return this.j;
    }

    public CookieJar cookieJar() {
        return this.k;
    }

    public Cache cache() {
        return this.l;
    }

    public Dns dns() {
        return this.v;
    }

    public SocketFactory socketFactory() {
        return this.n;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.o;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.q;
    }

    public CertificatePinner certificatePinner() {
        return this.r;
    }

    public Authenticator authenticator() {
        return this.t;
    }

    public Authenticator proxyAuthenticator() {
        return this.s;
    }

    public ConnectionPool connectionPool() {
        return this.u;
    }

    public boolean followSslRedirects() {
        return this.w;
    }

    public boolean followRedirects() {
        return this.x;
    }

    public boolean retryOnConnectionFailure() {
        return this.y;
    }

    public Dispatcher dispatcher() {
        return this.c;
    }

    public List<Protocol> protocols() {
        return this.e;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.f;
    }

    public List<Interceptor> interceptors() {
        return this.g;
    }

    public List<Interceptor> networkInterceptors() {
        return this.h;
    }

    public EventListener.Factory eventListenerFactory() {
        return this.i;
    }

    @Override
    public Call newCall(Request request) {
        return RealCall.a(this, request, false);
    }

    @Override
    public WebSocket newWebSocket(Request object, WebSocketListener webSocketListener) {
        object = new RealWebSocket((Request)object, webSocketListener, new Random(), this.D);
        ((RealWebSocket)object).connect(this);
        return object;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    static {
        Internal.a = new Internal(){

            @Override
            public final void addLenient(Headers.Builder builder, String string) {
                builder.a(string);
            }

            @Override
            public final void addLenient(Headers.Builder builder, String string, String string2) {
                builder.a(string, string2);
            }

            @Override
            public final void setCache(Builder builder, InternalCache internalCache) {
                v0.k = internalCache;
                builder.j = null;
            }

            @Override
            public final boolean connectionBecameIdle(ConnectionPool connectionPool, RealConnection realConnection) {
                return connectionPool.b(realConnection);
            }

            @Override
            public final RealConnection get(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation, Route route) {
                return connectionPool.a(address, streamAllocation, route);
            }

            @Override
            public final boolean equalsNonHost(Address address, Address address2) {
                return address.a(address2);
            }

            @Override
            public final Socket deduplicate(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation) {
                return connectionPool.a(address, streamAllocation);
            }

            @Override
            public final void put(ConnectionPool connectionPool, RealConnection realConnection) {
                connectionPool.a(realConnection);
            }

            @Override
            public final RouteDatabase routeDatabase(ConnectionPool connectionPool) {
                return connectionPool.a;
            }

            @Override
            public final int code(Response.Builder builder) {
                return builder.c;
            }

            @Override
            public final void apply(ConnectionSpec connectionSpec, SSLSocket sSLSocket, boolean bl) {
                connectionSpec.a(sSLSocket, bl);
            }

            @Override
            public final boolean isInvalidHttpUrlHost(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException.getMessage().startsWith("Invalid URL host");
            }

            @Override
            public final StreamAllocation streamAllocation(Call call) {
                call = (RealCall)call;
                return ((RealCall)call).b.streamAllocation();
            }

            @Override
            public final IOException timeoutExit(Call call, IOException iOException) {
                return ((RealCall)call).a(iOException);
            }

            @Override
            public final Call newWebSocketCall(OkHttpClient okHttpClient, Request request) {
                return RealCall.a(okHttpClient, request, true);
            }
        };
    }

    public static final class Builder {
        Dispatcher a;
        Proxy b;
        List<Protocol> c;
        List<ConnectionSpec> d;
        final List<Interceptor> e = new ArrayList<Interceptor>();
        final List<Interceptor> f = new ArrayList<Interceptor>();
        EventListener.Factory g;
        ProxySelector h;
        CookieJar i;
        Cache j;
        InternalCache k;
        SocketFactory l;
        SSLSocketFactory m;
        CertificateChainCleaner n;
        HostnameVerifier o;
        CertificatePinner p;
        Authenticator q;
        Authenticator r;
        ConnectionPool s;
        Dns t;
        boolean u;
        boolean v;
        boolean w;
        int x;
        int y;
        int z;
        int A;
        int B;

        public Builder() {
            this.a = new Dispatcher();
            this.c = a;
            this.d = b;
            this.g = EventListener.a(EventListener.a);
            this.h = ProxySelector.getDefault();
            if (this.h == null) {
                this.h = new NullProxySelector();
            }
            this.i = CookieJar.a;
            this.l = SocketFactory.getDefault();
            this.o = OkHostnameVerifier.a;
            this.p = CertificatePinner.a;
            this.q = Authenticator.a;
            this.r = Authenticator.a;
            this.s = new ConnectionPool();
            this.t = Dns.a;
            this.u = true;
            this.v = true;
            this.w = true;
            this.x = 0;
            this.y = 10000;
            this.z = 10000;
            this.A = 10000;
            this.B = 0;
        }

        Builder(OkHttpClient okHttpClient) {
            this.a = okHttpClient.c;
            this.b = okHttpClient.d;
            this.c = okHttpClient.e;
            this.d = okHttpClient.f;
            this.e.addAll(okHttpClient.g);
            this.f.addAll(okHttpClient.h);
            this.g = okHttpClient.i;
            this.h = okHttpClient.j;
            this.i = okHttpClient.k;
            this.k = okHttpClient.m;
            this.j = okHttpClient.l;
            this.l = okHttpClient.n;
            this.m = okHttpClient.o;
            this.n = okHttpClient.p;
            this.o = okHttpClient.q;
            this.p = okHttpClient.r;
            this.q = okHttpClient.s;
            this.r = okHttpClient.t;
            this.s = okHttpClient.u;
            this.t = okHttpClient.v;
            this.u = okHttpClient.w;
            this.v = okHttpClient.x;
            this.w = okHttpClient.y;
            this.x = okHttpClient.z;
            this.y = okHttpClient.A;
            this.z = okHttpClient.B;
            this.A = okHttpClient.C;
            this.B = okHttpClient.D;
        }

        public final Builder callTimeout(long l2, TimeUnit timeUnit) {
            this.x = Util.checkDuration("timeout", l2, timeUnit);
            return this;
        }

        public final Builder callTimeout(Duration duration) {
            this.x = Util.checkDuration("timeout", duration.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder connectTimeout(long l2, TimeUnit timeUnit) {
            this.y = Util.checkDuration("timeout", l2, timeUnit);
            return this;
        }

        public final Builder connectTimeout(Duration duration) {
            this.y = Util.checkDuration("timeout", duration.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder readTimeout(long l2, TimeUnit timeUnit) {
            this.z = Util.checkDuration("timeout", l2, timeUnit);
            return this;
        }

        public final Builder readTimeout(Duration duration) {
            this.z = Util.checkDuration("timeout", duration.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder writeTimeout(long l2, TimeUnit timeUnit) {
            this.A = Util.checkDuration("timeout", l2, timeUnit);
            return this;
        }

        public final Builder writeTimeout(Duration duration) {
            this.A = Util.checkDuration("timeout", duration.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder pingInterval(long l2, TimeUnit timeUnit) {
            this.B = Util.checkDuration("interval", l2, timeUnit);
            return this;
        }

        public final Builder pingInterval(Duration duration) {
            this.B = Util.checkDuration("timeout", duration.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }

        public final Builder proxy(Proxy proxy) {
            this.b = proxy;
            return this;
        }

        public final Builder proxySelector(ProxySelector proxySelector) {
            if (proxySelector == null) {
                throw new NullPointerException("proxySelector == null");
            }
            this.h = proxySelector;
            return this;
        }

        public final Builder cookieJar(CookieJar cookieJar) {
            if (cookieJar == null) {
                throw new NullPointerException("cookieJar == null");
            }
            this.i = cookieJar;
            return this;
        }

        public final Builder cache(Cache cache) {
            this.j = cache;
            this.k = null;
            return this;
        }

        public final Builder dns(Dns dns) {
            if (dns == null) {
                throw new NullPointerException("dns == null");
            }
            this.t = dns;
            return this;
        }

        public final Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new NullPointerException("socketFactory == null");
            }
            this.l = socketFactory;
            return this;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            if (sSLSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory == null");
            }
            this.m = sSLSocketFactory;
            this.n = Platform.get().buildCertificateChainCleaner(sSLSocketFactory);
            return this;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory, X509TrustManager x509TrustManager) {
            if (sSLSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory == null");
            }
            if (x509TrustManager == null) {
                throw new NullPointerException("trustManager == null");
            }
            this.m = sSLSocketFactory;
            this.n = CertificateChainCleaner.get(x509TrustManager);
            return this;
        }

        public final Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new NullPointerException("hostnameVerifier == null");
            }
            this.o = hostnameVerifier;
            return this;
        }

        public final Builder certificatePinner(CertificatePinner certificatePinner) {
            if (certificatePinner == null) {
                throw new NullPointerException("certificatePinner == null");
            }
            this.p = certificatePinner;
            return this;
        }

        public final Builder authenticator(Authenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException("authenticator == null");
            }
            this.r = authenticator;
            return this;
        }

        public final Builder proxyAuthenticator(Authenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException("proxyAuthenticator == null");
            }
            this.q = authenticator;
            return this;
        }

        public final Builder connectionPool(ConnectionPool connectionPool) {
            if (connectionPool == null) {
                throw new NullPointerException("connectionPool == null");
            }
            this.s = connectionPool;
            return this;
        }

        public final Builder followSslRedirects(boolean bl) {
            this.u = bl;
            return this;
        }

        public final Builder followRedirects(boolean bl) {
            this.v = bl;
            return this;
        }

        public final Builder retryOnConnectionFailure(boolean bl) {
            this.w = bl;
            return this;
        }

        public final Builder dispatcher(Dispatcher dispatcher) {
            if (dispatcher == null) {
                throw new IllegalArgumentException("dispatcher == null");
            }
            this.a = dispatcher;
            return this;
        }

        public final Builder protocols(List<Protocol> list) {
            if (!(list = new ArrayList<Protocol>(list)).contains((Object)Protocol.e) && !list.contains((Object)Protocol.b)) {
                throw new IllegalArgumentException("protocols must contain h2_prior_knowledge or http/1.1: " + list);
            }
            if (list.contains((Object)Protocol.e) && list.size() > 1) {
                throw new IllegalArgumentException("protocols containing h2_prior_knowledge cannot use other protocols: " + list);
            }
            if (list.contains((Object)Protocol.a)) {
                throw new IllegalArgumentException("protocols must not contain http/1.0: " + list);
            }
            if (list.contains(null)) {
                throw new IllegalArgumentException("protocols must not contain null");
            }
            list.remove((Object)Protocol.c);
            this.c = Collections.unmodifiableList(list);
            return this;
        }

        public final Builder connectionSpecs(List<ConnectionSpec> list) {
            this.d = Util.immutableList(list);
            return this;
        }

        public final List<Interceptor> interceptors() {
            return this.e;
        }

        public final Builder addInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("interceptor == null");
            }
            this.e.add(interceptor);
            return this;
        }

        public final List<Interceptor> networkInterceptors() {
            return this.f;
        }

        public final Builder addNetworkInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("interceptor == null");
            }
            this.f.add(interceptor);
            return this;
        }

        public final Builder eventListener(EventListener eventListener) {
            if (eventListener == null) {
                throw new NullPointerException("eventListener == null");
            }
            this.g = EventListener.a(eventListener);
            return this;
        }

        public final Builder eventListenerFactory(EventListener.Factory factory) {
            if (factory == null) {
                throw new NullPointerException("eventListenerFactory == null");
            }
            this.g = factory;
            return this;
        }

        public final OkHttpClient build() {
            return new OkHttpClient(this);
        }
    }
}

