/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.MediaType;
import com.tencent.cloud.huiyansdkface.okhttp3.RequestBody;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MultipartBody
extends RequestBody {
    public static final MediaType a = MediaType.get("multipart/mixed");
    public static final MediaType b;
    private static final byte[] c;
    private static final byte[] d;
    private static final byte[] e;
    private final ByteString f;
    private final MediaType g;
    private final MediaType h;
    private final List<Part> i;
    private long j = -1L;

    MultipartBody(ByteString byteString, MediaType mediaType, List<Part> list) {
        this.f = byteString;
        this.g = mediaType;
        this.h = MediaType.get(mediaType + "; boundary=" + byteString.utf8());
        this.i = Util.immutableList(list);
    }

    public final MediaType type() {
        return this.g;
    }

    public final String boundary() {
        return this.f.utf8();
    }

    public final int size() {
        return this.i.size();
    }

    public final List<Part> parts() {
        return this.i;
    }

    public final Part part(int n2) {
        return this.i.get(n2);
    }

    @Override
    public final MediaType contentType() {
        return this.h;
    }

    @Override
    public final long contentLength() throws IOException {
        long l2 = this.j;
        if (l2 != -1L) {
            return l2;
        }
        this.j = this.a(null, true);
        return this.j;
    }

    @Override
    public final void writeTo(BufferedSink bufferedSink) throws IOException {
        this.a(bufferedSink, false);
    }

    private long a(BufferedSink bufferedSink, boolean bl) throws IOException {
        long l2 = 0L;
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer();
            bufferedSink = buffer;
        }
        int n2 = this.i.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            MediaType mediaType;
            Object object = this.i.get(i2);
            Headers headers = ((Part)object).a;
            object = ((Part)object).b;
            bufferedSink.write(e);
            bufferedSink.write(this.f);
            bufferedSink.write(d);
            if (headers != null) {
                int n3 = headers.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink.writeUtf8(headers.name(i3)).write(c).writeUtf8(headers.value(i3)).write(d);
                }
            }
            if ((mediaType = ((RequestBody)object).contentType()) != null) {
                bufferedSink.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(d);
            }
            if ((l3 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink.writeUtf8("Content-Length: ").writeDecimalLong(l3).write(d);
            } else if (bl) {
                buffer.clear();
                return -1L;
            }
            bufferedSink.write(d);
            if (bl) {
                l2 += l3;
            } else {
                ((RequestBody)object).writeTo(bufferedSink);
            }
            bufferedSink.write(d);
        }
        bufferedSink.write(e);
        bufferedSink.write(this.f);
        bufferedSink.write(e);
        bufferedSink.write(d);
        if (bl) {
            l2 += buffer.size();
            buffer.clear();
        }
        return l2;
    }

    static StringBuilder a(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("%0A");
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append("%0D");
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    static {
        MediaType.get("multipart/alternative");
        MediaType.get("multipart/digest");
        MediaType.get("multipart/parallel");
        b = MediaType.get("multipart/form-data");
        c = new byte[]{58, 32};
        d = new byte[]{13, 10};
        e = new byte[]{45, 45};
    }

    public static final class Builder {
        private final ByteString a;
        private MediaType b = a;
        private final List<Part> c = new ArrayList<Part>();

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string) {
            this.a = ByteString.encodeUtf8(string);
        }

        public final Builder setType(MediaType mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("type == null");
            }
            if (!mediaType.type().equals("multipart")) {
                throw new IllegalArgumentException("multipart != " + mediaType);
            }
            this.b = mediaType;
            return this;
        }

        public final Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public final Builder addPart(Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public final Builder addFormDataPart(String string, String string2) {
            return this.addPart(Part.createFormData(string, string2));
        }

        public final Builder addFormDataPart(String string, String string2, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string, string2, requestBody));
        }

        public final Builder addPart(Part part) {
            if (part == null) {
                throw new NullPointerException("part == null");
            }
            this.c.add(part);
            return this;
        }

        public final MultipartBody build() {
            if (this.c.isEmpty()) {
                throw new IllegalStateException("Multipart body must have at least one part.");
            }
            return new MultipartBody(this.a, this.b, this.c);
        }
    }

    public static final class Part {
        final Headers a;
        final RequestBody b;

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part create(Headers headers, RequestBody requestBody) {
            if (requestBody == null) {
                throw new NullPointerException("body == null");
            }
            if (headers != null && headers.get("Content-Type") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Type");
            }
            if (headers != null && headers.get("Content-Length") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Length");
            }
            return new Part(headers, requestBody);
        }

        public static Part createFormData(String string, String string2) {
            return Part.createFormData(string, null, RequestBody.create(null, string2));
        }

        public static Part createFormData(String string, String string2, RequestBody requestBody) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            StringBuilder stringBuilder = new StringBuilder("form-data; name=");
            MultipartBody.a(stringBuilder, string);
            if (string2 != null) {
                stringBuilder.append("; filename=");
                MultipartBody.a(stringBuilder, string2);
            }
            return Part.create(Headers.of("Content-Disposition", stringBuilder.toString()), requestBody);
        }

        private Part(Headers headers, RequestBody requestBody) {
            this.a = headers;
            this.b = requestBody;
        }

        public final Headers headers() {
            return this.a;
        }

        public final RequestBody body() {
            return this.b;
        }
    }
}

