/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final Pattern i = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern j = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    public static final MediaType a = MediaType.parse("image/png");
    public static final MediaType b = MediaType.parse("image/jpg");
    public static final MediaType c = MediaType.parse("image/gif");
    public static final MediaType d = MediaType.parse("text/plain");
    public static final MediaType e;
    public static final MediaType f;
    public static final MediaType g;
    public static final MediaType h;
    private final String k;
    private final String l;
    private final String m;
    private final String n;

    private MediaType(String string, String string2, String string3, String string4) {
        this.k = string;
        this.l = string2;
        this.m = string3;
        this.n = string4;
    }

    public static MediaType get(String string) {
        Matcher matcher = i.matcher(string);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + string + '\"');
        }
        String string2 = matcher.group(1).toLowerCase(Locale.US);
        String string3 = matcher.group(2).toLowerCase(Locale.US);
        String string4 = null;
        Matcher matcher2 = j.matcher(string);
        int n2 = matcher.end();
        while (n2 < string.length()) {
            matcher2.region(n2, string.length());
            if (!matcher2.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + string.substring(n2) + "\" for: \"" + string + '\"');
            }
            String string5 = matcher2.group(1);
            if (string5 != null && string5.equalsIgnoreCase("charset")) {
                string5 = matcher2.group(2);
                string5 = string5 != null ? (string5.startsWith("'") && string5.endsWith("'") && string5.length() > 2 ? string5.substring(1, string5.length() - 1) : string5) : matcher2.group(3);
                if (string4 != null && !string5.equalsIgnoreCase(string4)) {
                    throw new IllegalArgumentException("Multiple charsets defined: \"" + string4 + "\" and: \"" + string5 + "\" for: \"" + string + '\"');
                }
                string4 = string5;
            }
            n2 = matcher2.end();
        }
        return new MediaType(string, string2, string3, string4);
    }

    public static MediaType parse(String string) {
        try {
            return MediaType.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final String type() {
        return this.l;
    }

    public final String subtype() {
        return this.m;
    }

    public final Charset charset() {
        return this.charset(null);
    }

    public final Charset charset(Charset charset) {
        try {
            if (this.n != null) {
                return Charset.forName(this.n);
            }
            return charset;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charset;
        }
    }

    public final String toString() {
        return this.k;
    }

    public final boolean equals(Object object) {
        return object instanceof MediaType && ((MediaType)object).k.equals(this.k);
    }

    public final int hashCode() {
        return this.k.hashCode();
    }

    static {
        MediaType.parse("text/html");
        MediaType.parse("text/xml");
        e = MediaType.parse("application/json");
        f = MediaType.parse("application/x-www-form-urlencoded");
        g = MediaType.parse("multipart/form-data");
        h = MediaType.parse("application/octet-stream");
    }
}

