/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.OkHttpLogger;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class HttpUrl {
    private static final char[] d = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final String a;
    private final String e;
    private final String f;
    final String b;
    final int c;
    private final List<String> g;
    private final List<String> h;
    private final String i;
    private final String j;

    HttpUrl(Builder builder) {
        this.a = builder.a;
        this.e = HttpUrl.a(builder.b, false);
        this.f = HttpUrl.a(builder.c, false);
        this.b = builder.d;
        this.c = builder.a();
        this.g = HttpUrl.a(builder.f, false);
        this.h = builder.g != null ? HttpUrl.a(builder.g, true) : null;
        this.i = builder.h != null ? HttpUrl.a(builder.h, false) : null;
        this.j = builder.toString();
    }

    public final URL url() {
        try {
            return new URL(this.j);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public final URI uri() {
        String string;
        int n2;
        Object object = this.newBuilder();
        int n3 = ((Builder)object).f.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = ((Builder)object).f.get(n2);
            ((Builder)object).f.set(n2, HttpUrl.a(string, "[]", true, true, false, true));
        }
        if (((Builder)object).g != null) {
            n3 = ((Builder)object).g.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = ((Builder)object).g.get(n2);
                if (string == null) continue;
                ((Builder)object).g.set(n2, HttpUrl.a(string, "\\^`{|}", true, true, true, true));
            }
        }
        if (((Builder)object).h != null) {
            ((Builder)object).h = HttpUrl.a(((Builder)object).h, " \"#<>\\^`{|}", true, true, false, false);
        }
        object = ((Builder)object).toString();
        try {
            return new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                object = ((String)object).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", "");
                return URI.create((String)object);
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public final String scheme() {
        return this.a;
    }

    public final boolean isHttps() {
        return this.a.equals("https");
    }

    public final String encodedUsername() {
        if (this.e.isEmpty()) {
            return "";
        }
        int n2 = this.a.length() + 3;
        int n3 = Util.delimiterOffset(this.j, n2, this.j.length(), ":@");
        return this.j.substring(n2, n3);
    }

    public final String username() {
        return this.e;
    }

    public final String encodedPassword() {
        if (this.f.isEmpty()) {
            return "";
        }
        int n2 = this.j.indexOf(58, this.a.length() + 3) + 1;
        int n3 = this.j.indexOf(64);
        return this.j.substring(n2, n3);
    }

    public final String password() {
        return this.f;
    }

    public final String host() {
        return this.b;
    }

    public final int port() {
        return this.c;
    }

    public static int defaultPort(String string) {
        if (string.equals("http")) {
            return 80;
        }
        if (string.equals("https")) {
            return 443;
        }
        return -1;
    }

    public final int pathSize() {
        return this.g.size();
    }

    public final String encodedPath() {
        int n2 = this.j.indexOf(47, this.a.length() + 3);
        int n3 = Util.delimiterOffset(this.j, n2, this.j.length(), "?#");
        return this.j.substring(n2, n3);
    }

    static void a(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i2));
        }
    }

    public final List<String> encodedPathSegments() {
        int n2 = this.j.indexOf(47, this.a.length() + 3);
        int n3 = Util.delimiterOffset(this.j, n2, this.j.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            int n4 = Util.delimiterOffset(this.j, ++n2, n3, '/');
            arrayList.add(this.j.substring(n2, n4));
            n2 = n4;
        }
        return arrayList;
    }

    public final List<String> pathSegments() {
        return this.g;
    }

    public final String encodedQuery() {
        if (this.h == null) {
            return null;
        }
        int n2 = this.j.indexOf(63) + 1;
        int n3 = Util.delimiterOffset(this.j, n2, this.j.length(), '#');
        return this.j.substring(n2, n3);
    }

    static void b(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = list.get(i2);
            String string2 = list.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string.length()) {
            int n3;
            int n4 = string.indexOf(38, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n4) {
                arrayList.add(string.substring(n2, n4));
                arrayList.add(null);
            } else {
                arrayList.add(string.substring(n2, n3));
                arrayList.add(string.substring(n3 + 1, n4));
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    public final String query() {
        if (this.h == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.b(stringBuilder, this.h);
        return stringBuilder.toString();
    }

    public final int querySize() {
        if (this.h != null) {
            return this.h.size() / 2;
        }
        return 0;
    }

    public final String queryParameter(String string) {
        if (this.h == null) {
            return null;
        }
        int n2 = this.h.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.h.get(i2))) continue;
            return this.h.get(i2 + 1);
        }
        return null;
    }

    public final Set<String> queryParameterNames() {
        if (this.h == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = this.h.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet.add(this.h.get(i2));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public final List<String> queryParameterValues(String string) {
        if (this.h == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.h.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.h.get(i2))) continue;
            arrayList.add(this.h.get(i2 + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final String queryParameterName(int n2) {
        if (this.h == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.h.get(n2 << 1);
    }

    public final String queryParameterValue(int n2) {
        if (this.h == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.h.get((n2 << 1) + 1);
    }

    public final String encodedFragment() {
        if (this.i == null) {
            return null;
        }
        int n2 = this.j.indexOf(35) + 1;
        return this.j.substring(n2);
    }

    public final String fragment() {
        return this.i;
    }

    public final String redact() {
        return this.newBuilder("/...").username("").password("").build().toString();
    }

    public final HttpUrl resolve(String object) {
        if ((object = this.newBuilder((String)object)) != null) {
            return ((Builder)object).build();
        }
        return null;
    }

    public final Builder newBuilder() {
        Builder builder = new Builder();
        new Builder().a = this.a;
        builder.b = this.encodedUsername();
        builder.c = this.encodedPassword();
        builder.d = this.b;
        builder.e = this.c != HttpUrl.defaultPort(this.a) ? this.c : -1;
        builder.f.clear();
        builder.f.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.h = this.encodedFragment();
        return builder;
    }

    public final Builder newBuilder(String string) {
        try {
            return new Builder().a(this, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static HttpUrl parse(String string) {
        try {
            return HttpUrl.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OkHttpLogger.log("url parse err:" + string, illegalArgumentException);
            return null;
        }
    }

    public static HttpUrl get(String string) {
        return new Builder().a(null, string).build();
    }

    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public final boolean equals(Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).j.equals(this.j);
    }

    public final int hashCode() {
        return this.j.hashCode();
    }

    public final String toString() {
        return this.j;
    }

    static String a(String string, boolean bl) {
        return HttpUrl.a(string, 0, string.length(), bl);
    }

    private static List<String> a(List<String> list, boolean bl) {
        int n2 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            arrayList.add(string != null ? HttpUrl.a(string, bl) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String a(String object, int n2, int n3, boolean n4) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = ((String)object).charAt(i2);
            if (c2 != '%' && (c2 != '+' || n4 == 0)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8((String)object, n2, i2);
            int n5 = i2;
            i2 = n4;
            n4 = n3;
            n3 = n5;
            String string = object;
            object = buffer;
            for (int i3 = n3; i3 < n4; i3 += Character.charCount(n3)) {
                n3 = string.codePointAt(i3);
                if (n3 == 37 && i3 + 2 < n4) {
                    int n6 = Util.decodeHexDigit(string.charAt(i3 + 1));
                    int n7 = Util.decodeHexDigit(string.charAt(i3 + 2));
                    if (n6 != -1 && n7 != -1) {
                        ((Buffer)object).writeByte((n6 << 4) + n7);
                        i3 += 2;
                        continue;
                    }
                } else if (n3 == 43 && i2 != 0) {
                    ((Buffer)object).writeByte(32);
                    continue;
                }
                ((Buffer)object).writeUtf8CodePoint(n3);
            }
            return buffer.readUtf8();
        }
        return ((String)object).substring(n2, n3);
    }

    private static boolean a(String string, int n2, int n3) {
        return n2 + 2 < n3 && string.charAt(n2) == '%' && Util.decodeHexDigit(string.charAt(n2 + 1)) != -1 && Util.decodeHexDigit(string.charAt(n2 + 2)) != -1;
    }

    static String a(String object, int n2, int n3, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = ((String)object).codePointAt(i2);
            if (!(n4 < 32 || n4 == 127 || n4 >= 128 && bl4 || string.indexOf(n4) != -1 || n4 == 37 && (!bl || bl2 && !HttpUrl.a((String)object, i2, n3))) && (n4 != 43 || !bl3)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8((String)object, n2, i2);
            Charset charset2 = charset;
            boolean bl5 = bl4;
            bl4 = bl3;
            bl3 = bl2;
            bl2 = bl;
            String string2 = string;
            int n5 = n3;
            n3 = i2;
            String string3 = object;
            object = buffer;
            Buffer buffer2 = null;
            for (int i3 = n3; i3 < n5; i3 += Character.charCount(n3)) {
                n3 = string3.codePointAt(i3);
                if (bl2 && (n3 == 9 || n3 == 10 || n3 == 12 || n3 == 13)) continue;
                if (n3 == 43 && bl4) {
                    ((Buffer)object).writeUtf8(bl2 ? "+" : "%2B");
                    continue;
                }
                if (n3 < 32 || n3 == 127 || n3 >= 128 && bl5 || string2.indexOf(n3) != -1 || n3 == 37 && (!bl2 || bl3 && !HttpUrl.a(string3, i3, n5))) {
                    if (buffer2 == null) {
                        buffer2 = new Buffer();
                    }
                    if (charset2 == null || charset2.equals(Util.d)) {
                        buffer2.writeUtf8CodePoint(n3);
                    } else {
                        buffer2.writeString(string3, i3, i3 + Character.charCount(n3), charset2);
                    }
                    while (!buffer2.exhausted()) {
                        int n6 = buffer2.readByte() & 0xFF;
                        ((Buffer)object).writeByte(37);
                        ((Buffer)object).writeByte(d[n6 >> 4 & 0xF]);
                        ((Buffer)object).writeByte(d[n6 & 0xF]);
                    }
                    continue;
                }
                ((Buffer)object).writeUtf8CodePoint(n3);
            }
            return buffer.readUtf8();
        }
        return ((String)object).substring(n2, n3);
    }

    static String a(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        return HttpUrl.a(string, 0, string.length(), string2, bl, false, true, true, charset);
    }

    static String a(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return HttpUrl.a(string, 0, string.length(), string2, bl, bl2, bl3, bl4, null);
    }

    public static final class Builder {
        String a;
        String b = "";
        String c = "";
        String d;
        int e = -1;
        final List<String> f = new ArrayList<String>();
        List<String> g;
        String h;

        public Builder() {
            this.f.add("");
        }

        public final Builder scheme(String string) {
            if (string == null) {
                throw new NullPointerException("scheme == null");
            }
            if (string.equalsIgnoreCase("http")) {
                this.a = "http";
            } else if (string.equalsIgnoreCase("https")) {
                this.a = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + string);
            }
            return this;
        }

        public final Builder username(String string) {
            if (string == null) {
                throw new NullPointerException("username == null");
            }
            this.b = HttpUrl.a(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public final Builder encodedUsername(String string) {
            if (string == null) {
                throw new NullPointerException("encodedUsername == null");
            }
            this.b = HttpUrl.a(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public final Builder password(String string) {
            if (string == null) {
                throw new NullPointerException("password == null");
            }
            this.c = HttpUrl.a(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public final Builder encodedPassword(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPassword == null");
            }
            this.c = HttpUrl.a(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public final Builder host(String string) {
            if (string == null) {
                throw new NullPointerException("host == null");
            }
            String string2 = Builder.d(string, 0, string.length());
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected host: " + string);
            }
            this.d = string2;
            return this;
        }

        public final Builder port(int n2) {
            if (n2 <= 0 || n2 > 65535) {
                throw new IllegalArgumentException("unexpected port: " + n2);
            }
            this.e = n2;
            return this;
        }

        final int a() {
            if (this.e != -1) {
                return this.e;
            }
            return HttpUrl.defaultPort(this.a);
        }

        public final Builder addPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            this.a(string, 0, string.length(), false, false);
            return this;
        }

        public final Builder addPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegments == null");
            }
            return this.a(string, false);
        }

        public final Builder addEncodedPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            this.a(string, 0, string.length(), false, true);
            return this;
        }

        public final Builder addEncodedPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegments == null");
            }
            return this.a(string, true);
        }

        private Builder a(String string, boolean bl) {
            int n2;
            int n3 = 0;
            do {
                boolean bl2 = (n2 = Util.delimiterOffset(string, n3, string.length(), "/\\")) < string.length();
                this.a(string, n3, n2, bl2, bl);
            } while ((n3 = n2 + 1) <= string.length());
            return this;
        }

        public final Builder setPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            String string2 = HttpUrl.a(string, 0, string.length(), " \"<>^`{}|/\\?#", false, false, false, true, null);
            if (Builder.b(string2) || Builder.c(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            this.f.set(n2, string2);
            return this;
        }

        public final Builder setEncodedPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            String string2 = HttpUrl.a(string, 0, string.length(), " \"<>^`{}|/\\?#", true, false, false, true, null);
            this.f.set(n2, string2);
            if (Builder.b(string2) || Builder.c(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            return this;
        }

        public final Builder removePathSegment(int n2) {
            this.f.remove(n2);
            if (this.f.isEmpty()) {
                this.f.add("");
            }
            return this;
        }

        public final Builder encodedPath(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPath == null");
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + string);
            }
            this.a(string, 0, string.length());
            return this;
        }

        public final Builder query(String string) {
            this.g = string != null ? HttpUrl.a(HttpUrl.a(string, " \"'<>#", false, false, true, true)) : null;
            return this;
        }

        public final Builder encodedQuery(String string) {
            this.g = string != null ? HttpUrl.a(HttpUrl.a(string, " \"'<>#", true, false, true, true)) : null;
            return this;
        }

        public final Builder addQueryParameter(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.g == null) {
                this.g = new ArrayList<String>();
            }
            this.g.add(HttpUrl.a(string, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true));
            this.g.add(string2 != null ? HttpUrl.a(string2, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true) : null);
            return this;
        }

        public final Builder addEncodedQueryParameter(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.g == null) {
                this.g = new ArrayList<String>();
            }
            this.g.add(HttpUrl.a(string, " \"'<>#&=", true, false, true, true));
            this.g.add(string2 != null ? HttpUrl.a(string2, " \"'<>#&=", true, false, true, true) : null);
            return this;
        }

        public final Builder setQueryParameter(String string, String string2) {
            this.removeAllQueryParameters(string);
            this.addQueryParameter(string, string2);
            return this;
        }

        public final Builder setEncodedQueryParameter(String string, String string2) {
            this.removeAllEncodedQueryParameters(string);
            this.addEncodedQueryParameter(string, string2);
            return this;
        }

        public final Builder removeAllQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.g == null) {
                return this;
            }
            string = HttpUrl.a(string, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, true);
            this.a(string);
            return this;
        }

        public final Builder removeAllEncodedQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.g == null) {
                return this;
            }
            this.a(HttpUrl.a(string, " \"'<>#&=", true, false, true, true));
            return this;
        }

        private void a(String string) {
            for (int i2 = this.g.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string.equals(this.g.get(i2))) continue;
                this.g.remove(i2 + 1);
                this.g.remove(i2);
                if (!this.g.isEmpty()) continue;
                this.g = null;
                return;
            }
        }

        public final Builder fragment(String string) {
            this.h = string != null ? HttpUrl.a(string, "", false, false, false, false) : null;
            return this;
        }

        public final Builder encodedFragment(String string) {
            this.h = string != null ? HttpUrl.a(string, "", true, false, false, false) : null;
            return this;
        }

        public final HttpUrl build() {
            if (this.a == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.d == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.a != null) {
                stringBuilder.append(this.a);
                stringBuilder.append("://");
            } else {
                stringBuilder.append("//");
            }
            if (!this.b.isEmpty() || !this.c.isEmpty()) {
                stringBuilder.append(this.b);
                if (!this.c.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.c);
                }
                stringBuilder.append('@');
            }
            if (this.d != null) {
                if (this.d.indexOf(58) != -1) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.d);
                    stringBuilder.append(']');
                } else {
                    stringBuilder.append(this.d);
                }
            }
            if (this.e != -1 || this.a != null) {
                int n2 = this.a();
                if (this.a == null || n2 != HttpUrl.defaultPort(this.a)) {
                    stringBuilder.append(':');
                    stringBuilder.append(n2);
                }
            }
            HttpUrl.a(stringBuilder, this.f);
            if (this.g != null) {
                stringBuilder.append('?');
                HttpUrl.b(stringBuilder, this.g);
            }
            if (this.h != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.h);
            }
            return stringBuilder.toString();
        }

        /*
         * Unable to fully structure code
         */
        final Builder a(HttpUrl var1_1, String var2_4) {
            block27: {
                block26: {
                    var3_5 = Util.skipLeadingAsciiWhitespace(var2_4, 0, var2_4.length());
                    var7_8 = var4_7 = Util.skipTrailingAsciiWhitespace(var2_4, var3_5, var2_4.length());
                    var6_9 = var3_5;
                    var5_10 = var2_4;
                    if (var7_8 - var6_9 < 2) ** GOTO lbl18
                    var8_12 = var5_10.charAt(var6_9);
                    if (!(var8_12 >= 'a' && var8_12 <= 'z' || var8_12 >= 'A' && var8_12 <= 'Z')) {
                        v0 = -1;
                    } else {
                        ++var6_9;
                        while (var6_9 < var7_8) {
                            var8_12 = var5_10.charAt(var6_9);
                            if (!(var8_12 >= 'a' && var8_12 <= 'z' || var8_12 >= 'A' && var8_12 <= 'Z' || var8_12 >= '0' && var8_12 <= '9' || var8_12 == '+' || var8_12 == '-' || var8_12 == '.')) {
                                v0 = var8_12 == ':' ? var6_9 : -1;
                                break block26;
                            }
                            ++var6_9;
                        }
lbl18:
                        // 2 sources

                        v0 = var5_11 = -1;
                    }
                }
                if (v0 == -1) ** GOTO lbl30
                if (var2_4.regionMatches(true, var3_5, "https:", 0, 6)) {
                    this.a = "https";
                    var3_5 += 6;
                } else if (var2_4.regionMatches(true, var3_5, "http:", 0, 5)) {
                    this.a = "http";
                    var3_5 += 5;
                } else {
                    throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but was '" + var2_4.substring(0, var5_11) + "'");
lbl30:
                    // 1 sources

                    if (var1_1 != null) {
                        this.a = var1_1.a;
                    } else {
                        throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
                    }
                }
                var5_11 = 0;
                var6_9 = 0;
                var7_8 = Builder.b(var2_4, var3_5, var4_7);
                if (var7_8 >= 2 || var1_1 == null || !var1_1.a.equals(this.a)) {
                    var3_5 += var7_8;
                    while (true) {
                        var7_8 = (var1_2 = Util.delimiterOffset(var2_4, var3_5, var4_7, "@/\\?#")) != var4_7 ? (int)var2_4.charAt(var1_2) : -1;
                        switch (var7_8) {
                            case 64: {
                                if (var6_9 == 0) {
                                    var7_8 = Util.delimiterOffset(var2_4, var3_5, var1_2, ':');
                                    var3_6 = HttpUrl.a(var2_4, var3_5, var7_8, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    v1 = this.b = var5_11 != 0 ? this.b + "%40" + var3_6 : var3_6;
                                    if (var7_8 != var1_2) {
                                        var6_9 = 1;
                                        this.c = HttpUrl.a(var2_4, var7_8 + 1, var1_2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    }
                                    var5_11 = 1;
                                } else {
                                    this.c = this.c + "%40" + HttpUrl.a(var2_4, var3_5, var1_2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                var3_5 = var1_2 + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                var7_8 = Builder.c(var2_4, var3_5, var1_2);
                                if (var7_8 + 1 < var1_2) {
                                    this.d = Builder.d(var2_4, var3_5, var7_8);
                                    this.e = Builder.e(var2_4, var7_8 + 1, var1_2);
                                    if (this.e == -1) {
                                        throw new IllegalArgumentException("Invalid URL port: \"" + var2_4.substring(var7_8 + 1, var1_2) + '\"');
                                    }
                                } else {
                                    this.d = Builder.d(var2_4, var3_5, var7_8);
                                    this.e = HttpUrl.defaultPort(this.a);
                                }
                                if (this.d == null) {
                                    throw new IllegalArgumentException("Invalid URL host: \"" + var2_4.substring(var3_5, var7_8) + '\"');
                                }
                                var3_5 = var1_2;
                                break block27;
                            }
                        }
                    }
                }
                this.b = var1_1.encodedUsername();
                this.c = var1_1.encodedPassword();
                this.d = var1_1.b;
                this.e = var1_1.c;
                this.f.clear();
                this.f.addAll(var1_1.encodedPathSegments());
                if (var3_5 == var4_7 || var2_4.charAt(var3_5) == '#') {
                    this.encodedQuery(var1_1.encodedQuery());
                }
            }
            var1_3 = Util.delimiterOffset(var2_4, var3_5, var4_7, "?#");
            this.a(var2_4, var3_5, var1_3);
            var3_5 = var1_3;
            if (var3_5 < var4_7 && var2_4.charAt(var3_5) == '?') {
                var7_8 = Util.delimiterOffset(var2_4, var3_5, var4_7, '#');
                this.g = HttpUrl.a(HttpUrl.a(var2_4, var3_5 + 1, var7_8, " \"'<>#", true, false, true, true, null));
                var3_5 = var7_8;
            }
            if (var3_5 < var4_7 && var2_4.charAt(var3_5) == '#') {
                this.h = HttpUrl.a(var2_4, var3_5 + 1, var4_7, "", true, false, false, false, null);
            }
            return this;
        }

        private void a(String string, int n2, int n3) {
            if (n2 == n3) {
                return;
            }
            int n4 = string.charAt(n2);
            if (n4 == 47 || n4 == 92) {
                this.f.clear();
                this.f.add("");
                ++n2;
            } else {
                this.f.set(this.f.size() - 1, "");
            }
            while (n2 < n3) {
                n4 = Util.delimiterOffset(string, n2, n3, "/\\");
                boolean bl = n4 < n3;
                this.a(string, n2, n4, bl, true);
                n2 = n4;
                if (!bl) continue;
                ++n2;
            }
        }

        private void a(String object, int n2, int n3, boolean bl, boolean bl2) {
            if (Builder.b((String)(object = HttpUrl.a((String)object, n2, n3, " \"<>^`{}|/\\?#", bl2, false, false, true, null)))) {
                return;
            }
            if (Builder.c((String)object)) {
                object = this;
                String string = ((Builder)object).f.remove(((Builder)object).f.size() - 1);
                if (string.isEmpty() && !((Builder)object).f.isEmpty()) {
                    ((Builder)object).f.set(((Builder)object).f.size() - 1, "");
                    return;
                }
                ((Builder)object).f.add("");
                return;
            }
            if (this.f.get(this.f.size() - 1).isEmpty()) {
                this.f.set(this.f.size() - 1, (String)object);
            } else {
                this.f.add((String)object);
            }
            if (bl) {
                this.f.add("");
            }
        }

        private static boolean b(String string) {
            return string.equals(".") || string.equalsIgnoreCase("%2e");
        }

        private static boolean c(String string) {
            return string.equals("..") || string.equalsIgnoreCase("%2e.") || string.equalsIgnoreCase(".%2e") || string.equalsIgnoreCase("%2e%2e");
        }

        private static int b(String string, int n2, int n3) {
            char c2;
            int n4 = 0;
            while (n2 < n3 && ((c2 = string.charAt(n2)) == '\\' || c2 == '/')) {
                ++n4;
                ++n2;
            }
            return n4;
        }

        private static int c(String string, int n2, int n3) {
            while (n2 < n3) {
                switch (string.charAt(n2)) {
                    case '[': {
                        while (++n2 < n3 && string.charAt(n2) != ']') {
                        }
                        break;
                    }
                    case ':': {
                        return n2;
                    }
                }
                ++n2;
            }
            return n3;
        }

        private static String d(String string, int n2, int n3) {
            string = HttpUrl.a(string, n2, n3, false);
            return Util.canonicalizeHost(string);
        }

        private static int e(String string, int n2, int n3) {
            try {
                string = HttpUrl.a(string, n2, n3, "", false, false, false, true, null);
                int n4 = Integer.parseInt(string);
                if (n4 > 0 && n4 <= 65535) {
                    return n4;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }
}

