/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.CipherSuite;
import com.tencent.cloud.huiyansdkface.okhttp3.TlsVersion;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class Handshake {
    private final TlsVersion a;
    private final CipherSuite b;
    private final List<Certificate> c;
    private final List<Certificate> d;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.a = tlsVersion;
        this.b = cipherSuite;
        this.c = list;
        this.d = list2;
    }

    public static Handshake get(SSLSession object) throws IOException {
        Object object2;
        Object object3 = object.getCipherSuite();
        if (object3 == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        if ("SSL_NULL_WITH_NULL_NULL".equals(object3)) {
            throw new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
        }
        object3 = CipherSuite.forJavaName((String)object3);
        Object object4 = object.getProtocol();
        if (object4 == null) {
            throw new IllegalStateException("tlsVersion == null");
        }
        if ("NONE".equals(object4)) {
            throw new IOException("tlsVersion == NONE");
        }
        object4 = TlsVersion.forJavaName(object4);
        try {
            object2 = object.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            object2 = null;
        }
        object2 = object2 != null ? Util.immutableList(object2) : Collections.emptyList();
        object = object.getLocalCertificates();
        object = object != null ? Util.immutableList(object) : Collections.emptyList();
        return new Handshake((TlsVersion)((Object)object4), (CipherSuite)object3, (List<Certificate>)object2, (List<Certificate>)object);
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (tlsVersion == null) {
            throw new NullPointerException("tlsVersion == null");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("cipherSuite == null");
        }
        return new Handshake(tlsVersion, cipherSuite, Util.immutableList(list), Util.immutableList(list2));
    }

    public final TlsVersion tlsVersion() {
        return this.a;
    }

    public final CipherSuite cipherSuite() {
        return this.b;
    }

    public final List<Certificate> peerCertificates() {
        return this.c;
    }

    public final Principal peerPrincipal() {
        if (!this.c.isEmpty()) {
            return ((X509Certificate)this.c.get(0)).getSubjectX500Principal();
        }
        return null;
    }

    public final List<Certificate> localCertificates() {
        return this.d;
    }

    public final Principal localPrincipal() {
        if (!this.d.isEmpty()) {
            return ((X509Certificate)this.d.get(0)).getSubjectX500Principal();
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        object = (Handshake)object;
        return this.a.equals((Object)((Handshake)object).a) && this.b.equals(((Handshake)object).b) && this.c.equals(((Handshake)object).c) && this.d.equals(((Handshake)object).d);
    }

    public final int hashCode() {
        int n2 = 527 + this.a.hashCode();
        n2 = n2 * 31 + this.b.hashCode();
        n2 = n2 * 31 + this.c.hashCode();
        n2 = n2 * 31 + this.d.hashCode();
        return n2;
    }
}

