/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Cookie {
    private static final Pattern a = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern b = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern c = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern d = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String e;
    private final String f;
    private final long g;
    private final String h;
    private final String i;
    private final boolean j;
    private final boolean k;
    private final boolean l;
    private final boolean m;

    private Cookie(String string, String string2, long l2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.e = string;
        this.f = string2;
        this.g = l2;
        this.h = string3;
        this.i = string4;
        this.j = bl;
        this.k = bl2;
        this.m = bl3;
        this.l = bl4;
    }

    Cookie(Builder builder) {
        if (builder.a == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (builder.b == null) {
            throw new NullPointerException("builder.value == null");
        }
        if (builder.d == null) {
            throw new NullPointerException("builder.domain == null");
        }
        this.e = builder.a;
        this.f = builder.b;
        this.g = builder.c;
        this.h = builder.d;
        this.i = builder.e;
        this.j = builder.f;
        this.k = builder.g;
        this.l = builder.h;
        this.m = builder.i;
    }

    public final String name() {
        return this.e;
    }

    public final String value() {
        return this.f;
    }

    public final boolean persistent() {
        return this.l;
    }

    public final long expiresAt() {
        return this.g;
    }

    public final boolean hostOnly() {
        return this.m;
    }

    public final String domain() {
        return this.h;
    }

    public final String path() {
        return this.i;
    }

    public final boolean httpOnly() {
        return this.k;
    }

    public final boolean secure() {
        return this.j;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(HttpUrl httpUrl) {
        boolean bl;
        boolean bl2 = this.m ? httpUrl.host().equals(this.h) : Cookie.a(httpUrl.host(), this.h);
        if (!bl2) {
            return false;
        }
        String string = this.i;
        Object object = httpUrl;
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string)) {
            bl = true;
        } else {
            if (!((String)object).startsWith(string)) return false;
            if (string.endsWith("/")) {
                bl = true;
            } else {
                if (((String)object).charAt(string.length()) != '/') return false;
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        if (!this.j) return true;
        if (httpUrl.isHttps()) return true;
        return false;
    }

    private static boolean a(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(string2) && string.charAt(string.length() - string2.length() - 1) == '.' && !Util.verifyAsIpAddress(string);
    }

    public static Cookie parse(HttpUrl httpUrl, String string) {
        return Cookie.a(System.currentTimeMillis(), httpUrl, string);
    }

    private static Cookie a(long l2, HttpUrl httpUrl, String string) {
        long l3;
        int n2 = string.length();
        int n3 = Util.delimiterOffset(string, 0, n2, ';');
        int n4 = Util.delimiterOffset(string, 0, n3, '=');
        if (n4 == n3) {
            return null;
        }
        String string2 = Util.trimSubstring(string, 0, n4);
        if (string2.isEmpty() || Util.indexOfControlOrNonAscii(string2) != -1) {
            return null;
        }
        String string3 = Util.trimSubstring(string, n4 + 1, n3);
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        long l4 = 253402300799999L;
        long l5 = -1L;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        ++n3;
        while (n3 < n2) {
            String string6;
            int n5 = Util.delimiterOffset(string, n3, n2, ';');
            int n6 = Util.delimiterOffset(string, n3, n5, '=');
            String string7 = Util.trimSubstring(string, n3, n6);
            String string8 = string6 = n6 < n5 ? Util.trimSubstring(string, n6 + 1, n5) : "";
            if (string7.equalsIgnoreCase("expires")) {
                try {
                    int n7 = string6.length();
                    int n8 = 0;
                    string7 = string6;
                    n8 = Cookie.a(string7, 0, n7, false);
                    n6 = -1;
                    int n9 = -1;
                    int n10 = -1;
                    int n11 = -1;
                    int n12 = -1;
                    int n13 = -1;
                    Matcher matcher = d.matcher(string7);
                    while (n8 < n7) {
                        int n14 = Cookie.a(string7, n8 + 1, n7, true);
                        matcher.region(n8, n14);
                        if (n6 == -1 && matcher.usePattern(d).matches()) {
                            n6 = Integer.parseInt(matcher.group(1));
                            n9 = Integer.parseInt(matcher.group(2));
                            n10 = Integer.parseInt(matcher.group(3));
                        } else if (n11 == -1 && matcher.usePattern(c).matches()) {
                            n11 = Integer.parseInt(matcher.group(1));
                        } else if (n12 == -1 && matcher.usePattern(b).matches()) {
                            String string9 = matcher.group(1).toLowerCase(Locale.US);
                            n12 = b.pattern().indexOf(string9) / 4;
                        } else if (n13 == -1 && matcher.usePattern(a).matches()) {
                            n13 = Integer.parseInt(matcher.group(1));
                        }
                        n8 = Cookie.a(string7, n14 + 1, n7, false);
                    }
                    if (n13 >= 70 && n13 <= 99) {
                        n13 += 1900;
                    }
                    if (n13 >= 0 && n13 <= 69) {
                        n13 += 2000;
                    }
                    if (n13 < 1601) {
                        throw new IllegalArgumentException();
                    }
                    if (n12 == -1) {
                        throw new IllegalArgumentException();
                    }
                    if (n11 <= 0 || n11 > 31) {
                        throw new IllegalArgumentException();
                    }
                    if (n6 < 0 || n6 > 23) {
                        throw new IllegalArgumentException();
                    }
                    if (n9 < 0 || n9 > 59) {
                        throw new IllegalArgumentException();
                    }
                    if (n10 < 0 || n10 > 59) {
                        throw new IllegalArgumentException();
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.f);
                    gregorianCalendar.setLenient(false);
                    gregorianCalendar.set(1, n13);
                    gregorianCalendar.set(2, n12 - 1);
                    gregorianCalendar.set(5, n11);
                    gregorianCalendar.set(11, n6);
                    gregorianCalendar.set(12, n9);
                    gregorianCalendar.set(13, n10);
                    gregorianCalendar.set(14, 0);
                    l4 = gregorianCalendar.getTimeInMillis();
                    bl4 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("max-age")) {
                try {
                    l5 = Cookie.a(string6);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string7.equalsIgnoreCase("domain")) {
                try {
                    string7 = string6;
                    if (string7.endsWith(".")) {
                        throw new IllegalArgumentException();
                    }
                    if (string7.startsWith(".")) {
                        string7 = string7.substring(1);
                    }
                    if ((string6 = Util.canonicalizeHost(string7)) == null) {
                        throw new IllegalArgumentException();
                    }
                    string4 = string6;
                    bl3 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("path")) {
                string5 = string6;
            } else if (string7.equalsIgnoreCase("secure")) {
                bl = true;
            } else if (string7.equalsIgnoreCase("httponly")) {
                bl2 = true;
            }
            n3 = n5 + 1;
        }
        if (l5 == Long.MIN_VALUE) {
            l4 = Long.MIN_VALUE;
        } else if (l5 != -1L && ((l4 = l2 + (l3 = l5 <= 9223372036854775L ? l5 * 1000L : Long.MAX_VALUE)) < l2 || l4 > 253402300799999L)) {
            l4 = 253402300799999L;
        }
        String string10 = httpUrl.host();
        if (string4 == null) {
            string4 = string10;
        } else if (!Cookie.a(string10, string4)) {
            return null;
        }
        if (string5 == null || !string5.startsWith("/")) {
            String string11 = httpUrl.encodedPath();
            n3 = string11.lastIndexOf(47);
            string5 = n3 != 0 ? string11.substring(0, n3) : "/";
        }
        return new Cookie(string2, string3, l4, string4, string5, bl, bl2, bl3, bl4);
    }

    private static int a(String string, int n2, int n3, boolean bl) {
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            c2 = c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':' ? (char)'\u0001' : '\u0000';
            if (c2 == (!bl ? (char)'\u0001' : '\u0000')) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static long a(String string) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 <= 0L) {
                return Long.MIN_VALUE;
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches("-?\\d+")) {
                if (string.startsWith("-")) {
                    return Long.MIN_VALUE;
                }
                return Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers object) {
        object = ((Headers)object).values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse(httpUrl, (String)object.get(i2));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        if (arrayList != null) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public final String toString() {
        boolean bl = false;
        Cookie cookie = this;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cookie.e);
        stringBuilder.append('=');
        stringBuilder.append(cookie.f);
        if (cookie.l) {
            if (cookie.g == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=").append(HttpDate.format(new Date(cookie.g)));
            }
        }
        if (!cookie.m) {
            stringBuilder.append("; domain=");
            stringBuilder.append(cookie.h);
        }
        stringBuilder.append("; path=").append(cookie.i);
        if (cookie.j) {
            stringBuilder.append("; secure");
        }
        if (cookie.k) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        return ((Cookie)object).e.equals(this.e) && ((Cookie)object).f.equals(this.f) && ((Cookie)object).h.equals(this.h) && ((Cookie)object).i.equals(this.i) && ((Cookie)object).g == this.g && ((Cookie)object).j == this.j && ((Cookie)object).k == this.k && ((Cookie)object).l == this.l && ((Cookie)object).m == this.m;
    }

    public final int hashCode() {
        int n2 = 527 + this.e.hashCode();
        n2 = n2 * 31 + this.f.hashCode();
        n2 = n2 * 31 + this.h.hashCode();
        n2 = n2 * 31 + this.i.hashCode();
        n2 = n2 * 31 + (int)(this.g ^ this.g >>> 32);
        n2 = n2 * 31 + (this.j ? 0 : 1);
        n2 = n2 * 31 + (this.k ? 0 : 1);
        n2 = n2 * 31 + (this.l ? 0 : 1);
        n2 = n2 * 31 + (this.m ? 0 : 1);
        return n2;
    }

    public static final class Builder {
        String a;
        String b;
        long c = 253402300799999L;
        String d;
        String e = "/";
        boolean f;
        boolean g;
        boolean h;
        boolean i;

        public final Builder name(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("name is not trimmed");
            }
            this.a = string;
            return this;
        }

        public final Builder value(String string) {
            if (string == null) {
                throw new NullPointerException("value == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("value is not trimmed");
            }
            this.b = string;
            return this;
        }

        public final Builder expiresAt(long l2) {
            if (l2 <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            if (l2 > 253402300799999L) {
                l2 = 253402300799999L;
            }
            this.c = l2;
            this.h = true;
            return this;
        }

        public final Builder domain(String string) {
            return this.a(string, false);
        }

        public final Builder hostOnlyDomain(String string) {
            return this.a(string, true);
        }

        private Builder a(String string, boolean bl) {
            if (string == null) {
                throw new NullPointerException("domain == null");
            }
            String string2 = Util.canonicalizeHost(string);
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected domain: " + string);
            }
            this.d = string2;
            this.i = bl;
            return this;
        }

        public final Builder path(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("path must start with '/'");
            }
            this.e = string;
            return this;
        }

        public final Builder secure() {
            this.f = true;
            return this;
        }

        public final Builder httpOnly() {
            this.g = true;
            return this;
        }

        public final Cookie build() {
            return new Cookie(this);
        }
    }
}

