/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.Address;
import com.tencent.cloud.huiyansdkface.okhttp3.Route;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RealConnection;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.RouteDatabase;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.connection.StreamAllocation;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final Executor b = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final int c;
    private final long d;
    private final Runnable e = new Runnable(this){
        private /* synthetic */ ConnectionPool a;
        {
            this.a = connectionPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l2;
            while ((l2 = this.a.a(System.nanoTime())) != -1L) {
                if (l2 <= 0L) continue;
                long l3 = l2 / 1000000L;
                l2 -= l3 * 1000000L;
                ConnectionPool connectionPool = this.a;
                synchronized (connectionPool) {
                    try {
                        this.a.wait(l3, (int)l2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
    };
    private final Deque<RealConnection> f = new ArrayDeque<RealConnection>();
    final RouteDatabase a = new RouteDatabase();
    private boolean g;

    public ConnectionPool() {
        this(5, 5L, TimeUnit.MINUTES);
    }

    public ConnectionPool(int n2, long l2, TimeUnit timeUnit) {
        this.c = n2;
        this.d = timeUnit.toNanos(l2);
        if (l2 <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration <= 0: " + l2);
        }
    }

    public final synchronized int idleConnectionCount() {
        int n2 = 0;
        for (RealConnection realConnection : this.f) {
            if (!realConnection.c.isEmpty()) continue;
            ++n2;
        }
        return n2;
    }

    public final synchronized int connectionCount() {
        return this.f.size();
    }

    final RealConnection a(Address address, StreamAllocation streamAllocation, Route route) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.f) {
            if (!realConnection.isEligible(address, route)) continue;
            streamAllocation.acquire(realConnection, true);
            return realConnection;
        }
        return null;
    }

    final Socket a(Address address, StreamAllocation streamAllocation) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.f) {
            if (!realConnection.isEligible(address, null) || !realConnection.isMultiplexed() || realConnection == streamAllocation.connection()) continue;
            return streamAllocation.releaseAndAcquire(realConnection);
        }
        return null;
    }

    final void a(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (!this.g) {
            this.g = true;
            b.execute(this.e);
        }
        this.f.add(realConnection);
    }

    final boolean b(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (realConnection.a || this.c == 0) {
            this.f.remove(realConnection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        ArrayList<RealConnection> arrayList = new ArrayList<RealConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator<RealConnection> object = this.f.iterator();
            while (object.hasNext()) {
                RealConnection realConnection = object.next();
                if (!realConnection.c.isEmpty()) continue;
                realConnection.a = true;
                arrayList.add(realConnection);
                object.remove();
            }
        }
        for (RealConnection realConnection : arrayList) {
            Util.closeQuietly(realConnection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long a(long l2) {
        int n2 = 0;
        int n3 = 0;
        RealConnection realConnection = null;
        long l3 = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (RealConnection realConnection2 : this.f) {
                int n4;
                block10: {
                    long l4 = l2;
                    RealConnection realConnection3 = realConnection2;
                    ConnectionPool connectionPool2 = this;
                    List<Reference<StreamAllocation>> list = realConnection3.c;
                    int n5 = 0;
                    while (n5 < list.size()) {
                        StreamAllocation.StreamAllocationReference streamAllocationReference = list.get(n5);
                        if (streamAllocationReference.get() != null) {
                            ++n5;
                            continue;
                        }
                        streamAllocationReference = streamAllocationReference;
                        String string = "A connection to " + realConnection3.route().address().url() + " was leaked. Did you forget to close a response body?";
                        Platform.get().logCloseableLeak(string, streamAllocationReference.a);
                        list.remove(n5);
                        realConnection3.a = true;
                        if (!list.isEmpty()) continue;
                        realConnection3.d = l4 - connectionPool2.d;
                        n4 = 0;
                        break block10;
                    }
                    n4 = list.size();
                }
                if (n4 > 0) {
                    ++n2;
                    continue;
                }
                ++n3;
                long l5 = l2 - realConnection2.d;
                if (l5 <= l3) continue;
                l3 = l5;
                realConnection = realConnection2;
            }
            if (l3 < this.d && n3 <= this.c) {
                if (n3 > 0) {
                    return this.d - l3;
                }
                if (n2 > 0) {
                    return this.d;
                }
                this.g = false;
                return -1L;
            }
            this.f.remove(realConnection);
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }
}

